package kr.co.comsquare.util;
 
import java.io.*;
import java.util.*;
import java.text.*; 

public class Utils 
{
	private String file_path = "";
	private static String version = "1.0010";
	public void setFilePath( String file_path ){
		this.file_path = file_path;
	}

	public String getFilePath(){
		return this.file_path;
	}
	
	/**
	 * Էµ ڿ null üũϰ  null  ""( Ʈ) ȯϿ ȯմϴ.
	 *
	 * @param   chk 		nullüũ  ڿ
	 * @return   value		nullüũ  ȯ ڿ
	 */
	public static String chkNull( String chk ){
			String value = chk;

			if( value == null ){
					value = "";
			}else if( value.equals(null) ){
					value = "";
			}

			return value;
	}
	
	
	/**
	 * Էµ ڿ1 null üũϰ  null  ʱⰪ(Էµ ڿ2) ȯϿ ȯմϴ.
	 *
	 * @param   chk 		nullüũ  ڿ
	 * @param   init 		ʱȭ  ڿ
	 * @return   value		nullüũ  ȯ ڿ
	 */
	public static String chkNull( String chk, String init ){
			String value = chk;
			if( value == null ){
					value = init;
			}else if( value.equals(null) ){
					value = init;
			}
			return value;
	}
	
	
	/**
	 * Էµ ڿ "null" üũϰ  "null"  ""( Ʈ) ȯϿ ȯմϴ.
	 *
	 * @param   chk 		nullüũ  ڿ
	 * @return   value		nullüũ  ȯ ڿ
	 */
	public static String chkStrNull( String chk ){
			String value = chk.trim();

			if( "null".equalsIgnoreCase(chk)  ){
					value = "";
			}
			return value;
	}
	
	
	/**
	 * Էµ ڿ KSC5601 ڵ մϴ.
	 *
	 * @param   chk 		ڵ ڿ
	 * @return   value		ȯ ڿ
	 */
	public static String toKor(String chk){
			 String value = "";	
			 try {
					 value = new String(chk.getBytes("8859_1"), "KSC5601");
			 }catch(Exception e) {
					 System.out.println("Exception : " + e);
			 }
			 return value;
	 }
	
	
	/**
	 * ڿ Է ޾ Ͽ մϴ.
	 *
	 * @param   errStr 		Ͽ  ڿ
	 * @throws	IOException  ¿  ߻ 
	 */
	 protected void fileWrite( String errStr ) throws IOException {
		String path = this.file_path + getCurrDate("yyyyMMdd") ;
		File f = new File( path );
		FileWriter fw = null;
		StringBuffer sbf = new StringBuffer();
		RandomAccessFile file = null;
		try{
			if( f.exists() == true ){
					file = new RandomAccessFile ( f, "rw" );    
					int count = file.readInt(); 

					file.skipBytes( count );
					file.writeBytes( errStr ); 
					file.close ( ); 
			}else{
					f.createNewFile();
					file = new RandomAccessFile ( f, "rw" );    
					file.writeBytes( "------------------------START DATE------------------------------" ); 
					file.close ( ); 
			}//end if

		}catch( FileNotFoundException e ){
			System.out.println(e);
		}//end try
	 }
	
	/**java.text.SimpleDateFormat  Date and Time Pattern   ¥ ȯմϴ.
	 * ex) yyyy.MM.dd G 'at' HH:mm:ss z -->  2001.07.04 AD at 12:08:56 PDT
	 *  
	 * @param   format 		ϴ  ¥, ð Ÿ
	 * @return   dateStr		ȯ ¥ ð   ڿ
	 */
	public String getCurrDate( String format ){
		SimpleDateFormat formatter = new java.text.SimpleDateFormat( format );
		String dateStr = formatter.format(new java.util.Date());
		return dateStr;
	}

	/**
	 * Ư ڿ ȯ մϴ.
	 *
	 * @param   str	  ڿ
	 * @param   pattern 	 ڿ
	 * @param   replace 	ϰ ϴ ο ڿ
	 * @return   result 	 ڿ
	 */
    public static String replace(String str, String pattern, String replace) {
        int s = 0, e = 0;
        StringBuffer result = new StringBuffer();

        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e+pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }
    
	/**
	 * 
	 *   xFormsSaxLib version ȮѴ.
	 *
	 * @return   version 	- xFormsSaxLib version
	 */
    
    public static String getVersion()
    {
    	return version;
    }
}
