/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.BoundedChannel;
import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;

public class BoundedBuffer
implements BoundedChannel {
    protected final Object[] array_;
    protected int takePtr_ = 0;
    protected int putPtr_ = 0;
    protected int usedSlots_ = 0;
    protected int emptySlots_;
    protected final Object putMonitor_ = new Object();

    public BoundedBuffer(int capacity) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.array_ = new Object[capacity];
        this.emptySlots_ = capacity;
    }

    public BoundedBuffer() {
        this(DefaultChannelCapacity.get());
    }

    public synchronized int size() {
        return this.usedSlots_;
    }

    public int capacity() {
        return this.array_.length;
    }

    protected void incEmptySlots() {
        Object object = this.putMonitor_;
        synchronized (object) {
            try {
                ++this.emptySlots_;
                this.putMonitor_.notify();
                Object var3_2 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                throw throwable;
            }
        }
    }

    protected synchronized void incUsedSlots() {
        ++this.usedSlots_;
        this.notify();
    }

    protected final void insert(Object x) {
        --this.emptySlots_;
        this.array_[this.putPtr_] = x;
        if (++this.putPtr_ >= this.array_.length) {
            this.putPtr_ = 0;
        }
    }

    protected final Object extract() {
        --this.usedSlots_;
        Object old = this.array_[this.takePtr_];
        this.array_[this.takePtr_] = null;
        if (++this.takePtr_ >= this.array_.length) {
            this.takePtr_ = 0;
        }
        return old;
    }

    public Object peek() {
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            Object var3_6;
            try {
                if (this.usedSlots_ > 0) {
                    Object object = this.array_[this.takePtr_];
                    Object var5_3 = null;
                    return object;
                }
                var3_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
            Object var5_4 = null;
            return var3_6;
        }
    }

    public void put(Object x) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.putMonitor_;
        synchronized (object) {
            try {
                while (this.emptySlots_ <= 0) {
                    try {
                        this.putMonitor_.wait();
                    }
                    catch (InterruptedException ex) {
                        this.putMonitor_.notify();
                        throw ex;
                    }
                }
                this.insert(x);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        this.incUsedSlots();
    }

    public boolean offer(Object x, long msecs) throws InterruptedException {
        if (x == null) {
            throw new IllegalArgumentException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.putMonitor_;
        synchronized (object) {
            try {
                long start = msecs <= (long)0 ? 0L : System.currentTimeMillis();
                long waitTime = msecs;
                while (this.emptySlots_ <= 0) {
                    if (waitTime <= (long)0) {
                        boolean bl = false;
                        Object var12_7 = null;
                        return bl;
                    }
                    try {
                        this.putMonitor_.wait(waitTime);
                    }
                    catch (InterruptedException ex) {
                        this.putMonitor_.notify();
                        throw ex;
                    }
                    waitTime = msecs - (System.currentTimeMillis() - start);
                }
                this.insert(x);
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                throw throwable;
            }
            Object var12_8 = null;
            {
            }
        }
        this.incUsedSlots();
        return true;
    }

    public Object take() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object old = null;
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            try {
                while (this.usedSlots_ <= 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        this.notify();
                        throw ex;
                    }
                }
                old = this.extract();
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        this.incEmptySlots();
        return old;
    }

    public Object poll(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object old = null;
        BoundedBuffer boundedBuffer = this;
        synchronized (boundedBuffer) {
            try {
                long start = msecs <= (long)0 ? 0L : System.currentTimeMillis();
                long waitTime = msecs;
                while (this.usedSlots_ <= 0) {
                    if (waitTime <= (long)0) {
                        Object var9_6 = null;
                        Object var12_7 = null;
                        return var9_6;
                    }
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException ex) {
                        this.notify();
                        throw ex;
                    }
                    waitTime = msecs - (System.currentTimeMillis() - start);
                }
                old = this.extract();
            }
            catch (Throwable throwable) {
                Object var12_9 = null;
                throw throwable;
            }
            Object var12_8 = null;
            {
            }
        }
        this.incEmptySlots();
        return old;
    }
}

