/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Sync;

public class ReentrantLock
implements Sync {
    protected Thread owner_ = null;
    protected long holds_ = 0L;

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Thread caller = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            try {
                if (caller == this.owner_) {
                    ++this.holds_;
                } else {
                    try {
                        while (this.owner_ != null) {
                            this.wait();
                        }
                        this.owner_ = caller;
                        this.holds_ = 1L;
                    }
                    catch (InterruptedException ex) {
                        this.notify();
                        throw ex;
                    }
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Thread caller = Thread.currentThread();
        ReentrantLock reentrantLock = this;
        synchronized (reentrantLock) {
            try {
                if (caller == this.owner_) {
                    ++this.holds_;
                    return true;
                }
                if (this.owner_ == null) {
                    this.owner_ = caller;
                    this.holds_ = 1L;
                    return true;
                }
                if (msecs <= (long)0) {
                    return false;
                }
                long waitTime = msecs;
                long start = System.currentTimeMillis();
                try {
                    do {
                        this.wait(waitTime);
                        if (caller == this.owner_) {
                            ++this.holds_;
                            return true;
                        }
                        if (this.owner_ != null) continue;
                        this.owner_ = caller;
                        this.holds_ = 1L;
                        return true;
                    } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > (long)0);
                    return false;
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                throw throwable;
            }
        }
    }

    public synchronized void release() {
        if (Thread.currentThread() != this.owner_) {
            throw new Error("Illegal Lock usage");
        }
        if (--this.holds_ == (long)0) {
            this.owner_ = null;
            this.notify();
        }
    }

    public synchronized void release(long n) {
        if (Thread.currentThread() != this.owner_ || n > this.holds_) {
            throw new Error("Illegal Lock usage");
        }
        this.holds_ -= n;
        if (this.holds_ == (long)0) {
            this.owner_ = null;
            this.notify();
        }
    }

    public synchronized long holds() {
        if (Thread.currentThread() != this.owner_) {
            return 0L;
        }
        return this.holds_;
    }
}

