/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedVariable;

public class SynchronizedInt
extends SynchronizedVariable
implements Comparable,
Cloneable {
    protected int value_;

    public SynchronizedInt(int initialValue) {
        this.value_ = initialValue;
    }

    public SynchronizedInt(int initialValue, Object lock) {
        super(lock);
        this.value_ = initialValue;
    }

    public final int get() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                int n = this.value_;
                Object var4_3 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public int set(int newValue) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                int old = this.value_;
                this.value_ = newValue;
                int n = old;
                Object var6_5 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                throw throwable;
            }
        }
    }

    public boolean commit(int assumedValue, int newValue) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                boolean success;
                boolean bl = success = assumedValue == this.value_;
                if (success) {
                    this.value_ = newValue;
                }
                boolean bl2 = success;
                Object var7_6 = null;
                return bl2;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int swap(SynchronizedInt other) {
        if (other == this) {
            return this.get();
        }
        SynchronizedInt fst = this;
        SynchronizedInt snd = other;
        if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
            fst = other;
            snd = this;
        }
        Object object = fst.lock_;
        synchronized (object) {
            try {
                Object object2 = snd.lock_;
                synchronized (object2) {
                    try {
                        fst.set(snd.set(fst.get()));
                        return this.get();
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                throw throwable;
            }
        }
    }

    public int increment() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                int n = ++this.value_;
                Object var4_3 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public int decrement() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                int n = --this.value_;
                Object var4_3 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public int add(int amount) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                int n = this.value_ += amount;
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public int subtract(int amount) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                int n = this.value_ -= amount;
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public int multiply(int factor) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                int n = this.value_ *= factor;
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public int divide(int factor) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                int n = this.value_ /= factor;
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public int negate() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                int n = this.value_ = -this.value_;
                Object var4_3 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public int complement() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ ^= 0xFFFFFFFF;
                int n = this.value_;
                Object var4_3 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public int and(int b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ &= b;
                int n = this.value_;
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public int or(int b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ |= b;
                int n = this.value_;
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public int xor(int b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ ^= b;
                int n = this.value_;
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public int compareTo(int other) {
        int val = this.get();
        return val < other ? -1 : (val == other ? 0 : 1);
    }

    public int compareTo(SynchronizedInt other) {
        return this.compareTo(other.get());
    }

    public int compareTo(Object other) {
        return this.compareTo((SynchronizedInt)other);
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SynchronizedInt) {
            return this.get() == ((SynchronizedInt)other).get();
        }
        return false;
    }

    public int hashCode() {
        return this.get();
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

