/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedVariable;

public class SynchronizedLong
extends SynchronizedVariable
implements Comparable,
Cloneable {
    protected long value_;

    public SynchronizedLong(long initialValue) {
        this.value_ = initialValue;
    }

    public SynchronizedLong(long initialValue, Object lock) {
        super(lock);
        this.value_ = initialValue;
    }

    public final long get() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                long l = this.value_;
                Object var5_3 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                throw throwable;
            }
        }
    }

    public long set(long newValue) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                long old = this.value_;
                this.value_ = newValue;
                long l = old;
                Object var9_5 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var9_6 = null;
                throw throwable;
            }
        }
    }

    public boolean commit(long assumedValue, long newValue) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                boolean success;
                boolean bl = success = assumedValue == this.value_;
                if (success) {
                    this.value_ = newValue;
                }
                boolean bl2 = success;
                Object var9_6 = null;
                return bl2;
            }
            catch (Throwable throwable) {
                Object var9_7 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long swap(SynchronizedLong other) {
        if (other == this) {
            return this.get();
        }
        SynchronizedLong fst = this;
        SynchronizedLong snd = other;
        if (System.identityHashCode(fst) > System.identityHashCode(snd)) {
            fst = other;
            snd = this;
        }
        Object object = fst.lock_;
        synchronized (object) {
            try {
                Object object2 = snd.lock_;
                synchronized (object2) {
                    try {
                        fst.set(snd.set(fst.get()));
                        return this.get();
                    }
                    catch (Throwable throwable) {
                        Object var9_8 = null;
                        throw throwable;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                throw throwable;
            }
        }
    }

    public long increment() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                long l = ++this.value_;
                Object var5_3 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                throw throwable;
            }
        }
    }

    public long decrement() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                long l = --this.value_;
                Object var5_3 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                throw throwable;
            }
        }
    }

    public long add(long amount) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                long l = this.value_ += amount;
                Object var7_4 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                throw throwable;
            }
        }
    }

    public long subtract(long amount) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                long l = this.value_ -= amount;
                Object var7_4 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                throw throwable;
            }
        }
    }

    public long multiply(long factor) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                long l = this.value_ *= factor;
                Object var7_4 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                throw throwable;
            }
        }
    }

    public long divide(long factor) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                long l = this.value_ /= factor;
                Object var7_4 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                throw throwable;
            }
        }
    }

    public long negate() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                long l = this.value_ = -this.value_;
                Object var5_3 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                throw throwable;
            }
        }
    }

    public long complement() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ ^= 0L - 1L;
                long l = this.value_;
                Object var5_3 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                throw throwable;
            }
        }
    }

    public long and(long b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ &= b;
                long l = this.value_;
                Object var7_4 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                throw throwable;
            }
        }
    }

    public long or(long b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ |= b;
                long l = this.value_;
                Object var7_4 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                throw throwable;
            }
        }
    }

    public long xor(long b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ ^= b;
                long l = this.value_;
                Object var7_4 = null;
                return l;
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                throw throwable;
            }
        }
    }

    public int compareTo(long other) {
        long val = this.get();
        return val < other ? -1 : (val == other ? 0 : 1);
    }

    public int compareTo(SynchronizedLong other) {
        return this.compareTo(other.get());
    }

    public int compareTo(Object other) {
        return this.compareTo((SynchronizedLong)other);
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof SynchronizedLong) {
            return this.get() == ((SynchronizedLong)other).get();
        }
        return false;
    }

    public int hashCode() {
        long v = this.get();
        return (int)(v ^ v >> 32);
    }

    public String toString() {
        return String.valueOf(this.get());
    }
}

