/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;

public final class WaiterPreferenceSemaphore
extends Semaphore {
    protected long waits_ = 0L;

    public WaiterPreferenceSemaphore(long initial) {
        super(initial);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        WaiterPreferenceSemaphore waiterPreferenceSemaphore = this;
        synchronized (waiterPreferenceSemaphore) {
            try {
                if (this.permits_ > this.waits_) {
                    --this.permits_;
                    return;
                }
                ++this.waits_;
                try {
                    do {
                        this.wait();
                    } while (this.permits_ <= (long)0);
                    --this.waits_;
                    --this.permits_;
                    return;
                }
                catch (InterruptedException ex) {
                    --this.waits_;
                    this.notify();
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        WaiterPreferenceSemaphore waiterPreferenceSemaphore = this;
        synchronized (waiterPreferenceSemaphore) {
            try {
                if (this.permits_ > this.waits_) {
                    --this.permits_;
                    return true;
                }
                if (msecs <= (long)0) {
                    return false;
                }
                ++this.waits_;
                long startTime = System.currentTimeMillis();
                long waitTime = msecs;
                try {
                    do {
                        this.wait(waitTime);
                        if (this.permits_ <= (long)0) continue;
                        --this.waits_;
                        --this.permits_;
                        return true;
                    } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > (long)0);
                    --this.waits_;
                    return false;
                }
                catch (InterruptedException ex) {
                    --this.waits_;
                    this.notify();
                    throw ex;
                }
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                throw throwable;
            }
        }
    }

    public synchronized void release() {
        ++this.permits_;
        this.notify();
    }

    public synchronized void release(long n) {
        this.permits_ += n;
        for (long i = 0L; i < n; ++i) {
            this.notify();
        }
    }
}

