/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.security.authentication.providers;

import com.posdata.glue.security.PosAuthenticationException;
import com.posdata.glue.security.PosAuthenticationUserCookieNotValidException;
import com.posdata.glue.security.PosAuthenticationUserNotFoundException;
import com.posdata.glue.security.PosUserImpl;
import com.posdata.glue.security.authentication.providers.PosAuthenticationToken;
import com.posdata.glue.security.cache.PosFunctionContent;
import com.posdata.glue.security.cache.PosMenuEntryContent;
import com.posdata.glue.security.common.config.PosSecurityConfig;
import com.posdata.glue.security.common.util.auth.PosSecurityHandlerIF;
import com.posdata.glue.security.context.PosSecurityContextHolder;
import com.posdata.glue.security.userdetails.manager.PosUserDetailsService;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.util.Arrays;
import java.util.List;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.providers.AuthenticationProvider;

public class PosAuthenticationProvider
implements AuthenticationProvider {
    private PosLog logger = PosLogFactory.getLogger(this.getClass());
    private PosUserDetailsService userDetailsService;
    protected String skipUrl;
    private String breadCrumbsUrl;
    static /* synthetic */ Class class$com$posdata$glue$security$authentication$providers$PosAuthenticationToken;

    public void init() throws Exception {
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)"Authentication check start");
        }
        try {
            if (this.isSkipUrl(authentication)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.logDebug((Object)"current url is skip URL ");
                }
                return authentication;
            }
            PosUserImpl user = PosSecurityContextHolder.getUserInfo();
            if (user != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.logDebug((Object)"user object exist in session");
                }
                if (authentication.isAuthenticated() && this.isValidUserObject(user, authentication)) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.logDebug((Object)"user object is valid : isAuthenticated = true ,isValidUserObject = true");
                    }
                    user.setFuncKey((String)((PosAuthenticationToken)authentication).getRequestParameter("NS_FKEY"));
                    user.setRespKey((String)((PosAuthenticationToken)authentication).getRequestParameter("NS_RKEY"));
                    this.makeBreadCrumbs(authentication);
                    return authentication;
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.logDebug((Object)"creating user object for authentication");
            }
            this.makeUserObject(authentication);
            authentication.setAuthenticated(true);
            if (this.logger.isDebugEnabled()) {
                this.logger.logDebug((Object)"user has been authenticated");
            }
            this.makeBreadCrumbs(authentication);
        }
        catch (AuthenticationException ae) {
            if (this.logger.isErrorEnabled()) {
                this.logger.logError((Object)"Authentication Error : ", (Throwable)ae);
            }
            throw ae;
        }
        catch (Exception ex) {
            if (this.logger.isErrorEnabled()) {
                this.logger.logError((Object)"Authentication Unexpected Error : ", (Throwable)ex);
            }
            throw new PosAuthenticationException("Authentication Unexpected Error");
        }
        return authentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void makeBreadCrumbs(Authentication authentication) {
        String respKey;
        StringBuffer breadCrumbBuffer;
        block19: {
            block18: {
                breadCrumbBuffer = null;
                respKey = null;
                String[] menuKeys = null;
                try {
                    try {
                        String funcKey;
                        block21: {
                            block20: {
                                respKey = (String)((PosAuthenticationToken)authentication).getRequestParameter("NS_RKEY");
                                menuKeys = null;
                                if (((PosAuthenticationToken)authentication).getRequestParameter("NS_MKEY") instanceof String) {
                                    menuKeys = new String[]{(String)((PosAuthenticationToken)authentication).getRequestParameter("NS_MKEY")};
                                } else if (((PosAuthenticationToken)authentication).getRequestParameter("NS_MKEY") instanceof String[]) {
                                    menuKeys = (String[])((PosAuthenticationToken)authentication).getRequestParameter("NS_MKEY");
                                }
                                funcKey = (String)((PosAuthenticationToken)authentication).getRequestParameter("NS_FKEY");
                                if (respKey == null || menuKeys == null) break block20;
                                if (funcKey != null) break block21;
                            }
                            Object var9_7 = null;
                            if (breadCrumbBuffer == null) return;
                            if (breadCrumbBuffer.length() <= 0) return;
                            ((PosAuthenticationToken)authentication).setRequestAttribute("NS_BREADCRUMB_PROMPTS", breadCrumbBuffer.toString().split(","));
                            ((PosAuthenticationToken)authentication).setRequestAttribute("NS_BREADCRUMB_URL", this.getBreadCrumbsUrl() + "&NS_RKEY=" + respKey);
                            return;
                        }
                        breadCrumbBuffer = new StringBuffer(100);
                        PosMenuEntryContent parentEntryContent = PosSecurityContextHolder.getPosSecureCaheUtil().getRespHierarchyInfoContent(respKey);
                        breadCrumbBuffer.append(parentEntryContent.getApplicableMenuEntryForType().getAttributeValue("ResponsibilityName"));
                        if (menuKeys == null) {
                            PosFunctionContent funcContent = PosSecurityContextHolder.getPosSecureCaheUtil().getFunctionInfoContent(funcKey);
                            breadCrumbBuffer.append("," + funcContent.getFunctionName());
                            break block18;
                        }
                        for (int i = 0; i < menuKeys.length; ++i) {
                            if (parentEntryContent == null) continue;
                            if (parentEntryContent.getSubEntryInfo(menuKeys[i], "Prompt") != null) {
                                breadCrumbBuffer.append("," + parentEntryContent.getSubEntryInfo(menuKeys[i], "Prompt"));
                            }
                            parentEntryContent = parentEntryContent.getMenuEntry(menuKeys[i]);
                        }
                        if (parentEntryContent != null) {
                            breadCrumbBuffer.append("," + parentEntryContent.getSubEntryInfo(funcKey, "Prompt"));
                            break block19;
                        } else {
                            PosFunctionContent funcContent = PosSecurityContextHolder.getPosSecureCaheUtil().getFunctionInfoContent(funcKey);
                            breadCrumbBuffer.append("," + funcContent.getFunctionName());
                        }
                        break block19;
                    }
                    catch (Exception ex) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.logDebug((Object)"BreadCrumbs Error : ", (Throwable)ex);
                        }
                        Object var9_10 = null;
                        if (breadCrumbBuffer == null) return;
                        if (breadCrumbBuffer.length() <= 0) return;
                        ((PosAuthenticationToken)authentication).setRequestAttribute("NS_BREADCRUMB_PROMPTS", breadCrumbBuffer.toString().split(","));
                        ((PosAuthenticationToken)authentication).setRequestAttribute("NS_BREADCRUMB_URL", this.getBreadCrumbsUrl() + "&NS_RKEY=" + respKey);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (breadCrumbBuffer == null) throw throwable;
                    if (breadCrumbBuffer.length() <= 0) throw throwable;
                    ((PosAuthenticationToken)authentication).setRequestAttribute("NS_BREADCRUMB_PROMPTS", breadCrumbBuffer.toString().split(","));
                    ((PosAuthenticationToken)authentication).setRequestAttribute("NS_BREADCRUMB_URL", this.getBreadCrumbsUrl() + "&NS_RKEY=" + respKey);
                    throw throwable;
                }
            }
            Object var9_8 = null;
            if (breadCrumbBuffer == null) return;
            if (breadCrumbBuffer.length() <= 0) return;
            ((PosAuthenticationToken)authentication).setRequestAttribute("NS_BREADCRUMB_PROMPTS", breadCrumbBuffer.toString().split(","));
            ((PosAuthenticationToken)authentication).setRequestAttribute("NS_BREADCRUMB_URL", this.getBreadCrumbsUrl() + "&NS_RKEY=" + respKey);
            return;
        }
        Object var9_9 = null;
        if (breadCrumbBuffer == null) return;
        if (breadCrumbBuffer.length() <= 0) return;
        ((PosAuthenticationToken)authentication).setRequestAttribute("NS_BREADCRUMB_PROMPTS", breadCrumbBuffer.toString().split(","));
        ((PosAuthenticationToken)authentication).setRequestAttribute("NS_BREADCRUMB_URL", this.getBreadCrumbsUrl() + "&NS_RKEY=" + respKey);
    }

    private boolean isSkipUrl(Authentication authentication) {
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("Authorization Skip URL : " + this.getSkipUrls()));
            this.logger.logDebug((Object)("Authorization Current URL : " + ((PosAuthenticationToken)authentication).getCurrentURL()));
        }
        if (this.getSkipUrls() == null) {
            return false;
        }
        return this.getSkipUrls().contains(((PosAuthenticationToken)authentication).getCurrentURL());
    }

    public List getSkipUrls() {
        if (this.skipUrl == null) {
            return null;
        }
        return Arrays.asList(this.skipUrl.split(","));
    }

    private boolean isValidUserObject(PosUserImpl user, Authentication authentication) {
        String reqPlantFlag = (String)((PosAuthenticationToken)authentication).getRequestParameter("plantFlag");
        if (PosSecurityConfig.isDynamicPlantFlag() && reqPlantFlag != null && !reqPlantFlag.equals(user.getPlantFlag())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.logDebug((Object)"reqPlantFlag is different from userObject's plantFlag");
            }
            return false;
        }
        return this.isEqualToUserParam(user, authentication);
    }

    private void makeUserObject(Authentication authentication) {
        if (PosSecurityConfig.getLevel() == 0) {
            if (this.logger.isDebugEnabled()) {
                this.logger.logDebug((Object)"security level is zero(0) , creating default userobject");
            }
            ((PosAuthenticationToken)authentication).setPrincipal("PD088888");
            ((PosAuthenticationToken)authentication).setDetails(this.userDetailsService.getDefaultUserDetails());
            return;
        }
        String userEmpNo = this.getUserEmpNoFromAuthentication(authentication);
        if (userEmpNo == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.logError((Object)"userid is not found from cookie");
            }
            throw new PosAuthenticationUserNotFoundException("userid is not found from cookie");
        }
        PosUserImpl user = this.userDetailsService.getUserDetails(userEmpNo, this.makePlantFlag((String)((PosAuthenticationToken)authentication).getRequestParameter("plantFlag")));
        user.setFuncKey((String)((PosAuthenticationToken)authentication).getRequestParameter("NS_FKEY"));
        user.setRespKey((String)((PosAuthenticationToken)authentication).getRequestParameter("NS_RKEY"));
        ((PosAuthenticationToken)authentication).setPrincipal(userEmpNo);
        ((PosAuthenticationToken)authentication).setDetails(user);
    }

    private String makePlantFlag(String reqPlantFlag) {
        if (PosSecurityConfig.isDynamicPlantFlag()) {
            if (reqPlantFlag == null) {
                return PosSecurityConfig.getPlantFlag();
            }
            return reqPlantFlag;
        }
        return PosSecurityConfig.getPlantFlag();
    }

    private String getUserEmpNoFromAuthentication(Authentication authentication) {
        try {
            PosSecurityHandlerIF posSecurityHandlerIF = ((PosAuthenticationToken)authentication).getSecurityHandlerIF();
            if (posSecurityHandlerIF == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.logError((Object)"PosSecurityHandlerIF is null");
                }
                throw new Exception("PosSecurityHandlerIF is not found");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.logDebug((Object)("PosSecurityHandlerIF class : " + posSecurityHandlerIF.getClass().getName()));
            }
            return posSecurityHandlerIF.getUserEmpNo();
        }
        catch (Exception ex) {
            if (this.logger.isErrorEnabled()) {
                this.logger.logError((Object)"Getting user cookie in sso library is failure ", (Throwable)ex);
            }
            throw new PosAuthenticationUserCookieNotValidException("user Cookie is not valid", ex);
        }
    }

    private boolean isEqualToUserParam(PosUserImpl user, Authentication authentication) {
        if (user == null || authentication == null || user.getUserEmpNo() == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.logError((Object)"userobject,authentication and userEmpNo in userobject are null");
            }
            throw new PosAuthenticationUserNotFoundException("user must be authenticated");
        }
        return user.getUserEmpNo().equals(this.getUserEmpNoFromAuthentication(authentication));
    }

    public boolean supports(Class authentication) {
        return (class$com$posdata$glue$security$authentication$providers$PosAuthenticationToken == null ? (class$com$posdata$glue$security$authentication$providers$PosAuthenticationToken = PosAuthenticationProvider.class$("com.posdata.glue.security.authentication.providers.PosAuthenticationToken")) : class$com$posdata$glue$security$authentication$providers$PosAuthenticationToken).isAssignableFrom(authentication);
    }

    public void setUserDetailsService(PosUserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public String getSkipUrl() {
        return this.skipUrl;
    }

    public void setSkipUrl(String skipUrl) {
        this.skipUrl = skipUrl;
    }

    public String getBreadCrumbsUrl() {
        return this.breadCrumbsUrl;
    }

    public void setBreadCrumbsUrl(String breadCrumbsUrl) {
        this.breadCrumbsUrl = breadCrumbsUrl;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

