/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.security.authentication.providers;

import com.posdata.glue.security.common.util.PosSecureCacheUtil;
import com.posdata.glue.security.common.util.auth.PosAuthFactory;
import com.posdata.glue.security.common.util.auth.PosSecurityHandlerIF;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.providers.AbstractAuthenticationToken;

public class PosAuthenticationToken
extends AbstractAuthenticationToken {
    private HttpServletRequest request;
    private Object credentials;
    private Object principal;
    private PosSecurityHandlerIF posSecurityHandlerIF;
    private PosSecureCacheUtil posSecureCaheUtil;

    public PosAuthenticationToken() {
    }

    public PosAuthenticationToken(Object principal, Object credentials) {
        super(null);
        this.principal = principal;
        this.credentials = credentials;
        this.setAuthenticated(false);
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
        this.posSecurityHandlerIF = PosAuthFactory.getSecurityHandler("DISPLAY_TYPE_JSP", new Object[]{request});
    }

    public void setPrincipal(Object principal) {
        this.principal = principal;
    }

    public Object getRequestParameter(String key) {
        if (this.request == null) {
            return null;
        }
        return this.request.getParameter(key);
    }

    public Object getRequestAttribute(String key) {
        if (this.request == null) {
            return null;
        }
        return this.request.getAttribute(key);
    }

    public Map getRequestParameterMap() {
        if (this.request == null) {
            return null;
        }
        return this.request.getParameterMap();
    }

    public String getCurrentURL() {
        if (this.request == null) {
            return null;
        }
        return this.request.getRequestURI();
    }

    public void setRequestAttribute(String key, Object value) {
        if (this.request == null) {
            return;
        }
        this.request.setAttribute(key, value);
    }

    public PosSecurityHandlerIF getSecurityHandlerIF() {
        return this.posSecurityHandlerIF;
    }

    public PosSecureCacheUtil getPosSecureCaheUtil() {
        return this.posSecureCaheUtil;
    }

    public void setPosSecureCaheUtil(PosSecureCacheUtil posSecureCaheUtil) {
        this.posSecureCaheUtil = posSecureCaheUtil;
    }
}

