/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.biz.control;

import com.posdata.glue.PosException;
import com.posdata.glue.biz.control.PosActivityHandler;
import com.posdata.glue.biz.control.PosBizControlIF;
import com.posdata.glue.biz.control.PosService;
import com.posdata.glue.biz.control.PosServiceLoader;
import com.posdata.glue.context.PosContext;
import com.posdata.glue.dao.vo.PosAuditAttributes;
import com.posdata.glue.transaction.PosTransactionManager;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import com.posdata.glue.web.security.PosUserIF;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PosBizController
implements PosBizControlIF {
    private static PosBizController a = null;
    private PosLog b = PosLogFactory.getLogger(this.getClass());
    private PosServiceLoader c;

    private PosBizController() {
        try {
            this.c = (PosServiceLoader)PosContext.getBeanFactory().getBeanObject("serviceLoader");
        }
        catch (Exception exception) {
            this.c = new PosServiceLoader();
        }
    }

    public static PosBizControlIF getController() {
        if (a == null) {
            a = new PosBizController();
        }
        return a;
    }

    private void startTransaction(List list) throws Throwable {
        Map map = null;
        PosTransactionManager posTransactionManager = null;
        try {
            int n = 0;
            while (n < list.size()) {
                map = (Map)list.get(n);
                posTransactionManager = (PosTransactionManager)PosContext.getBeanFactory().getBeanObject((String)map.get("id"));
                if (posTransactionManager != null) {
                    posTransactionManager.startTransaction();
                    this.b.logDebug("Start TX : " + (String)map.get("id"));
                }
                ++n;
            }
        }
        catch (Throwable throwable) {
            list.clear();
            throw throwable;
        }
    }

    private void commitTransactions(List list) {
        Map map = null;
        PosTransactionManager posTransactionManager = null;
        int n = 0;
        while (n < list.size()) {
            map = (Map)list.get(n);
            if ("true".equalsIgnoreCase((String)map.get("commit"))) {
                posTransactionManager = (PosTransactionManager)PosContext.getBeanFactory().getBeanObject((String)map.get("id"));
                posTransactionManager.commit();
                this.b.logDebug("Commit TX : " + (String)map.get("id"));
            }
            ++n;
        }
    }

    private void rollbackTransactions(List list) {
        Map map = null;
        PosTransactionManager posTransactionManager = null;
        int n = 0;
        while (n < list.size()) {
            map = (Map)list.get(n);
            posTransactionManager = (PosTransactionManager)PosContext.getBeanFactory().getBeanObject((String)map.get("id"));
            if (posTransactionManager != null) {
                try {
                    posTransactionManager.rollback();
                }
                catch (Exception exception) {
                    this.b.logError("Rollback Transaction Error: " + exception.getMessage(), exception);
                }
                this.b.logDebug("Rollback TX : " + (String)map.get("id"));
            }
            ++n;
        }
    }

    private void clearTransactionStatus(List list) {
        Map map = null;
        PosTransactionManager posTransactionManager = null;
        int n = 0;
        while (n < list.size()) {
            map = (Map)list.get(n);
            posTransactionManager = (PosTransactionManager)PosContext.getBeanFactory().getBeanObject((String)map.get("id"));
            if (posTransactionManager != null) {
                posTransactionManager.clearTransactionStatus();
            }
            ++n;
        }
    }

    public PosContext doAction(PosContext posContext) {
        List list = null;
        String string = (String)posContext.get("ServiceName");
        this.setAudit(posContext);
        if (string == null) {
            throw new PosException("ServiceName isn't exist");
        }
        long l = System.currentTimeMillis();
        this.b.logInfo("ServiceName:[" + string + "] StartTime[" + new Date(l) + "]");
        try {
            try {
                PosService posService = this.c.findService(string);
                list = posService.getTransactionManagers();
                this.startTransaction(list);
                posContext.put(string, posService);
                PosActivityHandler posActivityHandler = posService.getActivityHandler(posService.getInitialActivity());
                String string2 = null;
                while (!"end".equals(string2 = posActivityHandler.runActivity(posContext))) {
                    posActivityHandler = posService.getActivityHandler(string2);
                }
                this.commitTransactions(list);
            }
            catch (Throwable throwable) {
                if (list != null) {
                    this.rollbackTransactions(list);
                }
                long l2 = System.currentTimeMillis();
                this.b.logFatal("Error! ServiceName:[" + string + "] EndTime[" + new Date(l2) + "] RunTime:[" + (l2 - l) + "]", throwable);
                throw new PosException(throwable.getMessage(), throwable);
            }
        }
        catch (Throwable throwable) {
            if (list != null) {
                this.clearTransactionStatus(list);
            }
            throw throwable;
        }
        if (list != null) {
            this.clearTransactionStatus(list);
        }
        long l3 = System.currentTimeMillis();
        this.b.logInfo("ServiceName:[" + string + "] EndTime[" + new Date(l3) + "] RunTime:[" + (l3 - l) + "]");
        return posContext;
    }

    public PosContext doSubController(PosContext posContext, boolean bl) {
        List list = null;
        String string = Thread.currentThread().toString();
        String string2 = (String)posContext.get("ServiceName");
        long l = System.currentTimeMillis();
        this.b.logInfo("SubServiceName:[" + string2 + "] StartTime[" + new Date(l) + "]");
        try {
            try {
                if (string2 == null) {
                    throw new Exception("ServiceName isn't exist");
                }
                PosService posService = this.c.findService(string2);
                list = posService.getTransactionManagers();
                if (bl) {
                    this.startTransaction(list);
                }
                posContext.put(string2, posService);
                PosActivityHandler posActivityHandler = posService.getActivityHandler(posService.getInitialActivity());
                String string3 = null;
                while (!"end".equals(string3 = posActivityHandler.runActivity(posContext))) {
                    posActivityHandler = posService.getActivityHandler(string3);
                }
                if (bl) {
                    this.commitTransactions(list);
                }
            }
            catch (Throwable throwable) {
                if (bl) {
                    this.rollbackTransactions(list);
                }
                long l2 = System.currentTimeMillis();
                this.b.logInfo("SubServiceName:[" + string2 + "] EndTime[" + new Date(l2) + "] RunTime:[" + (l2 - l) + "]");
                throw new PosException(throwable.getMessage(), throwable);
            }
        }
        catch (Throwable throwable) {
            if (bl) {
                this.clearTransactionStatus(list);
            }
            throw throwable;
        }
        if (bl) {
            this.clearTransactionStatus(list);
        }
        long l3 = System.currentTimeMillis();
        this.b.logInfo("SubServiceName:[" + string2 + "] EndTime[" + new Date(l3) + "] RunTime:[" + (l3 - l) + "]");
        return posContext;
    }

    protected void setAudit(PosContext posContext) throws PosException {
        String string = PosContext.getGlueProperty("audit.insert.key");
        String string2 = PosContext.getGlueProperty("audit.update.key");
        String[] stringArray = null;
        String[] stringArray2 = null;
        PosAuditAttributes posAuditAttributes = null;
        if (string != null && string2 != null) {
            stringArray = string.split(",");
            stringArray2 = string2.split(",");
            posAuditAttributes = new PosAuditAttributes(stringArray, stringArray2, posContext);
        } else {
            String string3 = (String)posContext.get("ServiceName");
            String string4 = "C";
            Object object = posContext.getSessionUserData("Security_User_Info");
            String string5 = "unkown";
            if (object != null) {
                string4 = "A";
                string5 = ((PosUserIF)object).getUserID();
            } else if (posContext.getMessage() != null) {
                string4 = "B";
                string5 = posContext.getMessage().getTCID();
            } else if (posContext.isEdgeServerEvent()) {
                string4 = "B";
                string5 = (String)posContext.get("TRANSACTION_CODE");
            }
            posAuditAttributes = new PosAuditAttributes(string4, string5, string3);
        }
        posContext.setAuditAttribute(posAuditAttributes);
    }
}

