/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.component;

import com.posdata.glue.component.PosComponentImpl;
import com.posdata.glue.component.PosMessageParserException;
import com.posdata.glue.component.layout.PosMessageLayoutIF;
import com.posdata.glue.context.PosContext;
import com.posdata.glue.msg.PosMessage;
import com.posdata.glue.msg.PosMessageDefinition;
import com.posdata.glue.msg.util.PosMessageUtil;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;

public class PosFileMessageParser
extends PosComponentImpl {
    private static PosFileMessageParser b = new PosFileMessageParser();
    private PosLog c;
    static Class a;

    public PosFileMessageParser() {
        Class<?> clazz = a;
        if (clazz == null) {
            try {
                clazz = a = Class.forName("com.posdata.glue.component.PosFileMessageParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.c = PosLogFactory.getLogger(clazz);
    }

    public static PosFileMessageParser getInstance() {
        return b;
    }

    public PosContext doProcess(PosContext posContext) {
        try {
            return this.parseFileMessage(posContext);
        }
        catch (Exception exception) {
            this.c.logError("Parse File Message Exception - " + exception.getMessage());
            return posContext;
        }
    }

    public PosContext parseFileMessage(PosContext posContext) throws PosMessageParserException {
        if (this.c.isDebugEnabled()) {
            this.c.logDebug("parseFileMessage method is called.");
        }
        try {
            if (this.c.isDebugEnabled()) {
                this.c.logDebug("XML parseFileMessage method is called.");
            }
            posContext = PosMessageUtil.readFile(posContext);
            PosMessage[] posMessageArray = posContext.getMessages();
            PosMessageLayoutIF posMessageLayoutIF = this.getMessageLayoutImpl(posContext);
            posMessageArray[0].setTCID(PosMessageUtil.substringByte(posMessageArray[0].getTC(), 0, 8));
            posContext.setMessage(posMessageArray[0]);
            String string = PosContext.getGlueProperty("msg.parsing.type");
            posMessageLayoutIF.setMsgParsingType(string);
            PosMessageDefinition posMessageDefinition = posMessageLayoutIF.getAttributes(posContext);
            int n = 0;
            while (n < posMessageArray.length) {
                posMessageArray[n] = posMessageLayoutIF.makeMessageParsing(posMessageDefinition, posMessageArray[n]);
                ++n;
            }
            if (this.c.isDebugEnabled()) {
                this.c.logDebug("XML File Message parsing is ok.");
            }
            posContext.setMessages(posMessageArray);
        }
        catch (PosMessageParserException posMessageParserException) {
            throw posMessageParserException;
        }
        catch (Exception exception) {
            throw new PosMessageParserException("File Message Parsing Error!! - " + exception.getMessage(), exception);
        }
        return posContext;
    }
}

