/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.dao.manager;

import com.posdata.glue.PosException;
import com.posdata.glue.cache.PosCacheLoader;
import com.posdata.glue.dao.manager.PosQueryDefinition;
import com.posdata.glue.util.PosFileResourceUtil;
import com.posdata.glue.util.PosGlueUtil;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import com.posdata.glue.util.xml.PosDOMParser;
import com.posdata.glue.util.xml.PosXMLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class PosQueryLoader
implements PosCacheLoader {
    protected static final String CONFIG_PATH = String.valueOf(System.getProperty("CONFIG_PATH")) + File.separator;
    protected PosLog logger;
    private String b;
    private boolean c;
    public static final String QUERY_POSTPIX = "-query.xml";
    public static final String QUERY_POSTPIX_NEW = "-query.glue_sql";
    static Class a;

    public PosQueryLoader() {
        Class<?> clazz = a;
        if (clazz == null) {
            try {
                clazz = a = Class.forName("com.posdata.glue.dao.manager.PosQueryLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.logger = PosLogFactory.getLogger(clazz);
        this.b = "query";
        this.c = false;
    }

    public Object loadCacheObject(Object object, String string) throws PosException {
        HashMap hashMap = new HashMap();
        String[] stringArray = this.getQueryFilesFromSubDirectory();
        int n = 0;
        while (n < stringArray.length) {
            PosXMLUtil posXMLUtil = new PosXMLUtil(new PosDOMParser());
            Map map = null;
            Map map2 = null;
            try {
                map = posXMLUtil.loadXMLFromClasspath(stringArray[n]);
                map2 = this.createQueryMap((Map)map.get("queryMap"));
            }
            catch (Exception exception) {
                this.logger.logError("Fail to load query file: " + stringArray[n], exception);
            }
            hashMap.putAll(map2);
            ++n;
        }
        return hashMap;
    }

    protected Map createQueryMap(Map map) {
        Object v = map.get("query");
        List list = null;
        Map map2 = null;
        HashMap<String, PosQueryDefinition> hashMap = new HashMap<String, PosQueryDefinition>();
        if (v != null && v instanceof List) {
            list = (List)v;
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                map2 = (Map)list.get(n2);
                String string = (String)map2.get("id");
                String string2 = (String)map2.get("#text");
                String string3 = (String)map2.get("fetchSize");
                PosQueryDefinition posQueryDefinition = new PosQueryDefinition(string, string2, string3);
                hashMap.put(string, posQueryDefinition);
                ++n2;
            }
        } else {
            map2 = (Map)v;
            String string = (String)map2.get("id");
            String string4 = (String)map2.get("#text");
            String string5 = (String)map2.get("fetchSize");
            PosQueryDefinition posQueryDefinition = new PosQueryDefinition(string, string4, string5);
            hashMap.put(string, posQueryDefinition);
        }
        return hashMap;
    }

    protected String[] getQueryFiles() {
        File[] fileArray = new File(CONFIG_PATH).listFiles(new PosQueryFileNameFilter(this, null));
        if (fileArray == null) {
            this.logger.logError("Fail to load query files: file is null");
            return new String[1];
        }
        String[] stringArray = new String[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            stringArray[n] = fileArray[n].getAbsolutePath();
            ++n;
        }
        return stringArray;
    }

    protected String[] getQueryFilesFromClasspath() {
        String[] stringArray;
        ArrayList<String> arrayList;
        block16: {
            URL uRL = PosFileResourceUtil.getResource(this.b);
            BufferedReader bufferedReader = null;
            arrayList = new ArrayList<String>();
            try {
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                    stringArray = bufferedReader.readLine();
                    while (stringArray != null) {
                        if (stringArray.endsWith(QUERY_POSTPIX_NEW) || stringArray.endsWith(QUERY_POSTPIX)) {
                            arrayList.add("query/" + (String)stringArray);
                        }
                        stringArray = bufferedReader.readLine();
                    }
                }
                catch (Exception exception) {
                    this.logger.logError("Fail to load query files: " + exception.getMessage(), exception);
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block16;
                    }
                    catch (Exception exception2) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.logger.logInfo("Loading query file(s) from class path " + ((Object)arrayList).toString());
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String[] getQueryFilesFromSubDirectory() {
        String[] stringArray;
        URL uRL = PosFileResourceUtil.getResource(this.b);
        List list = new ArrayList();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string = uRL.getPath();
        String string2 = System.getProperty("os.name").toLowerCase();
        if (string != null && string.startsWith("file:/")) {
            string = string.substring(6);
        }
        try {
            string = URLDecoder.decode(string, "UTF-8");
            this.logger.logInfo("Query Files Root Path: " + string);
            stringArray = new File(string);
            if (!(stringArray == null || stringArray.canRead() && stringArray.isDirectory())) {
                this.logger.logFatal("Can not load Query Files from [" + string + "]! CanRead [" + stringArray.canRead() + "] IsDir [" + stringArray.isDirectory() + "]");
                this.logger.logWarn("Try loading Query Files from Jar!");
                if (!string2.startsWith("window") && !string.startsWith("/")) {
                    string = "/" + string;
                }
                int n = string.indexOf(".jar");
                String string3 = null;
                if (n == -1) throw new PosException("Query File is not exist! [" + string + "]");
                string3 = string.substring(0, n + 4);
                JarFile jarFile = null;
                jarFile = new JarFile(new File(string3));
                Enumeration<JarEntry> enumeration = jarFile.entries();
                ZipEntry zipEntry = null;
                String string4 = null;
                Object var14_19 = null;
                Object var15_20 = null;
                while (enumeration.hasMoreElements()) {
                    zipEntry = enumeration.nextElement();
                    string4 = zipEntry.getName();
                    if (string4.endsWith(QUERY_POSTPIX_NEW)) {
                        arrayList2.add(string4);
                        continue;
                    }
                    if (!string4.endsWith(QUERY_POSTPIX)) continue;
                    arrayList.add(string4);
                }
            } else {
                list = PosGlueUtil.getListOfFiles(new File(string));
                int n = 0;
                while (n < list.size()) {
                    int n2;
                    File file = (File)list.get(n);
                    String string5 = file.getPath();
                    if (string5.endsWith(QUERY_POSTPIX_NEW)) {
                        n2 = string5.indexOf("classes" + File.separator + this.b);
                        string5 = string5.substring(n2 + 8);
                        arrayList2.add(string5);
                    } else if (string5.endsWith(QUERY_POSTPIX)) {
                        n2 = string5.indexOf("classes" + File.separator + this.b);
                        string5 = string5.substring(n2 + 8);
                        arrayList.add(string5);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PosException("Unable to load query files: " + exception.getMessage(), exception);
        }
        if (arrayList2.size() < 1 && arrayList.size() < 1) {
            throw new PosException("Query File is not exist! [" + string + "]");
        }
        if (arrayList2.size() > 0 && arrayList.size() > 0) {
            this.logger.logFatal("Both of the query file types [-query.xml, -query.glue_sql] is exist!");
            this.logger.logFatal("This WAS will accept only \"-query.glue_sql\" file type !");
        }
        if (arrayList2.size() > 0) {
            this.logger.logInfo("Loading query file(s) from class path " + ((Object)arrayList2).toString());
            stringArray = new String[arrayList2.size()];
            return arrayList2.toArray(stringArray);
        }
        this.logger.logInfo("Loading query file(s) from class path " + ((Object)arrayList).toString());
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    private boolean isItIncludedWhereClause(String string) {
        return string.indexOf("where ") != -1 && string.indexOf("WHERE ") != -1;
    }

    public void setRootPath(String string) {
        this.b = string;
    }

    public void setScanSubDir(boolean bl) {
        this.c = bl;
    }

    public String getRootPath() {
        return this.b;
    }

    public boolean isScanSubDir() {
        return this.c;
    }

    private class PosQueryFileNameFilter
    implements FilenameFilter {
        final PosQueryLoader a;

        private PosQueryFileNameFilter(PosQueryLoader posQueryLoader) {
            this.a = posQueryLoader;
        }

        public boolean accept(File file, String string) {
            if (file == null) {
                return false;
            }
            return string.endsWith(PosQueryLoader.QUERY_POSTPIX_NEW) || string.endsWith(PosQueryLoader.QUERY_POSTPIX);
        }

        PosQueryFileNameFilter(PosQueryLoader posQueryLoader, PosQueryFileNameFilter posQueryFileNameFilter) {
            this(posQueryLoader);
        }
    }
}

