/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.scheduling.server;

import com.posdata.glue.scheduling.server.PosHttpRequestMessage;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.apache.mina.filter.codec.demux.MessageDecoderAdapter;
import org.apache.mina.filter.codec.demux.MessageDecoderResult;
import org.apache.mina.util.CharsetUtil;

public class PosHttpRequestDecoder
extends MessageDecoderAdapter {
    private static final byte[] a = new String("Content-Length:").getBytes();
    private CharsetDecoder b;
    private PosHttpRequestMessage c = null;
    private String d;
    protected PosLog log = PosLogFactory.getLogger(((Object)((Object)this)).getClass());

    public PosHttpRequestDecoder() {
        this.b = CharsetUtil.getDefaultCharset().newDecoder();
        this.d = this.getUrlDecoderCharset();
        this.log.logDebug("URL Decoder Charset : " + this.d);
    }

    private String getUrlDecoderCharset() {
        String string = "euc-kr";
        try {
            string = System.getProperty("glue.scheduler.server.urldecoder.charset");
            string = string == null || "".equals(string) ? "euc-kr" : string;
        }
        catch (Exception exception) {
            this.log.logWarn("Fail to get url decoder charset:" + exception.getMessage());
            this.log.logWarn("Default charset is applied 'euc-kr'");
        }
        return string;
    }

    public MessageDecoderResult decodable(IoSession ioSession, ByteBuffer byteBuffer) {
        try {
            return this.messageComplete(byteBuffer) ? MessageDecoderResult.OK : MessageDecoderResult.NEED_DATA;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return MessageDecoderResult.NOT_OK;
        }
    }

    public MessageDecoderResult decode(IoSession ioSession, ByteBuffer byteBuffer, ProtocolDecoderOutput protocolDecoderOutput) throws Exception {
        PosHttpRequestMessage posHttpRequestMessage = this.decodeBody(byteBuffer);
        if (posHttpRequestMessage == null) {
            return MessageDecoderResult.NEED_DATA;
        }
        protocolDecoderOutput.write((Object)posHttpRequestMessage);
        return MessageDecoderResult.OK;
    }

    private boolean messageComplete(ByteBuffer byteBuffer) throws Exception {
        int n = byteBuffer.remaining() - 1;
        if (byteBuffer.remaining() < 4) {
            return false;
        }
        if (byteBuffer.get(0) == 71 && byteBuffer.get(1) == 69 && byteBuffer.get(2) == 84) {
            return byteBuffer.get(n) == 10 && byteBuffer.get(n - 1) == 13 && byteBuffer.get(n - 2) == 10 && byteBuffer.get(n - 3) == 13;
        }
        if (byteBuffer.get(0) == 80 && byteBuffer.get(1) == 79 && byteBuffer.get(2) == 83 && byteBuffer.get(3) == 84) {
            int n2 = -1;
            int n3 = n;
            while (n3 > 2) {
                if (byteBuffer.get(n3) == 10 && byteBuffer.get(n3 - 1) == 13 && byteBuffer.get(n3 - 2) == 10 && byteBuffer.get(n3 - 3) == 13) {
                    n2 = n3 + 1;
                    break;
                }
                --n3;
            }
            if (n2 == -1) {
                return false;
            }
            n3 = 0;
            while (n3 < n) {
                boolean bl = false;
                int n4 = 0;
                while (n4 < a.length) {
                    if (byteBuffer.get(n3 + n4) != a[n4]) {
                        bl = false;
                        break;
                    }
                    bl = true;
                    ++n4;
                }
                if (bl) {
                    StringBuffer stringBuffer = new StringBuffer();
                    int n5 = n3 + a.length;
                    while (n5 < n) {
                        if (byteBuffer.get(n5) == 13) break;
                        stringBuffer.append(new String(new byte[]{byteBuffer.get(n5)}));
                        ++n5;
                    }
                    return Integer.parseInt(stringBuffer.toString().trim()) + n2 == byteBuffer.remaining();
                }
                ++n3;
            }
        }
        return false;
    }

    private Map decodeRequestParameters(Map map) throws UnsupportedEncodingException {
        HashMap hashMap = new HashMap(map.size());
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object object;
            Object k = iterator.next();
            Object v = map.get(k);
            String string = null;
            string = v instanceof String[] ? (((String[])(object = (String[])v)).length == 0 ? "" : object[0]) : (String)v;
            object = URLDecoder.decode(string, this.d);
            hashMap.put(k, new String[]{object});
        }
        return hashMap;
    }

    protected String summarizeParsedRequestMap(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            String[] stringArray = (String[])map.get(k);
            String string = stringArray.length == 0 ? "" : stringArray[0];
            stringBuffer.append(k).append("=").append(string).append(",");
        }
        return stringBuffer.toString();
    }

    private PosHttpRequestMessage decodeBody(ByteBuffer byteBuffer) {
        this.c = new PosHttpRequestMessage();
        try {
            Map map = this.parseRequest(new StringReader(byteBuffer.getString(this.b)));
            try {
                map = this.decodeRequestParameters(map);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.log.logError("Cannot decode parsedRequests:" + unsupportedEncodingException.getMessage());
            }
            this.c.setHeaders(map);
            return this.c;
        }
        catch (CharacterCodingException characterCodingException) {
            this.log.logError(characterCodingException.getMessage(), characterCodingException);
            return null;
        }
    }

    private Map parseRequest(Reader reader) {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String string = bufferedReader.readLine();
            String[] stringArray = string.split(" ");
            if (stringArray.length < 3) {
                return hashMap;
            }
            hashMap.put("URI", new String[]{string});
            hashMap.put("Method", new String[]{stringArray[0].toUpperCase()});
            hashMap.put("Context", new String[]{stringArray[1].substring(1)});
            hashMap.put("Protocol", new String[]{stringArray[2]});
            while ((string = bufferedReader.readLine()) != null && string.length() > 0) {
                String[] stringArray2 = string.split(": ");
                hashMap.put(stringArray2[0], new String[]{stringArray2[1]});
            }
            if (stringArray[0].equalsIgnoreCase("POST")) {
                int n = Integer.parseInt(((String[])hashMap.get("Content-Length"))[0]);
                char[] cArray = new char[n];
                if (bufferedReader.read(cArray) == n) {
                    string = String.copyValueOf(cArray);
                }
            } else if (stringArray[0].equalsIgnoreCase("GET")) {
                int n = stringArray[1].indexOf(63);
                if (n != -1) {
                    hashMap.put("Context", new String[]{stringArray[1].substring(1, n)});
                    string = stringArray[1].substring(n + 1);
                } else {
                    string = null;
                }
            }
            if (string != null) {
                String[] stringArray3 = string.split("\\&");
                int n = 0;
                while (n < stringArray3.length) {
                    String[] stringArray4 = new String[1];
                    String[] stringArray5 = stringArray3[n].split("=");
                    switch (stringArray5.length) {
                        case 0: {
                            hashMap.put("@".concat(stringArray3[n]), new String[0]);
                            break;
                        }
                        case 1: {
                            hashMap.put("@".concat(stringArray5[0]), new String[0]);
                            break;
                        }
                        default: {
                            String string2 = "@".concat(stringArray5[0]);
                            if (hashMap.containsKey(string2)) {
                                stringArray4 = (String[])hashMap.get(string2);
                                String[] stringArray6 = new String[stringArray4.length + 1];
                                int n2 = 0;
                                while (n2 < stringArray4.length) {
                                    stringArray6[n2] = stringArray4[n2];
                                    ++n2;
                                }
                                stringArray4 = null;
                                stringArray4 = stringArray6;
                            }
                            stringArray4[stringArray4.length - 1] = stringArray5[1].trim();
                            hashMap.put(string2, stringArray4);
                        }
                    }
                    ++n;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return hashMap;
    }
}

