/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.jdbc;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheManager;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCache;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.jcs.auxiliary.disk.jdbc.ShrinkerThread;

public class JDBCDiskCacheManager
implements AuxiliaryCacheManager {
    private static final long serialVersionUID = -8258856770927857896L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCacheManager == null ? (class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCacheManager = JDBCDiskCacheManager.class$("org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCacheManager")) : class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCacheManager));
    private static int clients;
    private static Hashtable caches;
    private static JDBCDiskCacheManager instance;
    private JDBCDiskCacheAttributes defaultCattr;
    private ClockDaemon shrinkerDaemon;
    private Map shrinkerThreadMap = new Hashtable();
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCacheManager;

    private JDBCDiskCacheManager(JDBCDiskCacheAttributes cattr) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Creating JDBCDiskCacheManager with " + cattr));
        }
        this.defaultCattr = cattr;
    }

    public JDBCDiskCacheAttributes getDefaultCattr() {
        return this.defaultCattr;
    }

    public static JDBCDiskCacheManager getInstance(JDBCDiskCacheAttributes cattr) {
        Class clazz = class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCacheManager == null ? (class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCacheManager = JDBCDiskCacheManager.class$("org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCacheManager")) : class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCacheManager;
        synchronized (clazz) {
            if (instance == null) {
                instance = new JDBCDiskCacheManager(cattr);
            }
        }
        ++clients;
        return instance;
    }

    public AuxiliaryCache getCache(String cacheName) {
        JDBCDiskCacheAttributes cattr = (JDBCDiskCacheAttributes)this.defaultCattr.copy();
        cattr.setCacheName(cacheName);
        return this.getCache(cattr);
    }

    public AuxiliaryCache getCache(JDBCDiskCacheAttributes cattr) {
        AuxiliaryCache raf = null;
        log.debug((Object)("cacheName = " + cattr.getCacheName()));
        Hashtable hashtable = caches;
        synchronized (hashtable) {
            raf = (AuxiliaryCache)caches.get(cattr.getCacheName());
            if (raf == null) {
                raf = new JDBCDiskCache(cattr);
                caches.put(cattr.getCacheName(), raf);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("JDBC cache = " + raf));
        }
        if (cattr.isUseDiskShrinker()) {
            ShrinkerThread shrinkerThread;
            if (this.shrinkerDaemon == null) {
                this.shrinkerDaemon = new ClockDaemon();
                this.shrinkerDaemon.setThreadFactory((ThreadFactory)new MyThreadFactory());
            }
            if ((shrinkerThread = (ShrinkerThread)this.shrinkerThreadMap.get(cattr.getTableName())) == null) {
                shrinkerThread = new ShrinkerThread();
                this.shrinkerThreadMap.put(cattr.getTableName(), shrinkerThread);
                long intervalMillis = Math.max(999, cattr.getShrinkerIntervalSeconds() * 1000);
                if (log.isInfoEnabled()) {
                    log.info((Object)("Setting the shrinker to run every [" + intervalMillis + "] ms. for table [" + cattr.getTableName() + "]"));
                }
                this.shrinkerDaemon.executePeriodically(intervalMillis, (Runnable)shrinkerThread, false);
            }
            shrinkerThread.addDiskCacheToShrinkList((JDBCDiskCache)raf);
        }
        return raf;
    }

    public void freeCache(String name) {
        JDBCDiskCache raf = (JDBCDiskCache)caches.get(name);
        if (raf != null) {
            raf.dispose();
        }
    }

    public int getCacheType() {
        return 2;
    }

    public void release() {
        if (--clients != 0) {
            return;
        }
        Hashtable hashtable = caches;
        synchronized (hashtable) {
            Enumeration allCaches = caches.elements();
            while (allCaches.hasMoreElements()) {
                JDBCDiskCache raf = (JDBCDiskCache)allCaches.nextElement();
                if (raf == null) continue;
                raf.dispose();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        caches = new Hashtable();
    }

    class MyThreadFactory
    implements ThreadFactory {
        MyThreadFactory() {
        }

        public Thread newThread(Runnable runner) {
            Thread t = new Thread(runner);
            t.setDaemon(true);
            t.setPriority(1);
            return t;
        }
    }
}

