/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.lateral.socket.tcp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.lateral.LateralElementDescriptor;
import org.apache.jcs.auxiliary.lateral.socket.tcp.behavior.ITCPLateralCacheAttributes;
import org.apache.jcs.auxiliary.lateral.socket.tcp.utils.SocketOpener;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;

public class LateralTCPSender {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPSender == null ? (class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPSender = LateralTCPSender.class$("org.apache.jcs.auxiliary.lateral.socket.tcp.LateralTCPSender")) : class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPSender));
    private ITCPLateralCacheAttributes tcpLateralCacheAttributes;
    private String remoteHost;
    private InetAddress address;
    int port = 1111;
    private ObjectOutputStream oos;
    private Socket socket;
    int counter = 0;
    private int sendCnt = 0;
    private static final int RESET_FREQUENCY = 70;
    private static final int timeOut = 1000;
    private static final int openTimeOut = 5000;
    private Object getLock = new int[0];
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$lateral$socket$tcp$LateralTCPSender;

    public LateralTCPSender(ITCPLateralCacheAttributes lca) throws IOException {
        this.setTcpLateralCacheAttributes(lca);
        String p1 = lca.getTcpServer();
        if (p1 != null) {
            String h2 = p1.substring(0, p1.indexOf(":"));
            int po = Integer.parseInt(p1.substring(p1.indexOf(":") + 1));
            if (log.isDebugEnabled()) {
                log.debug((Object)("h2 = " + h2));
                log.debug((Object)("po = " + po));
            }
            if (h2 == null) {
                throw new IOException("Cannot connect to invalid address " + h2 + ":" + po);
            }
            this.init(h2, po);
        }
    }

    protected void init(String host, int port) throws IOException {
        this.port = port;
        this.address = this.getAddressByName(host);
        this.setRemoteHost(host);
        try {
            log.debug((Object)("Attempting connection to " + this.address.getHostName()));
            this.socket = SocketOpener.openSocket(host, port, 5000);
            if (this.socket == null) {
                throw new IOException("Socket is null, cannot connect to " + host + ":" + port);
            }
            this.socket.setSoTimeout(1000);
            LateralTCPSender lateralTCPSender = this;
            synchronized (lateralTCPSender) {
                this.oos = new ObjectOutputStream(this.socket.getOutputStream());
            }
        }
        catch (ConnectException e) {
            log.debug((Object)("Remote host " + this.address.getHostName() + " refused connection."));
            throw e;
        }
        catch (IOException e) {
            log.debug((Object)("Could not connect to " + this.address.getHostName() + ". Exception is " + e));
            throw e;
        }
    }

    private InetAddress getAddressByName(String host) throws IOException {
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            log.error((Object)("Could not find address of [" + host + "] "), (Throwable)e);
            throw new IOException("Could not find address of [" + host + "] " + e.getMessage());
        }
    }

    public void send(LateralElementDescriptor led) throws IOException {
        ++this.sendCnt;
        if (log.isInfoEnabled() && this.sendCnt % 100 == 0) {
            log.info((Object)("Send Count (port " + this.port + ") = " + this.sendCnt));
        }
        log.debug((Object)"sending LateralElementDescriptor");
        if (led == null) {
            return;
        }
        if (this.address == null) {
            throw new IOException("No remote host is set for LateralTCPSender.");
        }
        if (this.oos != null) {
            try {
                this.oos.writeObject(led);
                this.oos.flush();
                if (++this.counter >= 70) {
                    this.counter = 0;
                    log.debug((Object)"Doing oos.reset()");
                    this.oos.reset();
                }
            }
            catch (IOException e) {
                this.oos = null;
                log.error((Object)("Detected problem with connection: " + e));
                throw e;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICacheElement sendAndReceive(LateralElementDescriptor led) throws IOException {
        ICacheElement ice = null;
        if (led == null) {
            return null;
        }
        if (this.address == null) {
            throw new IOException("No remote host is set for LateralTCPSender.");
        }
        if (this.oos == null) return ice;
        Object object = this.getLock;
        synchronized (object) {
            try {
                try {
                    if (this.socket.getInputStream().available() > 0) {
                        this.socket.getInputStream().read(new byte[this.socket.getInputStream().available()]);
                    }
                }
                catch (IOException ioe) {
                    log.error((Object)("Problem cleaning socket before send " + this.socket), (Throwable)ioe);
                    throw ioe;
                }
                this.oos.writeObject(led);
                this.oos.flush();
                try {
                    ObjectInputStream ois = new ObjectInputStream(this.socket.getInputStream());
                    Object obj = ois.readObject();
                    ice = (ICacheElement)obj;
                    if (ice != null) {
                        // empty if block
                    }
                }
                catch (IOException ioe) {
                    log.error((Object)("Could not open ObjectInputStream to " + this.socket), (Throwable)ioe);
                    throw ioe;
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                if (++this.counter < 70) return ice;
                this.counter = 0;
                log.info((Object)"Doing oos.reset()");
                this.oos.reset();
            }
            catch (IOException e) {
                this.oos = null;
                log.error((Object)("Detected problem with connection: " + e));
                throw e;
            }
            return ice;
        }
    }

    public void dispose(String cache) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Dispose called for cache [" + cache + "]"));
        }
        this.oos.close();
    }

    public void setTcpLateralCacheAttributes(ITCPLateralCacheAttributes tcpLateralCacheAttributes) {
        this.tcpLateralCacheAttributes = tcpLateralCacheAttributes;
    }

    public ITCPLateralCacheAttributes getTcpLateralCacheAttributes() {
        return this.tcpLateralCacheAttributes;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public static void main(String[] args) {
        try {
            LateralTCPSender lur = null;
            boolean notDone = true;
            String message = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            while (notDone) {
                System.out.println("enter mesage:");
                message = br.readLine();
                CacheElement ce = new CacheElement("test", (Serializable)((Object)"test"), (Serializable)((Object)message));
                LateralElementDescriptor led = new LateralElementDescriptor(ce);
                lur.send(led);
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

