/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.CharConversionException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;

public class CharacterValidationReader
extends FilterReader {
    public static final int VALIDATE_HTML_CHARACTER_ENTITY_REFERENCE = 1;
    private final boolean m_check_html;
    private String m_charset;

    public CharacterValidationReader(Reader reader) throws IOException {
        this(reader, 0);
    }

    public CharacterValidationReader(Reader reader, int n) throws IOException {
        super(reader);
        boolean bl = this.m_check_html = n == 1;
        if (this.m_check_html && reader instanceof InputStreamReader) {
            InputStreamReader inputStreamReader = (InputStreamReader)reader;
            this.m_charset = inputStreamReader.getEncoding();
        } else {
            this.m_charset = null;
        }
    }

    public int read() throws CharConversionException, IOException {
        int n = super.read();
        if (n == 65533) {
            throw new CharConversionException("Invalid Character");
        }
        return n;
    }

    public int read(char[] cArray, int n, int n2) throws CharConversionException, IOException {
        int n3 = super.read(cArray, n, n2);
        int n4 = n;
        int n5 = n + n3;
        while (n4 < n5) {
            if (cArray[n4] == '\ufffd') {
                throw new CharConversionException("Invalid Character: offset=" + n4);
            }
            ++n4;
        }
        return n3;
    }
}

