/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.io.Serializable;
import java.text.ParsePosition;
import oracle.i18n.text.OraDefaultDecimalFormatPattern;
import oracle.i18n.util.GDKOracleMetaData;

final class OraDecimalFormatPattern
implements Cloneable,
Serializable {
    static final long serialVersionUID = GDKOracleMetaData.getOracleVersionID();
    static final int NUMBER_MAP = 1;
    static final int SIGN_MAP = 2;
    static final int SPACE_MAP = 3;
    static final int CURRENCY_MAP = 4;
    static final int PARENTHESIS_MAP = 5;
    static final int ANGLE_BRACKET_MAP = 6;
    static final int MAX_BITS_MAP = 12;
    static final int BITS_PER_COMP_MAP = 3;
    static final int NUMBER_OF_COMP_MAP = 4;
    static final int COMP_MASK_MAP = 7;
    String pattern;
    String groupingSizes;
    int internalFormat;
    int outputStringSize;
    int numberOfDigitsLHS;
    int numberOfDigitsRHS;
    int numberOfLeadingZeros;
    int numberOfTrailingZeros;
    int numberOfGroups;
    int[] groupingSeparatorPositions = new int[1];
    boolean isGroupingSeparatorOn;
    boolean isSignOn;
    boolean isDecimalSeparatorOn;
    boolean isFmOn;
    boolean isBOn;
    boolean isTmOn;
    boolean isVOn;
    boolean useScientificNotation;
    boolean usePeriod;
    boolean useComma;
    boolean useDollar;
    boolean useIntlCurrency;
    boolean useDualCurrency;

    OraDecimalFormatPattern(OraDefaultDecimalFormatPattern oraDefaultDecimalFormatPattern) {
        this.pattern = oraDefaultDecimalFormatPattern.pattern;
        this.internalFormat = oraDefaultDecimalFormatPattern.internalFormat;
        this.numberOfDigitsRHS = oraDefaultDecimalFormatPattern.numberFractionDigits;
        this.numberOfLeadingZeros = oraDefaultDecimalFormatPattern.keepLeadingZero ? 1 : 0;
        this.numberOfTrailingZeros = oraDefaultDecimalFormatPattern.keepTrailingZero ? 1 : 0;
        this.groupingSizes = oraDefaultDecimalFormatPattern.groupingSizes;
    }

    OraDecimalFormatPattern(String string, boolean bl, ParsePosition parsePosition) {
        this.pattern = string;
        this.groupingSeparatorPositions = new int[string.length() >> 1];
        int n = this.toInternalPattern(bl);
        if (n <= string.length()) {
            parsePosition.setErrorIndex(n);
        } else {
            parsePosition.setIndex(n);
        }
    }

    int getNthComponent(int n) {
        return this.internalFormat >> (4 - n) * 3 & 7;
    }

    public Object clone() {
        try {
            OraDecimalFormatPattern oraDecimalFormatPattern = (OraDecimalFormatPattern)super.clone();
            if (this.groupingSizes == null) {
                int[] nArray = new int[this.pattern.length() >> 1];
                System.arraycopy(this.groupingSeparatorPositions, 0, nArray, 0, this.numberOfGroups);
                oraDecimalFormatPattern.groupingSeparatorPositions = nArray;
            }
            return oraDecimalFormatPattern;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OraDecimalFormatPattern)) {
            return false;
        }
        OraDecimalFormatPattern oraDecimalFormatPattern = (OraDecimalFormatPattern)object;
        return this.pattern.equals(oraDecimalFormatPattern.pattern) && (this.groupingSizes == null && this.numberOfGroups == oraDecimalFormatPattern.numberOfGroups && this.isEqual(this.groupingSeparatorPositions, oraDecimalFormatPattern.groupingSeparatorPositions, this.numberOfGroups) || this.groupingSizes != null && this.groupingSizes.equals(oraDecimalFormatPattern.groupingSizes));
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    private int toInternalPattern(boolean bl) {
        int n = 0;
        int n2 = 12;
        int n3 = 0;
        int n4 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        StringBuffer stringBuffer = new StringBuffer(3);
        this.outputStringSize = 1;
        this.numberOfDigitsLHS = 0;
        this.numberOfDigitsRHS = 0;
        this.numberOfLeadingZeros = 0;
        this.numberOfTrailingZeros = 0;
        this.numberOfGroups = 0;
        this.isGroupingSeparatorOn = false;
        this.isSignOn = false;
        this.isDecimalSeparatorOn = false;
        this.isFmOn = false;
        this.isBOn = false;
        this.isTmOn = false;
        this.isVOn = false;
        this.useScientificNotation = false;
        this.usePeriod = false;
        this.useComma = false;
        this.useDollar = false;
        this.useIntlCurrency = false;
        this.useDualCurrency = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.pattern.length();
        while (n6 < n7) {
            char c = this.pattern.charAt(n6);
            switch (c) {
                case '.': 
                case '0': 
                case '9': 
                case 'D': 
                case 'd': {
                    if (bl3) {
                        return n6;
                    }
                    block22: do {
                        c = this.pattern.charAt(n6);
                        switch (c) {
                            case '9': {
                                ++n3;
                                break;
                            }
                            case '0': {
                                ++n3;
                                if (!bl2 && n5 != 0) continue block22;
                                n5 = n3;
                                break;
                            }
                            case ',': 
                            case 'G': 
                            case 'g': {
                                if (bl2 || this.isVOn) {
                                    return n6;
                                }
                                if (c == ',') {
                                    this.useComma = true;
                                }
                                this.isGroupingSeparatorOn = true;
                                this.groupingSeparatorPositions[this.numberOfGroups++] = n3;
                                if (bl && n4 != 0) {
                                    stringBuffer.insert(0, n3 - n4);
                                }
                                n4 = n3;
                                ++this.outputStringSize;
                                break;
                            }
                            case 'V': 
                            case 'v': {
                                if (this.isVOn) {
                                    return n6;
                                }
                                this.isVOn = true;
                                bl2 = true;
                                this.numberOfDigitsLHS = n3;
                                if (n5 != 0) {
                                    this.numberOfLeadingZeros = n3 - n5 + 1;
                                    n5 = 0;
                                }
                                n3 = 0;
                                break;
                            }
                            case '.': 
                            case 'D': 
                            case 'd': {
                                if (c == '.') {
                                    this.usePeriod = true;
                                }
                                if (this.isDecimalSeparatorOn) {
                                    return n6;
                                }
                                this.isDecimalSeparatorOn = true;
                                bl2 = true;
                                ++this.outputStringSize;
                                if (bl && this.isGroupingSeparatorOn) {
                                    stringBuffer.insert(0, n3 - n4);
                                }
                                this.numberOfDigitsLHS = n3;
                                if (n5 != 0) {
                                    this.numberOfLeadingZeros = n3 - n5 + 1;
                                    n5 = 0;
                                }
                                n3 = 0;
                                break;
                            }
                            case 'E': 
                            case 'e': {
                                this.useScientificNotation = true;
                                if (n6 + 4 > n7 || this.pattern.charAt(++n6) != c || this.pattern.charAt(++n6) != c || this.pattern.charAt(++n6) != c) {
                                    return n6;
                                }
                                this.outputStringSize += 5;
                                break;
                            }
                            default: {
                                bl3 = true;
                            }
                        }
                    } while (!bl3 && ++n6 < n7);
                    if (n2 >= 3) {
                        n = n << 3 | 1;
                        n2 -= 3;
                    } else {
                        return n6;
                    }
                    if (!bl3) {
                        bl3 = true;
                    }
                    --n6;
                    break;
                }
                case '$': 
                case 'C': 
                case 'L': 
                case 'U': 
                case 'c': 
                case 'l': 
                case 'u': {
                    if (bl5) {
                        return n6;
                    }
                    if (c == 'L' || c == 'l') {
                        this.outputStringSize += 10;
                    } else if (c == '$') {
                        this.useDollar = true;
                        ++this.outputStringSize;
                    } else if (c == 'C' || c == 'c') {
                        this.useIntlCurrency = true;
                        this.outputStringSize += 7;
                    } else {
                        this.useDualCurrency = true;
                        this.outputStringSize += 10;
                    }
                    if (n2 >= 3) {
                        n = n << 3 | 4;
                        n2 -= 3;
                    } else {
                        return n6;
                    }
                    bl5 = true;
                    break;
                }
                case 'M': 
                case 'm': {
                    if (++n6 < n7) {
                        c = this.pattern.charAt(n6);
                        if (c != 'I' && c != 'i') {
                            return n6;
                        }
                    } else {
                        return n6;
                    }
                }
                case 'S': 
                case 's': {
                    if (bl4 || bl8 || bl7) {
                        return n6;
                    }
                    if (c == 'S' || c == 's') {
                        this.isSignOn = true;
                    }
                    if (n2 >= 3) {
                        n = n << 3 | 2;
                        n2 -= 3;
                    } else {
                        return n6;
                    }
                    bl4 = true;
                    break;
                }
                case '(': {
                    if (bl9 || bl4 || bl8 || bl7) {
                        return n6;
                    }
                    if (n2 >= 3) {
                        n = n << 3 | 5;
                        n2 -= 3;
                    } else {
                        return n6;
                    }
                    bl9 = true;
                    break;
                }
                case ')': {
                    if (!bl9) {
                        return n6;
                    }
                    bl8 = true;
                    ++this.outputStringSize;
                    break;
                }
                case ' ': {
                    if (bl6) {
                        return n6;
                    }
                    if (n6 == 0 || n6 + 1 == n7) {
                        return n6;
                    }
                    if (n2 >= 3) {
                        n = n << 3 | 3;
                        n2 -= 3;
                    } else {
                        return n6;
                    }
                    bl6 = true;
                    ++this.outputStringSize;
                    break;
                }
                case 'F': 
                case 'f': {
                    if (n6 != 0) {
                        return n6;
                    }
                    if (++n6 < n7) {
                        c = this.pattern.charAt(n6);
                        if (c != 'M' && c != 'm') {
                            return n6;
                        }
                        this.isFmOn = true;
                        break;
                    }
                    return n6;
                }
                case 'T': 
                case 't': {
                    if (n6 != 0 || n7 != 3) {
                        return n6;
                    }
                    c = this.pattern.charAt(n6 += 2);
                    if (this.pattern.charAt(n6 - 1) != 'M' && this.pattern.charAt(n6 - 1) != 'm' || c != '9' && c != 'E' && c != 'e') {
                        return n6;
                    }
                    this.isTmOn = true;
                    if (c != '9') {
                        this.useScientificNotation = true;
                        n3 = 1;
                    }
                    if (n2 >= 3) {
                        n = n << 3 | 1;
                        n2 -= 3;
                    } else {
                        return n6;
                    }
                    bl3 = true;
                    break;
                }
                case 'P': 
                case 'p': {
                    if (bl4 || bl8 || bl7 || ++n6 != n7 - 1) {
                        return n6;
                    }
                    c = this.pattern.charAt(n6);
                    if (c != 'R' && c != 'r') {
                        return n6;
                    }
                    if (n2 >= 3) {
                        n |= 0xC00;
                        n2 -= 3;
                    } else {
                        return n6;
                    }
                    bl7 = true;
                    ++this.outputStringSize;
                    break;
                }
                case 'B': 
                case 'b': {
                    if (this.isBOn) {
                        return n6;
                    }
                    this.isBOn = true;
                    break;
                }
                default: {
                    return n6;
                }
            }
            ++n6;
        }
        if (bl9 && !bl8) {
            return n6;
        }
        if (!bl2) {
            this.numberOfDigitsLHS = n3;
            if (n5 != 0) {
                this.numberOfLeadingZeros = n3 - n5 + 1;
            }
            if (bl && this.isGroupingSeparatorOn) {
                stringBuffer.insert(0, n3 - n4);
            }
        } else {
            this.numberOfDigitsRHS = n3;
            this.numberOfTrailingZeros = n5;
        }
        if (this.useScientificNotation) {
            if (this.numberOfDigitsLHS <= 1) {
                if (this.numberOfDigitsLHS == 0) {
                    return n6;
                }
            } else {
                this.numberOfDigitsLHS = 1;
            }
            if (this.numberOfLeadingZeros > 1) {
                this.numberOfLeadingZeros = 1;
            }
        }
        this.outputStringSize += this.numberOfDigitsLHS + this.numberOfDigitsRHS;
        this.internalFormat = n;
        this.groupingSizes = !bl ? null : stringBuffer.toString();
        return ++n6;
    }

    private boolean isEqual(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (nArray[n2] != nArray2[n2]) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void printInternalFormat() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (n <= 4) {
            switch (this.getNthComponent(n)) {
                case 1: {
                    stringBuffer.append("<NUMBER>");
                    break;
                }
                case 2: {
                    stringBuffer.append("<SIGN>");
                    break;
                }
                case 4: {
                    stringBuffer.append("<CURRENCY>");
                    break;
                }
                case 3: {
                    stringBuffer.append("<SPACE>");
                    break;
                }
                case 5: {
                    stringBuffer.append("<PARENTHESIS>");
                    break;
                }
                case 6: {
                    stringBuffer.append("<ANGLE_BRACKET>");
                    break;
                }
                default: {
                    stringBuffer.append("<NOTHING>");
                }
            }
            ++n;
        }
        System.out.println("Pattern: |" + this.pattern + "| ==> Internal Format: " + stringBuffer);
    }
}

