/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.io.IOException;
import java.io.InputStream;

public class DualInputStreamBuilder {
    private static int DEFAULT_BUFFER_SIZE = 8192;
    private static int DEFAULT_STREAM_NUMBER = 2;
    private byte[] m_buf;
    private int m_count;
    private int[] m_pos;
    private final boolean[] m_isClosed;
    private InputStream m_in;
    private InputStream[] m_subInputStream;

    public DualInputStreamBuilder(InputStream inputStream, int n) {
        this.m_in = inputStream;
        this.m_buf = new byte[n];
        this.m_pos = new int[DEFAULT_STREAM_NUMBER];
        this.m_isClosed = new boolean[DEFAULT_STREAM_NUMBER];
        this.m_subInputStream = new InputStream[DEFAULT_STREAM_NUMBER];
        int n2 = 0;
        while (n2 < DEFAULT_STREAM_NUMBER) {
            this.m_pos[n2] = 0;
            this.m_isClosed[n2] = false;
            ++n2;
        }
    }

    public DualInputStreamBuilder(InputStream inputStream) {
        this(inputStream, DEFAULT_BUFFER_SIZE);
    }

    public InputStream getFirstInputStream() {
        return this.getInputStream(0);
    }

    public InputStream getSecondInputStream() {
        return this.getInputStream(1);
    }

    private void ensureOpen(int n) throws IOException {
        if (this.m_in == null || this.m_isClosed[n]) {
            throw new IOException("Stream closed");
        }
    }

    private synchronized InputStream getInputStream(int n) {
        if (this.m_subInputStream[n] == null) {
            this.m_subInputStream[n] = new SubInputStream(this, n);
        }
        return this.m_subInputStream[n];
    }

    private int getMinPos() {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        while (n2 < DEFAULT_STREAM_NUMBER) {
            if (this.m_pos[n2] >= 0 && n >= this.m_pos[n2]) {
                n = this.m_pos[n2];
            }
            ++n2;
        }
        return n;
    }

    private void fill(int n, int n2) throws IOException {
        int n3;
        if (this.m_pos[n] >= this.m_buf.length) {
            int n4 = n3 = n2 < 0 ? this.getMinPos() : n2;
            if (n3 > 0) {
                int n5 = this.m_pos[n] - n3;
                System.arraycopy(this.m_buf, n3, this.m_buf, 0, n5);
                int n6 = 0;
                while (n6 < DEFAULT_STREAM_NUMBER) {
                    int n7 = n6++;
                    this.m_pos[n7] = this.m_pos[n7] - n3;
                }
                this.m_count -= n3;
            } else {
                int n8 = this.m_pos[n] * 2;
                byte[] byArray = new byte[n8];
                System.arraycopy(this.m_buf, 0, byArray, 0, this.m_pos[n]);
                this.m_buf = byArray;
                this.m_count = this.m_pos[n];
            }
        }
        if ((n3 = this.m_in.read(this.m_buf, this.m_pos[n], this.m_buf.length - this.m_pos[n])) > 0) {
            this.m_count = n3 + this.m_pos[n];
        }
    }

    private synchronized int read(int n) throws IOException {
        this.ensureOpen(n);
        if (this.m_pos[n] >= this.m_count) {
            this.fill(n, -1);
            if (this.m_pos[n] >= this.m_count) {
                return -1;
            }
        }
        int n2 = n;
        int n3 = this.m_pos[n2];
        this.m_pos[n2] = n3 + 1;
        return this.m_buf[n3] & 0xFF;
    }

    private int read1(int n, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = this.m_count - this.m_pos[n];
        if (n5 <= 0) {
            n4 = this.getMinPos();
            this.fill(n, n4);
            n5 = this.m_count - this.m_pos[n];
            if (n5 <= 0) {
                return -1;
            }
        }
        n4 = n5 < n3 ? n5 : n3;
        System.arraycopy(this.m_buf, this.m_pos[n], byArray, n2, n4);
        int n6 = n;
        this.m_pos[n6] = this.m_pos[n6] + n4;
        return n4;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized int read(int var1_1, byte[] var2_2, int var3_3, int var4_4) throws IOException {
        this.ensureOpen(var1_1);
        if ((var3_3 | var4_4 | var3_3 + var4_4 | var2_2.length - (var3_3 + var4_4)) < 0) {
            throw new IndexOutOfBoundsException("b.length=" + var2_2.length + ", off=" + var3_3 + ", len=" + var4_4);
        }
        if (var4_4 == 0) {
            return 0;
        }
        var5_5 = this.read1(var1_1, var2_2, var3_3, var4_4);
        if (var5_5 > 0) ** GOTO lbl11
        return var5_5;
        while ((var6_6 = this.read1(var1_1, var2_2, var3_3 + var5_5, var4_4 - var5_5)) > 0) {
            var5_5 += var6_6;
lbl11:
            // 2 sources

            if (var5_5 < var4_4 && this.available(var1_1) > 0) continue;
        }
        return var5_5;
    }

    private void close(int n) throws IOException {
        if (this.m_in == null) {
            return;
        }
        this.m_isClosed[n] = true;
        this.m_pos[n] = -1;
        boolean bl = true;
        int n2 = 0;
        while (n2 < DEFAULT_STREAM_NUMBER) {
            bl &= this.m_isClosed[n2];
            ++n2;
        }
        if (bl) {
            this.m_in.close();
            this.m_in = null;
            this.m_buf = null;
        }
    }

    private synchronized long skip(int n, long l) throws IOException {
        this.ensureOpen(n);
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.m_count - this.m_pos[n];
        if (l2 <= 0L) {
            this.fill(n, -1);
            l2 = this.m_count - this.m_pos[n];
            if (l2 <= 0L) {
                return 0L;
            }
        }
        long l3 = l2 < l ? l2 : l;
        int n2 = n;
        this.m_pos[n2] = (int)((long)this.m_pos[n2] + l3);
        return l3;
    }

    private synchronized int available(int n) throws IOException {
        this.ensureOpen(n);
        return this.m_count - this.m_pos[n] + this.m_in.available();
    }

    private class SubInputStream
    extends InputStream {
        private DualInputStreamBuilder m_dups;
        private int m_index;

        public SubInputStream(DualInputStreamBuilder dualInputStreamBuilder2, int n) {
            this.m_dups = dualInputStreamBuilder2;
            this.m_index = n;
        }

        public synchronized int read() throws IOException {
            return this.m_dups.read(this.m_index);
        }

        public int available() throws IOException {
            return this.m_dups.available(this.m_index);
        }

        public void close() throws IOException {
            this.m_dups.close(this.m_index);
        }

        public void mark(int n) {
        }

        public boolean markSupported() {
            return false;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return this.m_dups.read(this.m_index, byArray, n, n2);
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public void reset() throws IOException {
        }

        public long skip(long l) throws IOException {
            return this.m_dups.skip(this.m_index, l);
        }
    }
}

