/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.i18n.text.converter.CharacterConverter12Byte;
import oracle.i18n.util.ConverterArchive;
import oracle.i18n.util.builder.CharConvBuilder;
import oracle.i18n.util.builder.CharSetParser;
import oracle.i18n.util.builder.NLTParserException;
import oracle.sql.converter.CharacterConverters;

public class CharConv12ByteBuilder
extends CharConvBuilder {
    static final boolean DEBUG = false;
    static final int MAXCHARVALUE = 65535;
    CharacterConverter12Byte charConv12ByteObj = null;

    public CharConv12ByteBuilder() {
        this.charConv12ByteObj = new CharacterConverter12Byte();
    }

    protected CharConv12ByteBuilder(CharacterConverter12Byte characterConverter12Byte) {
        this.charConv12ByteObj = characterConverter12Byte;
    }

    public void buildGLB(CharacterConverters characterConverters, String string, String string2, String string3, boolean bl) throws IOException {
        try {
            int n;
            CharSetParser charSetParser = new CharSetParser(string3);
            String string4 = charSetParser.getName();
            this.charConv12ByteObj.m_oracleId = Integer.parseInt(charSetParser.getId());
            this.charConv12ByteObj.m_ucsCharReplacement = 65533;
            String string5 = charSetParser.getDefaultReplacementChar();
            if (string5 != null) {
                n = CharConvBuilder.stringToInt(string5);
                if (((long)n & 0xFFFFFFFFL) > 255L) {
                    throw new NLTParserException("ReplacementChar too big");
                }
                this.charConv12ByteObj.m_1ByteOraCharReplacement = (char)(n & 0xFF);
            }
            if ((string5 = charSetParser.getDefaultMultibyteReplacementChar()) != null) {
                n = CharConvBuilder.stringToInt(string5);
                if (((long)n & 0xFFFFFFFFL) > 65535L) {
                    throw new NLTParserException("ReplacementChar too big");
                }
                this.charConv12ByteObj.m_2ByteOraCharReplacement = (char)(n & 0xFFFF);
            }
            if (string4 == null || this.charConv12ByteObj.m_oracleId == 0) {
                System.err.println("Missing data in file " + string3);
                System.err.println("No output file created");
                return;
            }
            boolean bl2 = charSetParser.haveExtraUnicodeMapping();
            String string6 = CharConvBuilder.formatCharConvClassName(this.charConv12ByteObj.m_oracleId);
            if (characterConverters != null) {
                if (this.charConv12ByteObj.m_ucsCharReplacement == 0) {
                    this.charConv12ByteObj.m_ucsCharReplacement = characterConverters.getUCS2CharRep();
                }
                if (this.charConv12ByteObj.m_1ByteOraCharReplacement == '\u0000') {
                    this.charConv12ByteObj.m_1ByteOraCharReplacement = characterConverters.getOraChar1ByteRep();
                }
                if (this.charConv12ByteObj.m_2ByteOraCharReplacement == '\u0000') {
                    this.charConv12ByteObj.m_2ByteOraCharReplacement = characterConverters.getOraChar2ByteRep();
                }
            }
            if (this.charConv12ByteObj.m_1ByteOraCharReplacement == '\u0000') {
                this.charConv12ByteObj.m_1ByteOraCharReplacement = (char)63;
            }
            if (this.charConv12ByteObj.m_2ByteOraCharReplacement == '\u0000') {
                this.charConv12ByteObj.m_2ByteOraCharReplacement = this.charConv12ByteObj.m_1ByteOraCharReplacement;
            }
            this.setUcsChar(charSetParser, characterConverters);
            this.setExtraUnicodeMapping(charSetParser, characterConverters);
            if (this.charConv12ByteObj != null) {
                ConverterArchive converterArchive = new ConverterArchive();
                try {
                    if (bl) {
                        converterArchive.insertObjtoFile(string, string6 + ".glb", this.charConv12ByteObj);
                    } else {
                        converterArchive.insertSingleObj(string2, this.charConv12ByteObj, "/oracle/i18n/data/" + string6 + ".glb");
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                    return;
                }
            }
            return;
        }
        catch (NLTParserException nLTParserException) {
            System.out.println(nLTParserException.getMessage());
            return;
        }
    }

    private void setExtraUnicodeMapping(CharSetParser charSetParser, CharacterConverters characterConverters) throws NLTParserException {
        Vector vector;
        Vector vector2 = new Vector();
        if (characterConverters != null) {
            characterConverters.extractExtraMappings(vector2);
        }
        if (this.charConv12ByteObj.extraUnicodeToOracleMapping != null) {
            this.charConv12ByteObj.extractExtraMappings(vector2);
        }
        if ((vector = charSetParser.getReplacementChars()) != null) {
            int n = vector.size();
            try {
                int n2 = 0;
                while (n2 < n) {
                    Object[] objectArray = (Object[])vector.elementAt(n2);
                    int n3 = ((int[])objectArray[0])[0];
                    int n4 = ((int[])objectArray[1])[0];
                    this.setExtraUnicodeMappingPair(n3, n4, vector2);
                    ++n2;
                }
            }
            catch (IOException iOException) {
                throw new NLTParserException("bad number");
            }
        }
        this.finishExtraUnicodeMapping(vector2);
    }

    private void setExtraUnicodeMappingPair(int n, int n2, Vector vector) throws IOException {
        int[] nArray = new int[]{n = (int)CharConvBuilder.convertUTF32toUTF16((long)n & 0xFFFFFFFFL), n2};
        vector.addElement(nArray);
    }

    private void finishExtraUnicodeMapping(Vector vector) {
        int n = 0;
        int[] nArray = null;
        int n2 = vector.size();
        this.charConv12ByteObj.extraUnicodeToOracleMapping = new int[n2][2];
        n = 0;
        while (n < vector.size()) {
            nArray = (int[])vector.elementAt(n);
            this.charConv12ByteObj.extraUnicodeToOracleMapping[n][0] = nArray[0];
            this.charConv12ByteObj.extraUnicodeToOracleMapping[n][1] = nArray[1];
            ++n;
        }
    }

    private void setUcsChar(CharSetParser charSetParser, CharacterConverters characterConverters) throws NLTParserException {
        Vector vector = new Vector();
        try {
            int n;
            Vector vector2;
            if (characterConverters != null) {
                vector2 = new Vector(65535, 28671);
                characterConverters.extractCodepoints(vector2);
                n = 0;
                while (n < vector2.size()) {
                    int[] nArray = (int[])vector2.elementAt(n);
                    this.setUcsCharPair(nArray[0], nArray[1], vector);
                    ++n;
                }
            }
            vector2 = charSetParser.getCharacterData();
            int n2 = vector2.size();
            n = 0;
            while (n < n2) {
                Object[] objectArray = (Object[])vector2.elementAt(n);
                int n3 = ((int[])objectArray[0])[0];
                int n4 = ((int[])objectArray[1])[0];
                this.setUcsCharPair(n3, n4, vector);
                ++n;
            }
            this.finishUcsChar(vector);
        }
        catch (IOException iOException) {
            throw new NLTParserException("bad number");
        }
    }

    private void setUcsCharPair(int n, int n2, Vector vector) throws IOException {
        if (n > 65535) {
            System.err.println("***** Error: source code point " + Integer.toHexString(n) + " is too big for 1-2 byte converter");
            return;
        }
        if ((n2 = (int)CharConvBuilder.convertUTF32toUTF16((long)n2 & 0xFFFFFFFFL)) == 65533) {
            return;
        }
        int[] nArray = new int[]{n, n2};
        vector.addElement(nArray);
    }

    private void finishUcsChar(Vector vector) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray;
        int n6 = 8;
        int n7 = 8;
        int n8 = (1 << n6) - 1;
        int n9 = (1 << n7) - 1;
        int n10 = 1 << n6;
        char[] cArray = new char[n10];
        char[][] cArray2 = new char[n10][2];
        int n11 = 0;
        while (n11 < n10) {
            cArray[n11] = 65535;
            cArray2[n11][0] = (char)n9;
            cArray2[n11][1] = '\u0000';
            ++n11;
        }
        int n12 = vector.size();
        Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
        Hashtable hashtable2 = new Hashtable();
        n11 = 0;
        while (n11 < n12) {
            nArray = (int[])vector.elementAt(n11);
            n5 = nArray[1];
            if (n5 != -1) {
                n4 = nArray[0];
                if (hashtable.get(new Integer(n5)) == null) {
                    hashtable.put(new Integer(n5), new Integer(n4));
                } else {
                    hashtable2.put(new Integer(n5), hashtable.get(new Integer(n5)));
                }
                n3 = n4 >> n7 & n8;
                cArray[n3] = '\u0001';
                n2 = n4 & n9;
                if (n2 < cArray2[n3][0]) {
                    cArray2[n3][0] = (char)n2;
                }
                if (n2 > cArray2[n3][1]) {
                    cArray2[n3][1] = (char)n2;
                }
            }
            ++n11;
        }
        int n13 = n = n9 + 1;
        int n14 = 0;
        n11 = 0;
        while (n11 < n10) {
            if (cArray[n11] != '\uffff') {
                int n15 = cArray2[n11][0];
                cArray[n11] = (char)(n13 - (n14 < n15 ? n14 : n15));
                n13 = cArray[n11] + n;
                n14 = n - cArray2[n11][1] - 1;
            }
            ++n11;
        }
        int[] nArray2 = new int[n13];
        n11 = 0;
        while (n11 < n13) {
            nArray2[n11] = -1;
            ++n11;
        }
        n12 = vector.size();
        n11 = 0;
        while (n11 < n12) {
            nArray = (int[])vector.elementAt(n11);
            n5 = nArray[1];
            if (n5 != -1) {
                n4 = nArray[0];
                n3 = n4 >> n7 & n8;
                n2 = n4 & n9;
                int n16 = cArray[n3] + n2;
                nArray2[n16] = n5;
            }
            ++n11;
        }
        this.setArray2(nArray2);
        this.setArray(cArray);
        this.setDuplicateMapping(hashtable2);
    }

    void setArray2(int[] nArray) {
        int n = nArray.length;
        this.charConv12ByteObj.m_ucsCharLevel2 = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.charConv12ByteObj.m_ucsCharLevel2[n2] = nArray[n2];
            ++n2;
        }
    }

    void setArray(char[] cArray) {
        int n = cArray.length;
        this.charConv12ByteObj.m_ucsCharLevel1 = new char[n];
        int n2 = 0;
        while (n2 < n) {
            this.charConv12ByteObj.m_ucsCharLevel1[n2] = cArray[n2];
            ++n2;
        }
    }

    void setDuplicateMapping(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        this.charConv12ByteObj.extraUnicodeToOracleMapping = new int[hashtable.size()][2];
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.charConv12ByteObj.extraUnicodeToOracleMapping[n][0] = (Integer)k;
            this.charConv12ByteObj.extraUnicodeToOracleMapping[n++][1] = (Integer)hashtable.get(k);
        }
    }
}

