/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.util.Locale;
import java.util.Vector;
import oracle.i18n.util.builder.CharSetParser;
import oracle.i18n.util.builder.NLTParserException;

public class CharDataTypeParser {
    private static final boolean DEBUG = false;
    private long INTEGERMASK = -1L;
    private long HIGHBYTEMASK = -65536L;
    private int MAXLEADCODE = 4;
    private char[] LeadCode = new char[this.MAXLEADCODE];
    private int maxByte;
    private boolean fixedWidth;
    private boolean tooManyLeadCode;
    private boolean isEBCDICBASED;
    private boolean isASCIIBASED;
    private boolean isFIXEDWIDTH;
    private boolean isSHIFT;
    private boolean isUNICODE;
    private boolean isSPECIALRANGE;
    public int baseCharID;
    public int typeID;

    public CharDataTypeParser(String string) throws NLTParserException {
        Object object;
        boolean bl = false;
        this.maxByte = 0;
        this.fixedWidth = true;
        this.isEBCDICBASED = false;
        this.isASCIIBASED = false;
        this.isFIXEDWIDTH = false;
        this.isSHIFT = false;
        this.isUNICODE = false;
        this.isSPECIALRANGE = false;
        this.tooManyLeadCode = false;
        this.typeID = -1;
        this.baseCharID = -1;
        int n = 0;
        while (n < this.MAXLEADCODE) {
            this.LeadCode[n] = '\u0000';
            ++n;
        }
        CharSetParser charSetParser = new CharSetParser(string);
        Vector vector = charSetParser.getCharacterData();
        int n2 = vector.size();
        String string2 = charSetParser.getName().toUpperCase(Locale.US);
        if (string2.equals("MSOUTLOOK-ISO2022JP-FW")) {
            this.typeID = 11;
            return;
        }
        if (string2.equals("MSOUTLOOK-ISO2022JP-HW")) {
            this.typeID = 12;
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            object = (Object[])vector.elementAt(n3);
            int n4 = ((int[])object[0])[0];
            char c = (char)(((long)n4 & this.HIGHBYTEMASK) >> 16);
            if (n4 > 65535) {
                int n5 = 0;
                while (n5 < this.MAXLEADCODE) {
                    if (this.LeadCode[n5] == '\u0000') {
                        this.LeadCode[n5] = c;
                        break;
                    }
                    if (this.LeadCode[n5] == c) break;
                    ++n5;
                }
                if (n5 >= this.MAXLEADCODE) {
                    this.tooManyLeadCode = true;
                }
            }
            if (((long)n4 & 0xFFFFFFFFL) > 0xFFFFFFL) {
                this.maxByte = Math.max(this.maxByte, 4);
            } else if (n4 > 65535) {
                this.maxByte = Math.max(this.maxByte, 3);
            } else if (n4 > 255) {
                this.maxByte = Math.max(this.maxByte, 2);
            } else {
                this.maxByte = Math.max(this.maxByte, 1);
                if (n4 > 127) {
                    this.isSPECIALRANGE = true;
                }
            }
            ++n3;
        }
        object = charSetParser.getFlags();
        if (object != null) {
            if (((String)(object = ((String)object).toLowerCase(Locale.US))).indexOf("ascii") != -1) {
                this.isASCIIBASED = true;
            }
            if (((String)object).indexOf("fixed") != -1) {
                this.isFIXEDWIDTH = true;
            }
            if (((String)object).indexOf("ebcdic") != -1) {
                this.isEBCDICBASED = true;
            }
            if (((String)object).indexOf("shift") != -1) {
                this.isSHIFT = true;
            }
            if (((String)object).indexOf("unicode") != -1) {
                this.isUNICODE = true;
            }
        }
        if (this.tooManyLeadCode) {
            System.err.println("Ginstall can not support character sets with");
            System.err.println("more than 4 lead codes");
            this.typeID = -1;
            return;
        }
        if (this.isUNICODE) {
            return;
        }
        switch (this.maxByte) {
            case 1: {
                this.typeID = 0;
                return;
            }
            case 2: {
                this.typeID = this.isSHIFT ? 7 : (this.isFIXEDWIDTH ? 6 : (this.isSPECIALRANGE ? 4 : 1));
                return;
            }
            case 3: {
                if (!this.isFIXEDWIDTH) {
                    this.typeID = 2;
                }
                return;
            }
            case 4: {
                this.typeID = this.isFIXEDWIDTH ? 3 : 5;
                return;
            }
        }
        System.err.println("Ginstall can not support character sets with");
        System.err.println("characters longer than 4 bytes");
        this.typeID = -1;
    }
}

