/*
 * Decompiled with CFR 0.152.
 */
package core.rfid;

import core.rfid.data.SendMsg;
import core.util.LogUtil;
import core.util.PropertyUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class RecvControl {
    private static String log_prefix = "[RecvControl]";
    private static ExecutorService executorService = null;
    private final int POOL_SIZE = 2;
    private ServerSocket serverSocket = null;
    private boolean isListening = true;
    private Hashtable data = null;
    private boolean isDebug = "true".equalsIgnoreCase(PropertyUtil.getProperty("DEBUG"));

    public static void main(String[] args) {
        Hashtable<String, String> data = new Hashtable<String, String>();
        data.put("L2_ID", "102");
        data.put("L2_ADDR", "localhost");
        data.put("L2_SEND_PORT", "6001");
        data.put("L2_RECV_PORT", "6002");
        data.put("FACT_CD", "S");
        data.put("HD_LEN", "40");
        data.put("RECV_ASK_YN", "Y");
        data.put("SEND_ASK_YN", "Y");
        data.put("END_FLAG_YN", "Y");
        new RecvControl(data).start();
    }

    public RecvControl(Hashtable data) {
        if (this.isDebug) {
            LogUtil.info(log_prefix, " start debug...");
        }
        try {
            LogUtil.info(log_prefix, " start listen port: " + data.get("L2_RECV_PORT"));
            this.serverSocket = new ServerSocket(Integer.parseInt(data.get("L2_RECV_PORT").toString()));
            if (executorService == null) {
                executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
            }
            this.data = data;
        }
        catch (IOException e) {
            LogUtil.error(log_prefix, " " + e);
        }
    }

    public void start() {
        Socket socket = null;
        this.isListening = true;
        int waitTime = 8000;
        if (PropertyUtil.getProperty("ACU_TIMEOUT") != null) {
            // empty if block
        }
        waitTime = Integer.parseInt(PropertyUtil.getProperty("ACU_TIMEOUT"));
        while (this.isListening) {
            try {
                socket = this.serverSocket.accept();
                socket.setSoTimeout(waitTime);
                LogUtil.info(log_prefix, " " + new Date().toString() + socket.toString());
                executorService.execute(new Handler(socket));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void shutdown() {
        this.isListening = false;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
                this.serverSocket = null;
            }
            if (executorService != null) {
                executorService.shutdown();
                executorService.awaitTermination(0L, TimeUnit.MILLISECONDS);
                executorService = null;
            }
            LogUtil.debug(log_prefix, " stop listen prot: " + this.data.get("L2_RECV_PORT"));
            this.data = null;
        }
        catch (IOException e) {
            LogUtil.info(log_prefix, " " + e);
        }
        catch (InterruptedException e) {
            LogUtil.info(log_prefix, " " + e);
        }
    }

    class Handler
    implements Runnable {
        private Socket socket;

        public Handler(Socket socket) {
            this.socket = socket;
            if (RecvControl.this.isDebug) {
                LogUtil.info(log_prefix, " start thread handler...");
            }
        }

        public void run() {
            BufferedReader br = null;
            BufferedWriter bw = null;
            try {
                try {
                    String recvData;
                    br = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                    bw = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
                    char type = RecvControl.this.data.get("FACT_CD").toString().charAt(0);
                    int len = Integer.parseInt(RecvControl.this.data.get("HD_LEN").toString());
                    boolean end_fl_yn = "Y".equals(RecvControl.this.data.get("END_FLAG_YN"));
                    if (end_fl_yn) {
                        ++len;
                    }
                    ++len;
                    boolean ask_yn = "Y".equals(RecvControl.this.data.get("RECV_ASK_YN"));
                    while ((recvData = br.readLine()) != null) {
                        LogUtil.info(log_prefix, "[" + recvData + "]\n[length: " + recvData.length() + "]");
                        if (!RecvControl.this.isDebug) {
                            if ("".equals(recvData) || recvData.length() < len || Integer.parseInt(recvData.substring(0, 4)) != recvData.length() + 1) continue;
                            String sL2_Kind = recvData.substring(4, 5);
                            if (end_fl_yn) {
                                recvData = String.valueOf(recvData) + '\n';
                            }
                            if (!SendMsg.executeUpdate(String.valueOf(type) + "_RECV_DATA", new String[]{recvData, sL2_Kind})) {
                                LogUtil.error(log_prefix, " Recieve data[" + recvData + "] insert failed.");
                            }
                        }
                        if (!ask_yn) continue;
                        bw.append(this.repEdit(recvData));
                        bw.flush();
                    }
                    LogUtil.info(log_prefix, " levle2 recieve data successful.");
                }
                catch (SocketTimeoutException recvData) {
                    try {
                        if (br != null) {
                            br.close();
                        }
                        if (bw != null) {
                            bw.close();
                        }
                        if (this.socket != null) {
                            this.socket.close();
                        }
                    }
                    catch (IOException e) {
                        LogUtil.info(log_prefix, " " + e);
                    }
                }
                catch (IOException e) {
                    LogUtil.error(log_prefix, " " + e);
                    try {
                        if (br != null) {
                            br.close();
                        }
                        if (bw != null) {
                            bw.close();
                        }
                        if (this.socket != null) {
                            this.socket.close();
                        }
                    }
                    catch (IOException e2) {
                        LogUtil.info(log_prefix, " " + e2);
                    }
                }
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (bw != null) {
                        bw.close();
                    }
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (IOException e) {
                    LogUtil.info(log_prefix, " " + e);
                }
            }
        }

        protected String repEdit(String sMsg) throws IOException {
            StringBuffer repMsg = new StringBuffer();
            repMsg.append("0041");
            repMsg.append(sMsg.substring(4, 10));
            repMsg.append(new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()));
            repMsg.append(sMsg.substring(26, 28));
            repMsg.append(sMsg.substring(24, 26));
            repMsg.append("0000");
            repMsg.append("99999999");
            repMsg.append('\n');
            return repMsg.toString();
        }
    }
}

