/*
 * Decompiled with CFR 0.152.
 */
package core.rfid;

import core.rfid.data.SendMsg;
import core.rfid.io.ACUClient;
import core.util.LogUtil;
import core.util.PropertyUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class SendControl {
    private static String log_prefix = "[SendControl]";
    private boolean isDebug = "true".equalsIgnoreCase(PropertyUtil.getProperty("DEBUG"));
    private int waitTime = 8000;

    public static void main(String[] args) {
        Hashtable<String, String> data = new Hashtable<String, String>();
        data.put("L2_ID", "222");
        data.put("L2_ADDR", "localhost");
        data.put("L2_SEND_PORT", "6002");
        data.put("L2_RECV_PORT", "6001");
        data.put("FACT_CD", "S");
        data.put("HD_LEN", "40");
        data.put("RECV_ASK_YN", "Y");
        data.put("SEND_ASK_YN", "N");
        data.put("END_FLAG_YN", "Y");
        Hashtable<String, Hashtable<String, String>> config = new Hashtable<String, Hashtable<String, String>>();
        config.put("222", data);
        new SendControl(config);
    }

    public SendControl(Hashtable configs) {
        this(configs, null);
    }

    public SendControl(Hashtable configs, ExecutorService executor) {
        if (this.isDebug) {
            LogUtil.info(log_prefix, " start debug...");
        }
        if (PropertyUtil.getProperty("ACU_TIMEOUT") != null) {
            this.waitTime = Integer.parseInt(PropertyUtil.getProperty("ACU_TIMEOUT")) / 2;
        }
        if (executor == null) {
            executor = Executors.newCachedThreadPool();
        }
        try {
            Iterator itr = configs.keySet().iterator();
            while (itr.hasNext()) {
                Object key = itr.next();
                Hashtable config = (Hashtable)configs.get(key);
                executor.execute(new Handler(config));
            }
        }
        catch (Exception e) {
            LogUtil.error(log_prefix, " ACUControl.synchronize() ERROR: " + e);
        }
    }

    class Handler
    implements Runnable {
        private boolean ask_yn;
        private boolean end_fl_yn;
        private String acuIP;
        private String acuId;
        private int acuPort;
        private String nSeqNo;
        private String transDTime;

        public Handler(Hashtable config) {
            this.ask_yn = "Y".equals(config.get("SEND_ASK_YN"));
            this.end_fl_yn = "Y".equals(config.get("END_FLAG_YN"));
            this.acuIP = (String)config.get("L2_ADDR");
            this.acuPort = Integer.parseInt(config.get("L2_SEND_PORT").toString());
            this.acuId = (String)config.get("L2_ID");
            LogUtil.info(log_prefix, " config:" + config);
        }

        public void run() {
            ACUClient client = null;
            try {
                try {
                    while (!(client = new ACUClient(log_prefix)).connect(this.acuIP, this.acuPort)) {
                        LogUtil.debug(log_prefix, " socket connect failed L2_ID=[" + this.acuId + "] , IP=[" + this.acuIP + "]");
                        Thread.sleep(SendControl.this.waitTime);
                    }
                    while (true) {
                        this.process(client);
                        Thread.sleep(SendControl.this.waitTime);
                        client.sendPacket("0041999999" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "0000000011111111\n");
                    }
                }
                catch (Exception e) {
                    LogUtil.error(log_prefix, " " + e);
                    if (client != null) {
                        client.closeSocket();
                    }
                }
            }
            catch (Throwable throwable) {
                if (client != null) {
                    client.closeSocket();
                }
                throw throwable;
            }
        }

        private void process(ACUClient client) throws Exception {
            int iSize = 0;
            int i = 0;
            ArrayList arrData = null;
            if (this.acuId.equals("211")) {
                Hashtable ht;
                arrData = SendMsg.executeQuery(SendMsg.L1SlabLock);
                iSize = arrData.size();
                if (iSize > 0) {
                    LogUtil.info(log_prefix, " L1SlabLock loop start.");
                    i = 0;
                    while (i < iSize) {
                        ht = (Hashtable)arrData.get(i);
                        this.nSeqNo = (String)ht.get("SEQ_NO");
                        this.transDTime = (String)ht.get("TRANS_DTIME");
                        if (!this.sendPacket(SendMsg.getSendMsg(ht, SendMsg.L1SlabLock, this.end_fl_yn), SendMsg.L1SlabLock, client, 1)) {
                            return;
                        }
                        ++i;
                    }
                }
                if ((iSize = (arrData = SendMsg.executeQuery(SendMsg.L1SlabTakeIn)).size()) > 0) {
                    LogUtil.info(log_prefix, " L1SlabTakeIn loop start.");
                    i = 0;
                    while (i < iSize) {
                        ht = (Hashtable)arrData.get(i);
                        this.nSeqNo = (String)ht.get("SEQ_NO");
                        this.transDTime = (String)ht.get("TRANS_DTIME");
                        if (!this.sendPacket(SendMsg.getSendMsg(ht, SendMsg.L1SlabTakeIn, this.end_fl_yn), SendMsg.L1SlabTakeIn, client, 1)) {
                            return;
                        }
                        ++i;
                    }
                }
                if ((iSize = (arrData = SendMsg.executeQuery(SendMsg.L1SlabTakeOut)).size()) > 0) {
                    LogUtil.info(log_prefix, " L1SlabTakeOut loop start.");
                    i = 0;
                    while (i < iSize) {
                        ht = (Hashtable)arrData.get(i);
                        this.nSeqNo = (String)ht.get("SEQ_NO");
                        this.transDTime = (String)ht.get("TRANS_DTIME");
                        if (!this.sendPacket(SendMsg.getSendMsg(ht, SendMsg.L1SlabTakeOut, this.end_fl_yn), SendMsg.L1SlabTakeOut, client, 1)) {
                            return;
                        }
                        ++i;
                    }
                }
            } else if (this.acuId.equals("212")) {
                Hashtable ht;
                arrData = SendMsg.executeQuery(SendMsg.L2RhtIns);
                iSize = arrData.size();
                if (iSize > 0) {
                    LogUtil.info(log_prefix, " L2RhtIns loop start.");
                    i = 0;
                    while (i < iSize) {
                        ht = (Hashtable)arrData.get(i);
                        this.nSeqNo = (String)ht.get("SEQ_NO");
                        this.transDTime = (String)ht.get("TRANS_DTIME");
                        if (!this.sendPacket(SendMsg.getSendMsg(ht, SendMsg.L2RhtIns, this.end_fl_yn), SendMsg.L2RhtIns, client, 1)) {
                            return;
                        }
                        ++i;
                    }
                }
                if ((iSize = (arrData = SendMsg.executeQuery(SendMsg.L2RollUnitIns)).size()) > 0) {
                    LogUtil.info(log_prefix, " L2RollUnitIns loop start.");
                    i = 0;
                    while (i < iSize) {
                        ht = (Hashtable)arrData.get(i);
                        this.nSeqNo = (String)ht.get("SEQ_NO");
                        this.transDTime = (String)ht.get("TRANS_DTIME");
                        if (!this.sendPacket(SendMsg.getSendMsg(ht, SendMsg.L2RollUnitIns, this.end_fl_yn), SendMsg.L2RollUnitIns, client, 1)) {
                            return;
                        }
                        ++i;
                    }
                }
                if ((iSize = (arrData = SendMsg.executeQuery(SendMsg.L2SlabTakeIn)).size()) > 0) {
                    LogUtil.info(log_prefix, " L2SlabTakeIn loop start.");
                    i = 0;
                    while (i < iSize) {
                        ht = (Hashtable)arrData.get(i);
                        this.nSeqNo = (String)ht.get("SEQ_NO");
                        this.transDTime = (String)ht.get("TRANS_DTIME");
                        if (!this.sendPacket(SendMsg.getSendMsg(ht, SendMsg.L2SlabTakeIn, this.end_fl_yn), SendMsg.L2SlabTakeIn, client, 1)) {
                            return;
                        }
                        ++i;
                    }
                }
            } else if (this.acuId.equals("221")) {
                Hashtable ht;
                arrData = SendMsg.executeQuery(SendMsg.L1CoilLock);
                iSize = arrData.size();
                if (iSize > 0) {
                    LogUtil.info(log_prefix, " L1CoilLock loop start.");
                    i = 0;
                    while (i < iSize) {
                        ht = (Hashtable)arrData.get(i);
                        this.nSeqNo = (String)ht.get("SEQ_NO");
                        this.transDTime = (String)ht.get("TRANS_DTIME");
                        if (!this.sendPacket(SendMsg.getSendMsg(ht, SendMsg.L1CoilLock, this.end_fl_yn), SendMsg.L1CoilLock, client, 1)) {
                            return;
                        }
                        ++i;
                    }
                }
                if ((iSize = (arrData = SendMsg.executeQuery(SendMsg.L1CoilTakeIn)).size()) > 0) {
                    LogUtil.info(log_prefix, " L1CoilTakeIn loop start.");
                    i = 0;
                    while (i < iSize) {
                        ht = (Hashtable)arrData.get(i);
                        this.nSeqNo = (String)ht.get("SEQ_NO");
                        this.transDTime = (String)ht.get("TRANS_DTIME");
                        if (!this.sendPacket(SendMsg.getSendMsg(ht, SendMsg.L1CoilTakeIn, this.end_fl_yn), SendMsg.L1CoilTakeIn, client, 1)) {
                            return;
                        }
                        ++i;
                    }
                }
                if ((iSize = (arrData = SendMsg.executeQuery(SendMsg.L1CoilTakeOut)).size()) > 0) {
                    LogUtil.info(log_prefix, " L1CoilTakeOut loop start.");
                    i = 0;
                    while (i < iSize) {
                        ht = (Hashtable)arrData.get(i);
                        this.nSeqNo = (String)ht.get("SEQ_NO");
                        this.transDTime = (String)ht.get("TRANS_DTIME");
                        if (!this.sendPacket(SendMsg.getSendMsg(ht, SendMsg.L1CoilTakeOut, this.end_fl_yn), SendMsg.L1CoilTakeOut, client, 1)) {
                            return;
                        }
                        ++i;
                    }
                }
                if ((iSize = (arrData = SendMsg.executeQuery(SendMsg.L1CoilDest)).size()) > 0) {
                    LogUtil.info(log_prefix, " L1CoilDest loop start.");
                    i = 0;
                    while (i < iSize) {
                        ht = (Hashtable)arrData.get(i);
                        this.nSeqNo = (String)ht.get("SEQ_NO");
                        this.transDTime = (String)ht.get("TRANS_DTIME");
                        if (!this.sendPacket(SendMsg.getSendMsg(ht, SendMsg.L1CoilDest, this.end_fl_yn), SendMsg.L1CoilDest, client, 1)) {
                            return;
                        }
                        ++i;
                    }
                }
            } else if (this.acuId.equals("222")) {
                Hashtable ht;
                arrData = SendMsg.executeQuery(SendMsg.L2CoilNoIns);
                iSize = arrData.size();
                if (iSize > 0) {
                    LogUtil.info(log_prefix, " L2CoilNoIns loop start.");
                    i = 0;
                    while (i < iSize) {
                        ht = (Hashtable)arrData.get(i);
                        this.nSeqNo = (String)ht.get("SET_SEQ");
                        this.transDTime = (String)ht.get("TRANS_DTIME");
                        if (!this.sendPacket(SendMsg.getSendMsg(ht, SendMsg.L2CoilNoIns, this.end_fl_yn), SendMsg.L2CoilNoIns, client, 1)) {
                            return;
                        }
                        ++i;
                    }
                }
                if ((iSize = (arrData = SendMsg.executeQuery(SendMsg.L2MillIns)).size()) > 0) {
                    LogUtil.info(log_prefix, " L2MillIns loop start.");
                    i = 0;
                    while (i < iSize) {
                        ht = (Hashtable)arrData.get(i);
                        this.nSeqNo = (String)ht.get("SEQ_NO");
                        this.transDTime = (String)ht.get("TRANS_DTIME");
                        if (!this.sendPacket(SendMsg.getSendMsg(ht, SendMsg.L2MillIns, this.end_fl_yn), SendMsg.L2MillIns, client, 1)) {
                            return;
                        }
                        ++i;
                    }
                }
                if ((iSize = (arrData = SendMsg.executeQuery(SendMsg.L2RollData)).size()) > 0) {
                    LogUtil.info(log_prefix, " L2RollData loop start.");
                    i = 0;
                    while (i < iSize) {
                        ht = (Hashtable)arrData.get(i);
                        this.nSeqNo = (String)ht.get("SEQ_NO");
                        this.transDTime = (String)ht.get("TRANS_DTIME");
                        if (!this.sendPacket(SendMsg.getSendMsg(ht, SendMsg.L2RollData, this.end_fl_yn), SendMsg.L2RollData, client, 1)) {
                            return;
                        }
                        ++i;
                    }
                }
            }
            LogUtil.info(log_prefix, " SendControlThread Success!!!!!");
        }

        private boolean sendPacket(String sendData, String method, ACUClient client, int count) throws Exception {
            byte[] ret;
            if (count > 3 || !client.sendPacket(sendData)) {
                LogUtil.error(log_prefix, " " + method + " send failed:[" + sendData + "]");
                this.socketFailed();
                return false;
            }
            if (this.ask_yn && (ret = client.receivePacket()) == null) {
                return this.sendPacket(sendData, method, client, ++count);
            }
            if (!SendControl.this.isDebug) {
                SendMsg.executeUpdate(method, new String[]{this.nSeqNo, this.transDTime});
            }
            return true;
        }

        private void socketFailed() throws Exception {
            LogUtil.error("ACU Client -> Thread interrupt.");
        }
    }
}

