/*
 * Decompiled with CFR 0.152.
 */
package core.rfid.data;

import core.util.PosClassLoaderUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ReadXmlMsg {
    public static void main(String[] argv) throws IOException {
        InputStream is = PosClassLoaderUtil.getExtendResource("conf/layout/ChargeIns-msg.xml").openStream();
        List list = ReadXmlMsg.getMsg(is);
        is.close();
        int i = 0;
        while (i < list.size()) {
            NamedNodeMap map = (NamedNodeMap)list.get(i);
            System.out.println(String.valueOf(i) + "\t" + map.item(0) + "\t" + map.item(1) + "\t" + map.item(2));
            ++i;
        }
    }

    public static List getMsg(InputStream is) {
        ArrayList<NamedNodeMap> list = new ArrayList<NamedNodeMap>();
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(is);
            doc.getDocumentElement().normalize();
            NodeList nodes = doc.getElementsByTagName("attribute");
            int count = nodes.getLength();
            int i = 0;
            while (i < count) {
                Node node = nodes.item(i);
                list.add(node.getAttributes());
                ++i;
            }
            Collections.sort(list, new Comparator(){

                public int compare(Object o1, Object o2) {
                    NamedNodeMap n1 = (NamedNodeMap)o1;
                    NamedNodeMap n2 = (NamedNodeMap)o2;
                    return Integer.parseInt(n1.getNamedItem("seq").getNodeValue()) - Integer.parseInt(n2.getNamedItem("seq").getNodeValue());
                }
            });
        }
        catch (SAXParseException err) {
            System.out.println("** Parsing error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println(" " + err.getMessage());
        }
        catch (SAXException e) {
            Exception x = e.getException();
            (x == null ? e : x).printStackTrace();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return list;
    }
}

