package kr.co.comsquare.util;

import java.util.Vector;
import kr.co.comsquare.db.*;
import kr.co.comsquare.util.Utils;


/**
 * 
 * @author Administrator
 *
 */
public class Tokenizer
{
    private String data = null;
    private String delim = null;
    private int index = 0;
    
    /**
     * Tokenizer ü ϰ Ϳ ڸ Ѵ.
     * 
     * @param data ūȭ ų  
     * @param delim ͸ ūȭų   .
     */
	public Tokenizer(String data, String delim)
    {
        this.data = data;
        this.delim = delim;
    }
	
	/**  ūȭ ų  ִ θ ȯѴ. 
	 * 
	 *@return  ūȭ ų  ִٸ true ׷  false ȯѴ.
 	 */
    public boolean next()
    {
        return index <= data.length();
    }

    /**
     * String  ū ȯѴ.
     * 
     * @return String  ū
     * @throws Exception
     */
    public String getString() throws Exception
    {
		String s = null;
		try
		{
			int i = data.indexOf(delim, index);
			if(i == -1)
			{
				s = data.substring(index);
				index = data.length() + 1;
			}else
			{
				if(data.charAt(i-1)=='\\'){
					s=data.substring(index,i);
					index= i + delim.length();
					s+=delim+getString();
				}else {
					s = data.substring(index, i);
					index = i + delim.length();
				}
			}
			return s;
		}
		catch (Exception e)
		{
			byte [] temp = new byte[data.length() + 1];
			temp = data.getBytes();
			e.printStackTrace();
			for (int i = 0; i < temp.length ; i++ ){
				System.out.print(temp[i] + ":"); 
			}
			throw e;
		}
    }
    
    /** Int ū ȯѴ. 
     * 
     * @return Int ū
     * @throws Exception
     */
    public int getInt() throws Exception
    {
		int s = 0;
		try
		{
			int i = data.indexOf(delim, index);
			
			if(i == -1)
			{				s = Integer.parseInt(data.substring(index));

				index = data.length() + 1;
			} else
			{
				if(data.charAt(i-1)=='\\'){
					String tmp="";
					tmp = data.substring(index, i);
					index= i + delim.length();
					tmp+=delim+String.valueOf(getInt());
					s=Integer.parseInt(tmp);
				}else {
					s = Integer.parseInt(data.substring(index, i));
					index = i + delim.length();
				}
			}
			return s;
		}catch (Exception e){
			byte [] temp = new byte[data.length() + 1];
			temp = data.getBytes();
			e.printStackTrace();
			for (int i = 0; i < temp.length ; i++ )
			{
				System.out.print(temp[i] + ":"); 
			}
			throw e;
		}
    }
    
	/**float ū ȯѴ.
	 * 
	 * @return float ū 
	 * @throws Exception
	 */
    public float getFloat() throws Exception
    {
		float s = 0;
		try
		{
			int i = data.indexOf(delim, index);
			if(i == -1)
			{
				s = Float.parseFloat(data.substring(index));
				index = data.length() + 1;
			} else
			{
				if(data.charAt(i-1)=='\\'){
					String tmp="";
					tmp = data.substring(index, i);
					index= i + delim.length();
					tmp+=delim+String.valueOf(getFloat());
					s=Float.parseFloat(tmp);
				}else{
					s = Float.parseFloat(data.substring(index, i));
					index = i + delim.length();
				}
			}
			return s;
		}catch (Exception e){
			byte [] temp = new byte[data.length() + 1];
			temp = data.getBytes();
			e.printStackTrace();
			for (int i = 0; i < temp.length ; i++ )
			{
				System.out.print(temp[i] + ":"); 
			}
			throw e;
		}
    }

    /** double ū ȯѴ.
     * 
     * @return double ū 
     * @throws Exception
     */
    public double getDouble() throws Exception
    {
		double s = 0;
		try
		{
			int i = data.indexOf(delim, index);
			
			if(i == -1){
				s = Double.parseDouble(data.substring(index));
				index = data.length() + 1;
			}else{
				if(data.charAt(i-1)=='\\'){
					String tmp="";
					tmp = data.substring(index, i);
					index= i + delim.length();
					tmp+=delim+String.valueOf(getDouble());
					s=Double.parseDouble(tmp);
				}else{
					s = Double.parseDouble(data.substring(index, i));
					index = i + delim.length();
				}
			}
			return s;
		}catch (Exception e){
			byte [] temp = new byte[data.length() + 1];
			temp = data.getBytes();
			e.printStackTrace();
			for (int i = 0; i < temp.length ; i++ )
			{
				System.out.print(temp[i] + ":"); 
			}
			throw e;
		}
    }

    
    /** long ū ȯѴ.
     * 
     * @return long ū
     * @throws Exception
     */
    public long getLong() throws Exception
    {
		long s = 0;
		try
		{
			int i = data.indexOf(delim, index);
			if(i == -1)
			{
				s = Long.parseLong(data.substring(index));
				index = data.length() + 1;
			}else{
				if(data.charAt(i-1)=='\\'){
					String tmp="";
					tmp = data.substring(index, i);
					index= i + delim.length();
					tmp+=delim+String.valueOf(getLong());
					s=Long.parseLong(tmp);
				}else{
					s = Long.parseLong(data.substring(index, i));
					index = i + delim.length();
				}		
			}
			return s;
		}catch (Exception e){
			byte [] temp = new byte[data.length() + 1];
			temp = data.getBytes();
			e.printStackTrace();
			for (int i = 0; i < temp.length ; i++ )
			{
				System.out.print(temp[i] + ":"); 
			}
			throw e;
		}
    }

    
    /**
     *  ͸ Ͽ شϴ ResultSet row col Ͽ Ѵ.
     *   
     * @param data  ResultSet  
     * @param insertRs insert ͸  ResultSet
     * @param updateRs	update ͸  ResultSet
     * @param deleteRs	delete ͸  ResultSet
     * @param scol	column  .
     * @param srow	row  .
     * @throws NullPointerException
     */
	// ߰ col , row ۷ 
	public static void getSaveResultSet(String data, SaveResultSet insertRs, SaveResultSet updateRs, SaveResultSet deleteRs, String scol, String srow)
		throws NullPointerException
	{
		try
		{
//			data=replaceToEscape(data);
			//hcpark 
			data = data.substring(0, data.length()-srow.length());
			
			//sura 
			insertRs.setSep( srow, scol);
			updateRs.setSep( srow, scol);
			deleteRs.setSep( srow, scol);
			//data = sepReplace( data, srow, scol);
			
			Tokenizer row = new Tokenizer(data, srow);

			Vector keys = new Vector();

			// ù° ࿡ Column Name ´.
			String colName = row.getString();
			Tokenizer title = new Tokenizer(colName, scol);

			for(int i = 0; title.next(); i++)
			{
				keys.addElement(title.getString());
			}

			while(row.next())
			{
				String one_row = row.getString();
				Tokenizer col = new Tokenizer(one_row, scol);

				// ù°  mode  ´. i-insert, u-update, d-delete
				col.next();
				String mode = col.getString();

				for(int i = 1; col.next(); i++)
				{
					if("i".equals(mode))
						insertRs.set((String)keys.elementAt(i), col.getString());
					else if("u".equals(mode))
						updateRs.set((String)keys.elementAt(i), col.getString());
					else if("d".equals(mode))
						deleteRs.set((String)keys.elementAt(i), col.getString());
					else
						col.getString();
				}
				if("i".equals(mode))
					insertRs.next();
				else if("u".equals(mode))
					updateRs.next();
				else if("d".equals(mode))
					deleteRs.next();
			}
			insertRs.first();
			updateRs.first();
			deleteRs.first();
		}catch(Exception e)	{
			throw new NullPointerException("Tokenizer::getSaveResultSet() throw exception for data parsing");
		}
	}
	
	
    /**
     *  ͸ Ͽ شϴ ResultSet row col Ͽ Ѵ.
     *  <br>⺻ row ڴ '|'̰ column ڴ '^'̴.
     *   
     * @param data  ResultSet  
     * @param insertRs insert ͸  ResultSet
     * @param updateRs	update ͸  ResultSet
     * @param deleteRs	delete ͸  ResultSet
     * @throws NullPointerException
     */
	public static void getSaveResultSet(String data, SaveResultSet insertRs, SaveResultSet updateRs, SaveResultSet deleteRs)
		throws NullPointerException
	{
		try
		{
			//park 
//			data=replaceToEscape(data);
			data = data.substring(0, data.length()-1);
			//sura 
			insertRs.setSep( "|", "^");
			updateRs.setSep( "|", "^");
			deleteRs.setSep( "|", "^");
			data = sepReplace( data, "|", "^");

			Tokenizer row = new Tokenizer(data, "|");

			Vector keys = new Vector();

			// ù° ࿡ Column Name ´.
			String colName = row.getString();
			Tokenizer title = new Tokenizer(colName, "^");
			for(int i = 0; title.next(); i++)
			{
				keys.addElement(title.getString());
			}
			while(row.next())
			{
				String one_row = row.getString();
				Tokenizer col = new Tokenizer(one_row, "^");
				
				// ù°  mode  ´. i-insert, u-update, d-delete
				col.next();
				String mode = col.getString();

				for(int i = 1; col.next(); i++)
				{
					String tmp=col.getString();
					if("i".equals(mode))
						insertRs.set((String)keys.elementAt(i),tmp);// col.getString());
					else if("u".equals(mode))
						updateRs.set((String)keys.elementAt(i),tmp);// col.getString());
					else if("d".equals(mode))
						deleteRs.set((String)keys.elementAt(i),tmp);// col.getString());
					else
						;//col.getString();
					//System.out.print(tmp);
				
			
					/*if("i".equals(mode))
						insertRs.set((String)keys.elementAt(i), col.getString());
					else if("u".equals(mode))
						updateRs.set((String)keys.elementAt(i), col.getString());
					else if("d".equals(mode))
						deleteRs.set((String)keys.elementAt(i), col.getString());
					else
						col.getString();*/
				}
				if("i".equals(mode))
					insertRs.next();
				else if("u".equals(mode))
					updateRs.next();
				else if("d".equals(mode))
					deleteRs.next();
			}
			insertRs.first();
			updateRs.first();
			deleteRs.first();
		}catch(Exception e){
			throw new NullPointerException("Tokenizer::getSaveResultSet() throw exception for data parsing");
		}
	}
	
	/** ͸ Ͽ شϴ ResultSet row col Ͽ Ѵ.<br>
     *  insert, update, delete  ʰ ϳ ResultSet ȯѴ.
     *  
     * @param data  ResultSet  
     * @param sModeName  ̸ 
	 * @param totalRs
	 * @throws NullPointerException
	 */
    //2005-09-20(snoweye) : i, u, d  ʰ ϳ ResultSet ȯϴ Լ
    public static void getSaveResultSet(String data, String sModeName, SaveResultSet totalRs)
		throws NullPointerException
	{
		try
		{			
//			data=replaceToEscape(data);
			data = data.substring(0, data.length()-1);
			//sura 
			totalRs.setSep( "|", "^");
			data = sepReplace( data, "|", "^");

			Tokenizer row = new Tokenizer(data, "|");//row  

			Vector keys = new Vector();

			//[[ ù° ࿡ Column Name ´.(  
			String colName = row.getString();// ù° row ؿ´. (header)

			Tokenizer title = new Tokenizer(colName, "^");

			for(int i = 0; title.next(); i++)
			{
				keys.addElement( title.getString() );
			}
            //]]
			while(row.next())
			{
				String one_row = row.getString();
				Tokenizer col = new Tokenizer(one_row, "^");//ະ Ÿ ÷  ɰ.

				// ù°  mode  ´. i-insert, u-update, d-delete
				col.next();
				String mode = col.getString();
                totalRs.set(sModeName, mode);

				for(int i = 1; col.next(); i++)
				{
					totalRs.set((String)keys.elementAt(i), col.getString());
				}				
                totalRs.next();
			}
            totalRs.first();
		}
		catch(Exception e)
		{
			throw new NullPointerException("Tokenizer::getSaveResultSet() throw exception for data parsing");
		}
	}

    
    /**
     * ͸ Ͽ شϴ ResultSet row col Ͽ Ѵ.<br>
     * insert, update, delete  ʰ ϳ ResultSet ȯѴ.
     * 
     * @param data
     * @param sModeName
     * @param totalRs
     * @param scol
     * @param srow
     * @throws NullPointerException
     */
    //2005-09-20(snoweye) : i, u, d  ʰ ϳ ResultSet ȯϴ Լ
    public static void getSaveResultSet(String data, String sModeName, SaveResultSet totalRs, String scol, String srow)
		throws NullPointerException
	{
		try
		{
//			data=replaceToEscape(data);
			//hcpark 
			data = data.substring(0, data.length()-srow.length());

			//sura 
			totalRs.setSep( srow, scol);
			data = sepReplace( data, srow, scol);

			Tokenizer row = new Tokenizer(data, srow);//row  

			Vector keys = new Vector();

			//[[ ù° ࿡ Column Name ´.(  
			String colName = row.getString();// ù° row ؿ´. (header)
			Tokenizer title = new Tokenizer(colName, scol);
			for(int i = 0; title.next(); i++)
			{
				keys.addElement(title.getString());
			}
            //]]
			while(row.next())
			{
				String one_row = row.getString();
				Tokenizer col = new Tokenizer(one_row, scol);//ະ Ÿ ÷  ɰ.

				// ù°  mode  ´. i-insert, u-update, d-delete
				col.next();

				String mode = col.getString();

				totalRs.set(sModeName, mode);

				for(int i = 1; col.next(); i++)
				{
//				s = Utils.replace(col.getString(),  "\\\\", "\\");
//					totalRs.set((String)keys.elementAt(i), col.getString());
					totalRs.set((String)keys.elementAt(i), Utils.replace(col.getString(),  "\\\\", "\\"));
				}				
                totalRs.next();
			}
            totalRs.first();
		}
		catch(Exception e)
		{
			throw new NullPointerException("Tokenizer::getSaveResultSet() throw exception for data parsing");
		}
	}

    
    
	/**
	 * Ƽ update data  ڰ Ե  Ư ڿ ȯմϴ.
	 * ex)  "/^" -> "\^"
	 * 
	 * @param   str			  ڿ
	 * @param   rowsep 	row 
	 * @param   colsep 	collum 
	 * @return   str 	 ڿ
	 */	
	public static String sepReplace(String str, String rowsep, String colsep){
		String temp = str;
		//temp = Utils.replace(str, "//", "SLashslaSH");
//		temp = Utils.replace(temp,  "/"+colsep, "\\"+colsep);
//		temp = Utils.replace(temp,"/"+rowsep, "\\"+ rowsep);
		str = temp;
		//System.out.println("sepReplace:"+str);
		return str;
	}

    public static void main(String args[])
    {
    	Tokenizer token=new Tokenizer("203.253.23.1:8080",":");
    	while(token.next()){
    		try{
    		System.out.println("test:"+token.getString());
    		}catch(Exception e){
    			
    		}
    	}
//    	
//        String data = "jan^feb^mar^apl^may^jun^jul^aug|" +	
//					"p^1^2^3^4^5^6^7|" +
//					"i^1^2^3^4^5^6^7|" + 
//					"i^1^2^3^4^5^6^7|" +
//					"i^1^2^3^4^5^6^7|" + 
//					"d^1|" +
//					"a^1^2^3^4^5^6^7|";
//       
////        System.out.println("test start");
//		SaveResultSet insertRs = new SaveResultSet();
//		SaveResultSet updateRs = new SaveResultSet();
//		SaveResultSet deleteRs = new SaveResultSet();
//
//		Tokenizer.getSaveResultSet(data, insertRs, updateRs, deleteRs);
//		System.out.println(insertRs.getTotalRow());
//		System.out.println(updateRs.getTotalRow());
//		System.out.println(deleteRs.getTotalRow());
//
//		if(insertRs.getTotalRow() > 0)
//		while(insertRs.next())
//		{
//			System.out.print("i:");
//			System.out.print(insertRs.get("jan"));
//			System.out.print(insertRs.get("feb"));
//			System.out.print(insertRs.get("mar"));
//			System.out.print(insertRs.get("apl"));
//			System.out.print(insertRs.get("may"));
//			System.out.print(insertRs.get("jun"));
//			System.out.print(insertRs.get("jul"));
//			System.out.println(insertRs.get("aug"));
//		}
//		if(updateRs.getTotalRow() > 0)
//		while(updateRs.next())
//		{
//			System.out.print("u:");
//			System.out.print(updateRs.get("jan"));
//			System.out.print(updateRs.get("feb"));
//			System.out.print(updateRs.get("mar"));
//			System.out.print(updateRs.get("apl"));
//			System.out.print(updateRs.get("may"));
//			System.out.print(updateRs.get("jun"));
//			System.out.print(updateRs.get("jul"));
//			System.out.println(updateRs.get("aug"));
//		}
//		if(deleteRs.getTotalRow() > 0)
//		while(deleteRs.next())
//		{
//			System.out.print("d:");
//			System.out.print(insertRs.get("jan"));
//			System.out.println(deleteRs.get("feb"));
//		}
    }
    
    //str  Ͷ Ѵ.
	public static String replaceToEscape(String str){ // ^, | , ! , \  ڸ Escapeڷ ȯ.
		int i=0;
		StringBuffer strb = new StringBuffer(str);
		for(i=0;i<str.length();++i){
			if(strb.charAt(i)=='^'||strb.charAt(i)=='|'||strb.charAt(i)=='!'||strb.charAt(i)=='\\'){
				strb.replace(i,i+1,"\\"+strb.charAt(i));
			}
		}
		return strb.toString();	
	}
}