/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.ui.tags;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;

public class ShowCalendar {
    protected int size;
    protected int maxLength;
    protected boolean isDetail;
    protected String cls;
    protected boolean isRequestFirst;
    protected boolean defaultCurrentDate;
    protected String defaultTexts;
    protected String name;
    protected String txtFormat;
    private ServletRequest request;
    protected String[] extraParameterArray;
    boolean isRepeated = false;
    protected String[] defaultTextArray;
    protected HashMap optionsMap;

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public boolean getIsDetail() {
        return this.isDetail;
    }

    public void setIsDetail(boolean isDetail) {
        this.isDetail = isDetail;
    }

    public String getCls() {
        return this.cls;
    }

    public void setCls(String cls) {
        this.cls = cls;
    }

    public boolean getIsRequestFirst() {
        return this.isRequestFirst;
    }

    public void setIsRequestFirst(boolean isRequestFirst) {
        this.isRequestFirst = isRequestFirst;
    }

    public boolean getDefaultCurrentDate() {
        return this.defaultCurrentDate;
    }

    public void setDefaultCurrentDate(String defaultCurrentDate) {
        if (defaultCurrentDate != null && defaultCurrentDate.equals("true")) {
            this.defaultCurrentDate = true;
        }
    }

    public String getDefaultTexts(int index) {
        if (this.defaultTextArray == null) {
            return null;
        }
        if (this.defaultTextArray.length > index) {
            return this.defaultTextArray[index];
        }
        return null;
    }

    public void setDefaultTexts(String defaultTexts) {
        this.defaultTexts = defaultTexts;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTxtFormat() {
        return this.txtFormat;
    }

    public void setTxtFormat(String txtFormat) {
        this.txtFormat = txtFormat != null ? txtFormat : "";
    }

    public String buildStartInputTextTag(String type) {
        return "<input type=\"" + type + "\"";
    }

    public String makeAttribute(String name, String value) {
        if (name != null && value != null && value.length() > 0) {
            if (name.equals(" ")) {
                return name + value;
            }
            return name + "=\"" + value + "\"";
        }
        return null;
    }

    public ServletRequest getServletRequest() {
        return this.request;
    }

    public void setServletRequest(ServletRequest servletRequest) {
        this.request = servletRequest;
    }

    public boolean getRequestedString(String name, String value) {
        String tmpObject;
        if (name != null && value != null && this.getServletRequest() != null && (tmpObject = this.getServletRequest().getParameter(name)) != null) {
            if (this.isArrayRequestElement(name)) {
                String[] tmpStrArr = this.getServletRequest().getParameterValues(name);
                for (int tmpIdx = 0; tmpIdx < tmpStrArr.length; ++tmpIdx) {
                    if (!value.equalsIgnoreCase(tmpStrArr[tmpIdx])) continue;
                    return true;
                }
            } else {
                String tmpStr = this.getServletRequest().getParameter(name);
                if (value.equalsIgnoreCase(tmpStr)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isArrayRequestElement(String name) {
        String[] tmpStrArr;
        return this.getServletRequest() != null && (tmpStrArr = this.getServletRequest().getParameterValues(name)) != null && tmpStrArr.length > 1;
    }

    private String getRequestedStrIdx(String name, int index) {
        String[] tmpStr;
        String[] tmpObject = this.getServletRequest().getParameterValues(name);
        if (tmpObject != null && index > -1 && (tmpStr = tmpObject) != null && tmpStr.length > index) {
            return tmpStr[index];
        }
        return null;
    }

    public String build() {
        Object tmpString = null;
        Object tmpSelectedRowArray = null;
        StringBuffer strHtml = new StringBuffer(1024);
        if (this.getName() == null) {
            return null;
        }
        this.isRepeated = true;
        this.appendNewLine(strHtml);
        if (this.getDefaultCurrentDate()) {
            this.appendStrBuffer(strHtml, this.buildOneTextField(this.getName(), this.getCurrentDate()));
        } else {
            this.appendStrBuffer(strHtml, this.buildOneTextField(this.getName(), this.getDefaultTexts(0)));
        }
        this.appendNewLine(strHtml);
        this.appendStrBuffer(strHtml, this.buildImageTag());
        this.appendNewLine(strHtml);
        return strHtml.toString();
    }

    public String buildImageTag() {
        String tmpString = null;
        StringBuffer strHtml = new StringBuffer(1024);
        this.appendStrBuffer(strHtml, "<img src=\"/img/m000010img.gif\"");
        this.appendStrBuffer(strHtml, " style=\"cursor:hand\"");
        this.appendStrBuffer(strHtml, " border=\"0\" onClick=\"javascript:");
        this.appendStrBuffer(strHtml, "jspCalendar");
        this.appendStrBuffer(strHtml, "(this.parentElement.index,");
        this.appendStrBuffer(strHtml, this.getName());
        this.appendStrBuffer(strHtml, ",'" + this.getTxtFormat() + "'");
        this.appendStrBuffer(strHtml, ", '" + this.isDetail + "'");
        this.appendStrBuffer(strHtml, ");\">");
        this.appendStrBuffer(strHtml, tmpString);
        return strHtml.toString();
    }

    public String buildOneTextField(String name, String value) {
        String tmpStr;
        String tmpString = null;
        StringBuffer strHtml = new StringBuffer(1024);
        strHtml.append(this.buildStartInputTextTag("text"));
        tmpString = this.makeAttribute(" name", name);
        if (tmpString == null && (tmpString = this.makeAttribute(" name", this.getName())) == null) {
            tmpString = this.makeAttribute(" name", "server_calendar");
        }
        this.appendStrBuffer(strHtml, tmpString);
        tmpString = this.getSize() != -1 ? this.makeAttribute(" size", "" + this.getSize()) : (!this.getTxtFormat().equals("") ? this.makeAttribute(" size", "" + this.getTxtFormat().length()) : this.makeAttribute(" size", "10"));
        this.appendStrBuffer(strHtml, tmpString);
        tmpString = this.getMaxLength() != -1 ? this.makeAttribute(" maxlength", "" + this.getMaxLength()) : (!this.getTxtFormat().equals("") ? this.makeAttribute(" maxlength", "" + this.getTxtFormat().length()) : this.makeAttribute(" maxlength", "10"));
        this.appendStrBuffer(strHtml, tmpString);
        tmpString = this.getIsRequestFirst() ? ((tmpStr = this.getRequestedString(name)) == null ? this.makeAttribute(" value", value) : this.makeAttribute(" value", tmpStr)) : this.makeAttribute(" value", value);
        this.appendStrBuffer(strHtml, tmpString);
        tmpString = this.makeAttribute(" class", this.getCls());
        if (tmpString == null) {
            tmpString = this.makeAttribute(" class", "adb1");
        }
        this.appendStrBuffer(strHtml, tmpString);
        strHtml.append(">");
        return strHtml.toString();
    }

    public String getRequestedString(String name) {
        String tmpObject;
        if (name != null && this.getServletRequest() != null && (tmpObject = this.getServletRequest().getParameter(name)) != null) {
            if (this.isArrayRequestElement(name)) {
                return this.getRequestedStrIdx(name, this.getRequestedStringRefCnt(name));
            }
            String tmpStr = tmpObject;
            return tmpStr;
        }
        return null;
    }

    private int getRequestedStringRefCnt(String name) {
        int refCnt = -1;
        if (name != null && this.getServletRequest() != null) {
            Integer tmpInt = (Integer)this.getServletRequest().getAttribute(name + "Save");
            if (tmpInt != null) {
                refCnt = tmpInt;
                this.getServletRequest().setAttribute(name + "Save", (Object)new Integer(refCnt + 1));
                return refCnt;
            }
            this.getServletRequest().setAttribute(name + "Save", (Object)new Integer(1));
            return 0;
        }
        return refCnt;
    }

    public void appendStrBuffer(StringBuffer strBuffer, String addStr) {
        if (strBuffer != null && addStr != null) {
            strBuffer.append(addStr);
        }
    }

    public void appendNewLine(StringBuffer strHtml) {
        if (this.isRepeated) {
            strHtml.append("\n");
            strHtml.append("  ");
        }
    }

    public void setExtraParameterArray(String extraParameters) {
        this.extraParameterArray = this.convertStrToArray(extraParameters, 2);
    }

    public String[] getExtraParameterArray() {
        return this.extraParameterArray;
    }

    public String getExtraParameter(int index) {
        if (this.extraParameterArray == null) {
            return null;
        }
        if (this.extraParameterArray.length > index) {
            return this.extraParameterArray[index];
        }
        return null;
    }

    public String[] convertStrToArray(String srcStr, int minLength) {
        String[] returnArray = null;
        String[] tmpArray = this.parseParameters(srcStr);
        if (tmpArray != null) {
            if (tmpArray.length < minLength) {
                returnArray = new String[minLength];
                System.arraycopy(tmpArray, 0, returnArray, 0, tmpArray.length);
            } else {
                returnArray = tmpArray;
            }
        }
        return returnArray;
    }

    public String[] parseParameters(String temp) {
        if (temp != null && temp.length() != 0) {
            StringTokenizer tokenizer = new StringTokenizer(temp, "|");
            int numTokens = tokenizer.countTokens();
            String[] result = new String[numTokens];
            int i = 0;
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken().trim();
                if (token.equals("null")) {
                    token = "";
                }
                result[i] = token;
                ++i;
            }
            return result;
        }
        return null;
    }

    public void setDefaultTextArray(String defaultTexts) {
        this.defaultTextArray = this.convertStrToArray(defaultTexts, 2);
    }

    public String getCurrentDate() {
        StringBuffer strHtml = new StringBuffer(1024);
        Date date = new Date(System.currentTimeMillis());
        Calendar now = Calendar.getInstance();
        now.setTime(date);
        String currDate = "";
        String currTime = "";
        if (this.getTxtFormat().toUpperCase().indexOf("YYYY") != -1) {
            int year = now.get(1);
            if (this.getTxtFormat().indexOf("MM") != -1) {
                int tmpyear = now.get(1);
                int[] tmpmonDay = ShowCalendar.julianToMonthDay(tmpyear, now.get(6));
                int month = tmpmonDay[0];
                if (this.getTxtFormat().toUpperCase().indexOf("DD") != -1) {
                    int day = tmpmonDay[1];
                    if (this.getTxtFormat().toUpperCase().indexOf("HH") != -1) {
                        int hour = now.get(11);
                        if (this.getTxtFormat().indexOf("mm") != -1) {
                            int minute = now.get(12);
                            if (this.getTxtFormat().toUpperCase().indexOf("SS") != -1) {
                                int second = now.get(13);
                                currDate = "" + year + (month < 10 ? "-0" : "-") + month + (day < 10 ? "-0" : "-") + day;
                                currTime = "" + (hour < 10 ? "0" : "") + hour + (minute < 10 ? ":0" : ":") + minute + (second < 10 ? ":0" : ":") + second;
                            } else {
                                currDate = "" + year + (month < 10 ? "-0" : "-") + month + (day < 10 ? "-0" : "-") + day;
                                currTime = "" + (hour < 10 ? "0" : "") + hour + (minute < 10 ? ":0" : ":") + minute;
                            }
                        } else {
                            currDate = "" + year + (month < 10 ? "-0" : "-") + month + (day < 10 ? "-0" : "-") + day;
                            currTime = "" + (hour < 10 ? "0" : "") + hour;
                        }
                    } else {
                        currDate = "" + year + (month < 10 ? "-0" : "-") + month + (day < 10 ? "-0" : "-") + day;
                    }
                } else {
                    currDate = "" + year + (month < 10 ? "-0" : "-") + month;
                }
            } else {
                currDate = "" + year;
            }
            if (currTime == "") {
                this.appendStrBuffer(strHtml, currDate);
                this.appendStrBuffer(strHtml, currTime);
            } else {
                this.appendStrBuffer(strHtml, currDate);
                this.appendStrBuffer(strHtml, " ");
                this.appendStrBuffer(strHtml, currTime);
            }
            return strHtml.toString();
        }
        int year = now.get(1);
        int[] monDay = ShowCalendar.julianToMonthDay(year, now.get(6));
        int month = monDay[0];
        int day = monDay[1];
        int hour = now.get(11);
        int minute = now.get(12);
        int second = now.get(13);
        currDate = "" + year + (month < 10 ? "-0" : "-") + month + (day < 10 ? "-0" : "-") + day;
        currTime = "" + (hour < 10 ? "0" : "") + hour + (minute < 10 ? ":0" : ":") + minute + (second < 10 ? ":0" : ":") + second;
        this.appendStrBuffer(strHtml, currDate);
        if (this.getIsDetail()) {
            this.appendStrBuffer(strHtml, " ");
            this.appendStrBuffer(strHtml, currTime);
        }
        return strHtml.toString();
    }

    public static int[] julianToMonthDay(int year, int jday) {
        int[] not_leap = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int[] leap = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        boolean leapYear = false;
        int[] monthAndDay = new int[]{0, 0};
        if (year % 4 == 0) {
            leapYear = true;
        }
        if (leapYear && jday > 366) {
            System.err.println("Only 366 days in a leap year!!!");
            return null;
        }
        if (!leapYear && jday > 365) {
            System.err.println("Only 365 days in a non leap year!!!");
            return null;
        }
        int numdays = 0;
        for (int i = 0; i < 12; ++i) {
            int j = leapYear ? leap[i] : not_leap[i];
            if ((numdays += j) < jday) continue;
            monthAndDay[0] = i + 1;
            monthAndDay[1] = jday - (numdays - j);
            return monthAndDay;
        }
        return null;
    }

    public Object getOptions(String key) {
        if (this.optionsMap != null) {
            return this.optionsMap.get(key);
        }
        return null;
    }

    public void setOptionsArray(String options) {
        String[] tmpOptionsArray = this.convertStrToArray(options, 0);
        if (tmpOptionsArray != null) {
            this.optionsMap = new HashMap(10);
            for (int idx = 0; idx < tmpOptionsArray.length; ++idx) {
                String upperStr;
                String tmpStr = tmpOptionsArray[idx];
                if (tmpStr == null || !"hideCheckBox".equalsIgnoreCase(upperStr = tmpStr.toUpperCase())) continue;
                this.optionsMap.put("hideCheckBox", tmpStr);
            }
        }
    }
}

