/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.ui.tags;

import com.posdata.glue.dao.vo.PosRow;
import com.posdata.glue.dao.vo.PosRowSet;
import com.posdata.glue.ui.tags.ShowDefaultControl;
import com.posdata.glue.ui.tags.util.PosTagUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.StringTokenizer;

public abstract class ShowInfoData
extends ShowDefaultControl {
    protected Object object;
    protected String nameAttribute;
    protected String valueAttribute;
    protected String keyAttribute;
    protected String displayAttribute;
    protected String keyValue;
    protected String[] staticNameArray;
    protected String[] staticValueArray;
    protected String[] staticDisplayValueArray;
    protected String[] extraParameterArray;
    protected boolean isStatic;
    protected boolean isDistinct;

    public Object getObject() {
        return this.object;
    }

    public void setObject(String object) {
        if (this.info != null && object != null) {
            this.object = this.info.getInfoObject(object);
        }
    }

    public String getNameAttribute() {
        return this.nameAttribute;
    }

    public void setNameAttribute(String nameAttribute) {
        this.nameAttribute = nameAttribute;
    }

    public String getValueAttribute() {
        return this.valueAttribute;
    }

    public void setValueAttribute(String valueAttribute) {
        this.valueAttribute = valueAttribute;
    }

    public String getDisplayAttribute() {
        return this.displayAttribute;
    }

    public void setDisplayAttribute(String displayAttribute) {
        this.displayAttribute = displayAttribute;
    }

    public String getKeyAttribute() {
        return this.keyAttribute;
    }

    public void setKeyAttribute(String keyAttribute) {
        this.keyAttribute = keyAttribute;
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(String keyValue) {
        this.keyValue = keyValue;
    }

    public String[] getStaticNameArray() {
        return this.staticNameArray;
    }

    public String getStaticName(int index) {
        if (this.staticNameArray == null) {
            return null;
        }
        if (this.staticNameArray.length > index) {
            return this.staticNameArray[index];
        }
        return null;
    }

    public void setStaticNameArray(String staticNames) {
        this.staticNameArray = PosTagUtil.parseParameters(staticNames, "|");
    }

    public void setStaticNameArray(String staticNames, String delimiter) {
        this.staticNameArray = PosTagUtil.parseParameters(staticNames, delimiter);
    }

    public String[] getStaticValueArray() {
        return this.staticValueArray;
    }

    public String getStaticValue(int index) {
        if (this.staticValueArray == null) {
            return null;
        }
        if (this.staticValueArray.length > index) {
            return this.staticValueArray[index];
        }
        return null;
    }

    public void setStaticValueArray(String staticValues) {
        if (this.staticNameArray != null) {
            this.staticValueArray = PosTagUtil.convertStrToArray(staticValues, this.staticNameArray.length);
        }
    }

    public void setStaticValueArray(String staticValues, String delimiter) {
        if (this.staticNameArray != null) {
            this.staticValueArray = PosTagUtil.convertStrToArray(staticValues, this.staticNameArray.length, delimiter);
        }
    }

    public String getStaticDisplayValue(int index) {
        if (this.staticDisplayValueArray == null) {
            return null;
        }
        if (this.staticDisplayValueArray.length > index) {
            return this.staticDisplayValueArray[index];
        }
        return null;
    }

    public void setStaticDisplayValueArray(String staticDisplayValues) {
        if (this.staticNameArray != null) {
            this.staticDisplayValueArray = PosTagUtil.convertStrToArray(staticDisplayValues, this.staticNameArray.length);
        }
    }

    public String[] getExtraParameterArray() {
        return this.extraParameterArray;
    }

    public String getExtraParameter(int index) {
        if (this.extraParameterArray == null) {
            return null;
        }
        if (this.extraParameterArray.length > index) {
            return this.extraParameterArray[index];
        }
        return null;
    }

    public void setExtraParameterArray(String extraParameters) {
        this.extraParameterArray = PosTagUtil.convertStrToArray(extraParameters, 0);
    }

    public boolean getIsStatic() {
        return this.isStatic;
    }

    public void setIsStatic(String isStatic) {
        if (isStatic != null && isStatic.equals("true")) {
            this.isStatic = true;
        }
    }

    public boolean getIsDistinct() {
        return this.isDistinct;
    }

    public void setIsDistinct(String isDistinct) {
        if (isDistinct != null && isDistinct.equals("true")) {
            this.isDistinct = true;
        }
    }

    public boolean isObjectAvailable() {
        return this.getObject() != null && (this.getObject() instanceof PosRowSet || this.getObject() instanceof PosRow);
    }

    public boolean isStaticDataAvailable() {
        return this.getStaticNameArray() != null;
    }

    public boolean checkAttribute() {
        if (!this.isObjectAvailable() && !this.isStaticDataAvailable()) {
            return false;
        }
        return !this.getIsStatic() || this.isStaticDataAvailable();
    }

    public String[] getObjectData(ArrayList selectedRowList, String attribute) {
        if (!this.isObjectAvailable()) {
            return null;
        }
        if (selectedRowList == null) {
            String[] valueData = new String[selectedRowList.size()];
            int tmpLength = selectedRowList.size();
            for (int idx = 0; idx < tmpLength; ++idx) {
                valueData[idx] = this.getBottomObject(selectedRowList.get(idx), attribute);
            }
            return valueData;
        }
        return null;
    }

    public ArrayList getSelectedRow(String attribute, String value) {
        if (!this.isObjectAvailable()) {
            return null;
        }
        ArrayList<Object> selectRowList = new ArrayList<Object>(10);
        if (this.object instanceof PosRowSet) {
            PosRowSet rowSet = (PosRowSet)this.object;
            rowSet.reset();
            while (rowSet.hasNext()) {
                String attributeValue;
                PosRow row = rowSet.next();
                if (attribute == null || value == null) {
                    this.insertRowToArrayList(selectRowList, row);
                    continue;
                }
                if (attribute == null || value == null || (attributeValue = this.getBottomObject(row, attribute)) == null || !attributeValue.equals(value)) continue;
                this.insertRowToArrayList(selectRowList, row);
            }
        } else if (this.object instanceof PosRow) {
            selectRowList.add(this.object);
        }
        return selectRowList;
    }

    public void insertRowToArrayList(ArrayList list, PosRow row) {
        boolean isDuplicated = false;
        if (list == null || row == null) {
            return;
        }
        String newName = this.getBottomObject(row, this.getNameAttribute());
        String newValue = this.getBottomObject(row, this.getValueAttribute());
        if (this.getIsDistinct()) {
            int tmpLength = list.size();
            for (int idx = 0; idx < tmpLength; ++idx) {
                PosRow tmpRow = (PosRow)list.get(idx);
                String tmpName = this.getBottomObject(tmpRow, this.getNameAttribute());
                String tmpValue = this.getBottomObject(tmpRow, this.getValueAttribute());
                if (!(tmpName != null && tmpValue != null ? tmpName.equals(newName) && tmpValue.equals(newValue) : (tmpName == null && tmpValue != null ? newName == null && tmpValue.endsWith(newValue) : tmpName != null && tmpValue == null && tmpName.equals(newName) && newValue == null))) continue;
                return;
            }
        }
        list.add(row);
    }

    public String getBottomObject(Object initial, String attributeName) {
        String methodName = null;
        String emptyString = "";
        if (initial != null && attributeName != null) {
            StringTokenizer st = new StringTokenizer(attributeName, ".");
            try {
                while (st.hasMoreElements() && initial != null) {
                    String tempStr;
                    methodName = tempStr = st.nextElement().toString();
                    Method method = initial.getClass().getMethod(methodName, null);
                    initial = method.invoke(initial, null);
                }
                if (initial != null) {
                    return initial.toString();
                }
                return emptyString;
            }
            catch (InvocationTargetException i) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (NoSuchMethodException n) {
                if (initial != null && initial instanceof PosRow) {
                    try {
                        String firstChar = attributeName.substring(0, 1);
                        attributeName = firstChar.toUpperCase() + attributeName.substring(1);
                        Object tmpObject = ((PosRow)initial).getAttribute(attributeName);
                        if (tmpObject != null) {
                            return tmpObject.toString();
                        }
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
                return null;
            }
        }
        return null;
    }
}

