/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.ui.tags;

public class ShowPageSet {
    private String formName;
    private String infoName;
    private String[] paramNames;
    private String[] paramValues;
    private String options;
    private int curPageNum;
    private String curPageName;
    private int totalSize;
    private int pageSize;
    private int totalPageNum;

    protected String buildHTML() {
        StringBuffer htmlBuffer = new StringBuffer(1024);
        htmlBuffer.append("<center>");
        htmlBuffer.append("  <table>\r\n");
        htmlBuffer.append("    <tr>\r\n");
        htmlBuffer.append("      <td>\r\n");
        htmlBuffer.append("<font style=\"font-family:Gulim;\">\r\n");
        htmlBuffer.append("        " + this.makeSymbol("\u25c0") + "\r" + "\n");
        htmlBuffer.append("        " + this.makeSymbol("[Prev]") + "\r" + "\n");
        int pageNum = this.calculatePageNum();
        int startPageNum = (this.curPageNum - 1) / 10 * 10 + 1;
        for (int i = 0; i < pageNum; ++i) {
            int num = startPageNum + i;
            String symbol = "[" + String.valueOf(num) + "]";
            htmlBuffer.append("        " + this.makeNum(num, symbol) + "\r" + "\n");
        }
        htmlBuffer.append("        " + this.makeSymbol("[Next]") + "\r" + "\n");
        htmlBuffer.append("        " + this.makeSymbol("\u25b6") + "\r" + "\n");
        htmlBuffer.append("      </td>\r\n");
        htmlBuffer.append("    </tr>\r\n");
        htmlBuffer.append("  </table>\r\n");
        htmlBuffer.append("  <input type=\"hidden\" name=\"isPageSet\" value=\"true\" />\r\n");
        htmlBuffer.append("  <input type=\"hidden\" name=\"" + this.curPageName + "\" value=\"" + this.curPageNum + "\"  />" + "\r" + "\n");
        htmlBuffer.append("</center>\r\n");
        String param = "";
        if (this.paramNames != null) {
            for (int i = 0; i < this.paramNames.length; ++i) {
                param = param + "&" + this.paramNames[i] + "=" + this.paramValues[i];
            }
        }
        htmlBuffer.append(this.addJavaScript(param));
        return htmlBuffer.toString();
    }

    private String addJavaScript(String param) {
        StringBuffer htmlBuffer = new StringBuffer(1024);
        htmlBuffer.append("<script language=\"JavaScript\">\r\n");
        htmlBuffer.append("<!--\r\n");
        htmlBuffer.append("  function showPageSetSubmit(curPage,curPageName)\r\n");
        htmlBuffer.append("  {\r\n");
        htmlBuffer.append("    var tmpAction = " + this.formName + ".action;" + "\r" + "\n");
        htmlBuffer.append("    var isQuestionMarkExist = false;\r\n");
        htmlBuffer.append("    for (var i=0; i<tmpAction.length; i++)\r\n");
        htmlBuffer.append("    {\r\n");
        htmlBuffer.append("      if (tmpAction.charAt(i)=='?')\r\n");
        htmlBuffer.append("      {\r\n");
        htmlBuffer.append("        isQuestionMarkExist = true;\r\n");
        htmlBuffer.append("      }\r\n");
        htmlBuffer.append("    }\r\n");
        htmlBuffer.append("    if (isQuestionMarkExist)\r\n");
        htmlBuffer.append("    {\r\n");
        htmlBuffer.append("      tmpAction += curPageName+\"=\" + curPage+\"&pageEvent=1&curPageName=\"+curPageName;\r\n");
        htmlBuffer.append("    } else\r\n");
        htmlBuffer.append("    {\r\n");
        htmlBuffer.append("      tmpAction += \"?\"+curPageName+\"=\" + curPage+\"&pageEvent=1&curPageName=\"+curPageName;\r\n");
        htmlBuffer.append("    }\r\n");
        htmlBuffer.append("    " + this.formName + ".action = tmpAction + \"" + param + "\";" + "\r" + "\n");
        htmlBuffer.append("    " + this.formName + ".submit();" + "\r" + "\n");
        htmlBuffer.append("  }\r\n");
        htmlBuffer.append("-->\r\n");
        htmlBuffer.append("</script>\r\n");
        return htmlBuffer.toString();
    }

    private int calculatePageNum() {
        int pageNum = 0;
        int diff = this.totalPageNum - this.curPageNum;
        int lastPageNum = this.totalPageNum % 10;
        pageNum = diff >= lastPageNum && this.totalPageNum >= 10 ? 10 : (lastPageNum < 1 ? 1 : lastPageNum);
        return pageNum;
    }

    private String makeSymbol(String symbol) {
        StringBuffer htmlBuffer = new StringBuffer(1024);
        int index = 1;
        if ("\u25c0".equals(symbol)) {
            if (this.totalPageNum > 1 && this.curPageNum > 1) {
                htmlBuffer.append(this.makeHref(1, symbol));
            } else {
                htmlBuffer.append(symbol);
            }
        } else if ("\u25b6".equals(symbol)) {
            if (this.curPageNum == this.totalPageNum || this.totalPageNum == 1) {
                htmlBuffer.append(symbol);
            } else {
                htmlBuffer.append(this.makeHref(this.totalPageNum, symbol));
            }
        } else if ("[Prev]".equals(symbol)) {
            if (this.curPageNum > 10) {
                index = (this.curPageNum / 10 - 1) * 10 + 1;
                htmlBuffer.append(this.makeHref(index, symbol));
            } else {
                htmlBuffer.append(symbol);
            }
        } else if ("[Next]".equals(symbol)) {
            if (this.totalPageNum > 10 && this.totalPageNum / 10 - this.curPageNum / 10 > 0) {
                index = ((this.curPageNum - 1) / 10 + 1) * 10 + 1;
                htmlBuffer.append(this.makeHref(index, symbol));
            } else {
                htmlBuffer.append(symbol);
            }
        }
        return htmlBuffer.toString();
    }

    private String makeNum(int index, String symbol) {
        StringBuffer htmlBuffer = new StringBuffer(1024);
        if (index == this.curPageNum || this.curPageNum == 0) {
            htmlBuffer.append("<b>" + symbol + "</b>");
        } else {
            htmlBuffer.append(this.makeHref(index, symbol));
        }
        return htmlBuffer.toString();
    }

    private String makeHref(int index, String symbol) {
        StringBuffer htmlBuffer = new StringBuffer(1024);
        htmlBuffer.append("<a href=\"javascript:showPageSetSubmit(" + index + ",'" + this.curPageName + "')\"");
        htmlBuffer.append(">");
        htmlBuffer.append(symbol);
        htmlBuffer.append("</a>");
        return htmlBuffer.toString();
    }

    protected void calculateTotalPageNum() {
        this.totalPageNum = this.totalSize / this.pageSize;
        if (this.totalSize % this.pageSize > 0) {
            ++this.totalPageNum;
        }
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getInfoName() {
        return this.infoName;
    }

    public void setInfoName(String infoName) {
        this.infoName = infoName;
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public void setParamNames(String[] paramNames) {
        this.paramNames = paramNames;
    }

    public String[] getParamValues() {
        return this.paramValues;
    }

    public void setParamValues(String[] paramValues) {
        this.paramValues = paramValues;
    }

    public String getOptions() {
        return this.options;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public int getCurPageNum() {
        return this.curPageNum;
    }

    public void setCurPageNum(int curPage) {
        this.curPageNum = curPage;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getTotalPageNum() {
        return this.totalPageNum;
    }

    public void setTotalPageNum(int totalPageNum) {
        this.totalPageNum = totalPageNum;
    }

    public void setCurPageName(String curPageName) {
        this.curPageName = curPageName;
    }

    public String getCurPageName() {
        return this.curPageName;
    }
}

