/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.ui.tags.util;

import com.posdata.glue.ui.tags.util.PosCalendarIF;
import com.posdata.glue.ui.tags.util.PosCalendarUtil;
import java.util.StringTokenizer;

public class PosTagUtil
implements PosCalendarIF {
    private int CALS_MAX = 42;
    private int Country = 1;
    private String tz = "Asia/Seoul";
    private String BeforeYear = null;
    private String AfterYear = null;
    private String BeforeMonth = null;
    private String AfterMonth = null;
    private String[][] Buffer = new String[this.CALS_MAX][2];
    private String Year = null;
    private String Month = null;
    private String Day = null;
    private String Command = null;
    private String gFormat;

    public static String[] parseParameters(String temp, String seperator) {
        if (temp != null && temp.length() != 0) {
            StringTokenizer tokenizer = new StringTokenizer(temp, seperator);
            int numTokens = tokenizer.countTokens();
            String[] result = new String[numTokens];
            int i = 0;
            while (tokenizer.hasMoreElements()) {
                String token = tokenizer.nextToken().trim();
                if (token.equals("null")) {
                    token = "";
                }
                result[i] = token;
                ++i;
            }
            return result;
        }
        return null;
    }

    public String getYear() {
        return new String(this.Year);
    }

    public String getMonth() {
        return new String(this.Month);
    }

    public String getDay() {
        return new String(this.Day);
    }

    public String getBeforeYear() {
        return new String(this.BeforeYear);
    }

    public String getAfterYear() {
        return new String(this.AfterYear);
    }

    public String getBeforeMonth() {
        return new String(this.BeforeMonth);
    }

    public String getAfterMonth() {
        return new String(this.AfterMonth);
    }

    public String[][] getString() {
        return this.Buffer;
    }

    public void setCalendar(String pYear, String pMonth, String pDay, String pCmd, String gFormat) {
        this.Year = pYear;
        this.Month = pMonth;
        this.Day = pDay;
        this.Command = pCmd;
        this.gFormat = gFormat;
        this.Calendar();
    }

    private String getBeansInfo() {
        return new String("PosTagUtil");
    }

    private void Calendar() {
        int[] array = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        int year = 0;
        int month = 0;
        int day = 0;
        boolean twomonth = false;
        PosCalendarUtil jcals = null;
        if (this.Command.charAt(0) == 'N') {
            jcals = new PosCalendarUtil(this.Country, this.tz);
            year = Integer.parseInt(jcals.getYear());
            month = Integer.parseInt(jcals.getMonth());
            day = Integer.parseInt(jcals.getDay());
        } else {
            year = Integer.parseInt(this.Year);
            month = Integer.parseInt(this.Month);
            day = Integer.parseInt(this.Day);
            if (month < 1) {
                --year;
                month = 12;
            }
            if (month > 12) {
                ++year;
                month = 1;
            }
            jcals = new PosCalendarUtil(this.Country, this.tz, year, month, 1);
        }
        this.Year = jcals.getYear();
        this.Month = jcals.getMonth();
        this.Day = jcals.getDay();
        int firstday = jcals.checkFirstDay() - 1;
        if (month == 2) {
            array[1] = jcals.checkLastDay(2);
        }
        this.BeforeYear = "year=" + (year - 1) + "&month=" + month + "&day=" + day + "&cmd=YB";
        this.AfterYear = "year=" + (year + 1) + "&month=" + month + "&day=" + day + "&cmd=YA";
        this.BeforeMonth = "year=" + year + "&month=" + (month - 1) + "&day=" + day + "&cmd=MB";
        this.AfterMonth = "year=" + year + "&month=" + (month + 1) + "&day=" + day + "&cmd=MA" + "'";
        boolean arround = false;
        for (int ii = 0; ii < firstday; ++ii) {
            this.Buffer[ii][0] = "&nbsp;";
        }
        int jj = 1;
        String lsTmp = null;
        int ii = firstday;
        while (ii < this.CALS_MAX) {
            jcals.setDate(year, month, jj);
            lsTmp = jcals.getDateString();
            if (jj <= array[month - 1]) {
                this.Buffer[ii][0] = String.valueOf(jj);
                this.Buffer[ii][1] = lsTmp;
            } else {
                this.Buffer[ii][0] = "&nbsp;";
            }
            ++ii;
            ++jj;
        }
    }

    public static String[] convertStrToArray(String srcStr, int minLength) {
        return PosTagUtil.convertStrToArray(srcStr, minLength, "|");
    }

    public static String[] convertStrToArray(String srcStr, int minLength, String delimiter) {
        String[] returnArray = null;
        String[] tmpArray = PosTagUtil.parseParameters(srcStr, delimiter);
        if (tmpArray != null) {
            if (tmpArray.length < minLength) {
                returnArray = new String[minLength];
                System.arraycopy(tmpArray, 0, returnArray, 0, tmpArray.length);
            } else {
                returnArray = tmpArray;
            }
        } else {
            returnArray = new String[minLength];
        }
        return returnArray;
    }
}

