/*
 * Decompiled with CFR 0.152.
 */
package core.rfid.db;

import core.rfid.db.DBPool;
import core.util.LogUtil;
import core.util.PropertyUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;

public class DBPoolMgr {
    private static Hashtable pools = null;

    private DBPoolMgr() {
    }

    private static void initPool() {
        try {
            OracleConnectionPoolDataSource ocpds = null;
            DBPool pool = null;
            String poolNm = PropertyUtil.getProperty("DB_POOL_NAME");
            pools = new Hashtable();
            if (!pools.containsKey(poolNm)) {
                ocpds = new OracleConnectionPoolDataSource();
                ocpds.setURL(PropertyUtil.getProperty("DB_URL"));
                ocpds.setUser(PropertyUtil.getProperty("DB_USER"));
                ocpds.setPassword(PropertyUtil.getProperty("DB_PASS"));
                pool = new DBPool(poolNm, ocpds);
                pool.setInitialSize(3);
                pool.setMaxSize(20);
                pools.put(poolNm, pool);
                LogUtil.debug("DB POOL[" + poolNm + "] URL[" + PropertyUtil.getProperty("DB_URL") + "] OK");
            }
        }
        catch (Exception e) {
            LogUtil.error("connection pool initialization failure" + e);
        }
    }

    public static DBPool getPool(String name) throws SQLException {
        if (pools == null) {
            DBPoolMgr.initPool();
        }
        return (DBPool)pools.get(name);
    }

    public static void closePool(String name) throws SQLException {
        ((DBPool)pools.get(name)).getOcci().close();
        pools.remove(name);
    }

    public static Connection getNonPooledConnection(String user, String pwd, String url) throws SQLException, ClassNotFoundException {
        Class.forName("oracle.jdbc.driver.OracleDirver");
        return DriverManager.getConnection(url, user, pwd);
    }
}

