/*
 * Decompiled with CFR 0.152.
 */
package core.rfid.io;

import core.rfid.io.SocketProvider;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Iterator;

public class DefaultSocketProvider
implements SocketProvider {
    private static SocketProvider provider = null;
    private static Object object_lock = new Object();
    private Hashtable socketpool = new Hashtable();
    private int min_size;
    private int max_size;

    private DefaultSocketProvider(int min_size, int max_size) {
        this.min_size = min_size;
        this.max_size = max_size;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket getSocket(String ip, int port) {
        SocketAdapter socket = null;
        String key = String.valueOf(ip) + ':' + port;
        Hashtable hashtable = this.socketpool;
        synchronized (hashtable) {
            socket = (SocketAdapter)this.socketpool.get(key);
            if (socket == null) {
                if (this.socketpool.size() < this.max_size) {
                    socket = new SocketAdapter();
                    this.socketpool.put(key, socket);
                } else {
                    Iterator itr = this.socketpool.keySet().iterator();
                    while (itr.hasNext()) {
                        key = itr.next();
                        socket = (SocketAdapter)this.socketpool.get(key);
                        if (!socket.isFree()) continue;
                        this.socketpool.remove(key);
                        if (socket.isConnected()) {
                            socket.destroy();
                            socket = new SocketAdapter();
                        }
                        this.socketpool.put(String.valueOf(ip) + ':' + port, socket);
                        break;
                    }
                }
            }
            if (!socket.isFree()) {
                try {
                    this.socketpool.wait();
                    return this.getSocket(ip, port);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                this.socketpool.remove(key);
                this.socketpool.put(key, socket);
                socket.setBusy();
            }
        }
        try {
            socket.connect(new InetSocketAddress(ip, port), 8000);
            return socket;
        }
        catch (UnknownHostException e) {
            System.err.println(e);
        }
        catch (SocketTimeoutException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return null;
    }

    public void start() {
        int i = 0;
        while (i < this.min_size) {
            this.socketpool.put(String.valueOf(i), new SocketAdapter());
            System.out.print('.');
            ++i;
        }
    }

    public void shutdown() {
        Iterator itr = this.socketpool.keySet().iterator();
        while (itr.hasNext()) {
            ((SocketAdapter)this.socketpool.get(itr.next())).destroy();
        }
        this.socketpool.clear();
    }

    public static SocketProvider newInstance() {
        return DefaultSocketProvider.newInstance(1, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SocketProvider newInstance(int min_size, int max_size) {
        if (provider == null) {
            Object object = object_lock;
            synchronized (object) {
                if (provider == null) {
                    provider = new DefaultSocketProvider(min_size, max_size);
                }
            }
        }
        return provider;
    }

    private class SocketAdapter
    extends Socket {
        private boolean status = true;

        private SocketAdapter() {
        }

        public boolean isFree() {
            return this.status;
        }

        public void setBusy() {
            this.status = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.status = true;
            try {
                super.setSoTimeout(0);
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            Hashtable hashtable = DefaultSocketProvider.this.socketpool;
            synchronized (hashtable) {
                DefaultSocketProvider.this.socketpool.notify();
            }
        }

        public void destroy() {
            try {
                super.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

