/*
 * Decompiled with CFR 0.152.
 */
package core.util;

import core.util.LogUtil;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ByteUtil {
    public static final void print(byte[] b) {
        LogUtil.debug("---------ByteUtil----------");
        int i = 0;
        while (i < b.length) {
            LogUtil.debug("byte[" + i + "] 10\u67f3\u8350:" + b[i] + " -> 16\u67f3\u8350:" + Integer.toHexString(b[i]) + " -> " + (char)b[i]);
            ++i;
        }
    }

    public static final String toHexaString(byte[] b) {
        String ret = "";
        int i = 0;
        while (i < b.length) {
            ret = String.valueOf(ret) + Integer.toHexString(b[i]) + " ";
            ++i;
        }
        return ret;
    }

    public static final byte[] swap(int su, int len) {
        byte[] dest = new byte[len];
        byte[] tmpByte = null;
        tmpByte = len >= 8 ? ByteUtil.long2byte(su) : (len >= 4 ? ByteUtil.int2byte(su) : (len >= 2 ? ByteUtil.short2byte((short)su) : new byte[]{(byte)su}));
        int ch = len - tmpByte.length;
        System.arraycopy(tmpByte, 0, dest, ch > 0 ? ch : 0, tmpByte.length);
        return dest;
    }

    public static final int swap(byte[] src) {
        int len = src.length - 1;
        int s = 8 * len;
        int su = (src[0] & 0xFF) << s;
        int i = 1;
        while (i < len) {
            int g = 8 * (len - i);
            su |= (src[i] & 0xFF) << g;
            ++i;
        }
        return su |= src[src.length - 1] & 0xFF;
    }

    public static final byte[] short2byte(short s) {
        byte[] dest = new byte[2];
        dest[1] = (byte)(s & 0xFF);
        dest[0] = (byte)(s >>> 8 & 0xFF);
        return dest;
    }

    public static final byte[] int2byte(int i) {
        byte[] dest = new byte[4];
        dest[3] = (byte)(i & 0xFF);
        dest[2] = (byte)(i >>> 8 & 0xFF);
        dest[1] = (byte)(i >>> 16 & 0xFF);
        dest[0] = (byte)(i >>> 24 & 0xFF);
        return dest;
    }

    public static final byte[] long2byte(long l) {
        byte[] dest = new byte[8];
        dest[7] = (byte)(l & 0xFFL);
        dest[6] = (byte)(l >>> 8 & 0xFFL);
        dest[5] = (byte)(l >>> 16 & 0xFFL);
        dest[4] = (byte)(l >>> 24 & 0xFFL);
        dest[3] = (byte)(l >>> 32 & 0xFFL);
        dest[2] = (byte)(l >>> 40 & 0xFFL);
        dest[1] = (byte)(l >>> 48 & 0xFFL);
        dest[0] = (byte)(l >>> 56 & 0xFFL);
        return dest;
    }

    public static final byte[] float2byte(float f) {
        byte[] dest = new byte[4];
        return ByteUtil.setfloat(dest, 0, f);
    }

    public static final byte[] double2byte(double d) {
        byte[] dest = new byte[8];
        return ByteUtil.setdouble(dest, 0, d);
    }

    public static final short getshort(byte[] src, int offset) {
        return (short)((src[offset] & 0xFF) << 8 | src[offset + 1] & 0xFF);
    }

    public static final int getint(byte[] src, int offset) {
        return (src[offset] & 0xFF) << 24 | (src[offset + 1] & 0xFF) << 16 | (src[offset + 2] & 0xFF) << 8 | src[offset + 3] & 0xFF;
    }

    public static final long getlong(byte[] src, int offset) {
        return (long)ByteUtil.getint(src, offset) << 32 | (long)ByteUtil.getint(src, offset + 4) & 0xFFFFFFFFL;
    }

    public static final float getfloat(byte[] src, int offset) {
        return Float.intBitsToFloat(ByteUtil.getint(src, offset));
    }

    public static final double getdouble(byte[] src, int offset) {
        return Double.longBitsToDouble(ByteUtil.getlong(src, offset));
    }

    public static final byte getbyte(byte[] src, int offset) {
        return src[offset];
    }

    public static final byte[] getbytes(byte[] src, int offset, int length) {
        byte[] dest = new byte[length];
        System.arraycopy(src, offset, dest, 0, length);
        return dest;
    }

    public static final byte[] setbyte(byte[] dest, int offset, byte b) {
        dest[offset] = b;
        return dest;
    }

    public static final byte[] setbytes(byte[] dest, int offset, byte[] src) {
        System.arraycopy(src, 0, dest, offset, src.length);
        return dest;
    }

    public static final byte[] setbytes(byte[] dest, int offset, byte[] src, int len) {
        System.arraycopy(src, 0, dest, offset, len);
        return dest;
    }

    public static final byte[] setshort(byte[] dest, int offset, short s) {
        dest[offset] = (byte)(s >>> 8 & 0xFF);
        dest[offset + 1] = (byte)(s & 0xFF);
        return dest;
    }

    public static final byte[] setint(byte[] dest, int offset, int i) {
        dest[offset] = (byte)(i >>> 24 & 0xFF);
        dest[offset + 1] = (byte)(i >>> 16 & 0xFF);
        dest[offset + 2] = (byte)(i >>> 8 & 0xFF);
        dest[offset + 3] = (byte)(i & 0xFF);
        return dest;
    }

    public static final byte[] setlong(byte[] dest, int offset, long l) {
        ByteUtil.setint(dest, offset, (int)(l >>> 32));
        ByteUtil.setint(dest, offset + 4, (int)(l & 0xFFFFFFFFL));
        return dest;
    }

    public static final byte[] setfloat(byte[] dest, int offset, float f) {
        return ByteUtil.setint(dest, offset, Float.floatToIntBits(f));
    }

    public static final byte[] setdouble(byte[] dest, int offset, double d) {
        return ByteUtil.setlong(dest, offset, Double.doubleToLongBits(d));
    }

    public static final byte[] string2byte(String s) {
        return ByteUtil.string2byte(s, 65535);
    }

    public static final byte[] string2byte(String s, int max) {
        if (s == null) {
            return ByteUtil.short2byte((short)0);
        }
        byte[] strBuf = s.getBytes();
        int len = strBuf.length;
        if (len == 0) {
            return ByteUtil.short2byte((short)0);
        }
        if (len > max) {
            len = max;
        } else if (len > 65535) {
            len = 65535;
        }
        byte[] lenBuf = ByteUtil.short2byte((short)len);
        byte[] rtnBuf = new byte[2 + len];
        System.arraycopy(lenBuf, 0, rtnBuf, 0, 2);
        System.arraycopy(strBuf, 0, rtnBuf, 2, len);
        return rtnBuf;
    }

    public static final byte hexaStrToByte(String hexa) {
        byte[] hexaByte = new byte[]{Byte.parseByte(hexa.substring(0, 1), 16), Byte.parseByte(hexa.substring(1, 2), 16)};
        byte retByte = (byte)((hexaByte[0] & 0xF) << 4 | hexaByte[1] & 0xF);
        return retByte;
    }

    public static final byte[] hexaStrToBytes(String hexaStr) {
        byte[] dest = new byte[hexaStr.length() / 2];
        int index = 0;
        int i = 0;
        while (i < hexaStr.length()) {
            dest[index] = ByteUtil.hexaStrToByte(hexaStr.substring(i, i + 2));
            ++index;
            i += 2;
        }
        return dest;
    }

    public static final boolean isEquals(byte[] b, String s) {
        if (b == null || s == null) {
            return false;
        }
        int slen = s.length();
        if (b.length != slen) {
            return false;
        }
        int i = slen;
        while (i-- > 0) {
            if (b[i] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isEquals(byte[] a, byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = a.length;
        while (i-- > 0) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static byte[] byteCopy(byte[] buf, int ibuf, byte[] data, int idata, int len) {
        System.arraycopy(buf, ibuf, data, idata, data.length);
        return data;
    }

    public static byte[] byteCopy(byte[] buf, int ibuf, byte[] data) {
        System.arraycopy(buf, ibuf, data, 0, data.length);
        return data;
    }

    public static String byteToString(byte[] bytes) {
        return new String(bytes, 0, bytes.length);
    }

    public static byte[] stringToBytes(String str) {
        byte[] retByte = null;
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteOut);
        try {
            dataOut.writeUTF(str);
        }
        catch (IOException ie) {
            LogUtil.error(ie.toString());
        }
        try {
            retByte = byteOut.toByteArray();
        }
        catch (Exception ex) {
            LogUtil.error(ex.toString());
        }
        return retByte;
    }
}

