/*
 * Decompiled with CFR 0.152.
 */
package core.util;

import core.util.LogUtil;
import core.util.PosClassLoaderUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class PropertyUtil {
    static final String PROP_FILE = "conf/config.properties";
    static Properties properties = null;
    public static PropertyUtil prop = new PropertyUtil();

    private PropertyUtil() {
        this.init();
        this.load();
    }

    private void init() {
        if (properties == null) {
            properties = new Properties();
        }
    }

    private void load() {
        try {
            InputStream is = PosClassLoaderUtil.getExtendResource(PROP_FILE).openStream();
            properties.load(is);
            is.close();
        }
        catch (IOException e) {
            LogUtil.error("PropertiesUtil.load() : " + e);
        }
    }

    public static void store() {
        try {
            properties.store(new FileOutputStream(PROP_FILE), null);
        }
        catch (IOException e) {
            LogUtil.error("PropertiesUtil.store() : " + e);
        }
    }

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static void setProperty(String key, String value) {
        properties.setProperty(key, value);
    }

    public static ArrayList getKeyList() {
        ArrayList arrayList = new ArrayList();
        Enumeration<?> names = properties.propertyNames();
        while (names.hasMoreElements()) {
            arrayList.add(names.nextElement());
        }
        return arrayList;
    }
}

