/*
 * Decompiled with CFR 0.152.
 */
package core.util;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class UtilDate {
    public static String getCurrentDate() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        return dateFormat.format(date);
    }

    public static String getCurrentTime() {
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HHmmss");
        return dateFormat.format(date);
    }

    public static boolean dateValid(String src) {
        int year = 0;
        int month = 0;
        int day = 0;
        if (src.length() != 8) {
            return false;
        }
        try {
            year = Integer.parseInt(src.substring(0, 4));
            month = Integer.parseInt(src.substring(4, 6));
            day = Integer.parseInt(src.substring(6));
        }
        catch (Exception e) {
            return false;
        }
        boolean flag = false;
        if (year % 4 == 0) {
            flag = true;
            if (year % 100 == 0) {
                flag = false;
                if (year % 400 == 0) {
                    flag = true;
                }
            }
        }
        int[] dayArray = new int[]{31, flag ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (month < 1 || month > 12) {
            return false;
        }
        return day >= 1 && day <= dayArray[month - 1];
    }

    public static String getCalendarDate(Calendar calendar) {
        if (calendar == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        Date date = calendar.getTime();
        return dateFormat.format(date);
    }

    public static Calendar getDateCalendar(String date) {
        Calendar calendar = Calendar.getInstance(Locale.KOREA);
        calendar.set(Integer.parseInt(date.substring(0, 4)), Integer.parseInt(date.substring(4, 6)) - 1, Integer.parseInt(date.substring(6)));
        return calendar;
    }

    public static int getDayOfWeek(Date date) {
        String[] weekdays = new DateFormatSymbols().getShortWeekdays();
        String weekday = new SimpleDateFormat("E").format(date);
        int i = 1;
        while (i <= weekdays.length) {
            if (weekday.equals(weekdays[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int BetweenDateCnt(String sFDate, String sTDate) {
        int iLoopCnt = 1;
        int iFYear = Integer.parseInt(sFDate.substring(0, 4));
        int iFMonth = Integer.parseInt(sFDate.substring(4, 6));
        int iFDay = Integer.parseInt(sFDate.substring(6, 8));
        int iTYear = Integer.parseInt(sTDate.substring(0, 4));
        int iTMonth = Integer.parseInt(sTDate.substring(4, 6));
        int iTDay = Integer.parseInt(sTDate.substring(6, 8));
        double dFDate = Double.parseDouble(sFDate.substring(0, 8));
        double dTDate = Double.parseDouble(sTDate.substring(0, 8));
        String sYear = null;
        String sMonth = null;
        String sDay = null;
        String sTmpDate = null;
        if (dFDate == dTDate) {
            return 1;
        }
        if (dFDate < dTDate) {
            iLoopCnt = 0;
            while (dFDate <= dTDate) {
                sYear = Integer.toString(iFYear);
                sMonth = Integer.toString(iFMonth);
                sDay = Integer.toString(++iFDay);
                if (sMonth.length() == 1) {
                    sMonth = "0" + Integer.toString(iFMonth);
                }
                if (sDay.length() == 1) {
                    sDay = "0" + Integer.toString(iFDay);
                }
                if (!UtilDate.dateValid(sTmpDate = String.valueOf(sYear) + sMonth + sDay)) {
                    iFDay = 1;
                    if (++iFMonth > 12) {
                        iFMonth = 1;
                        ++iFYear;
                    }
                }
                sYear = Integer.toString(iFYear);
                sMonth = Integer.toString(iFMonth);
                sDay = Integer.toString(iFDay);
                if (sMonth.length() == 1) {
                    sMonth = "0" + Integer.toString(iFMonth);
                }
                if (sDay.length() == 1) {
                    sDay = "0" + Integer.toString(iFDay);
                }
                sTmpDate = String.valueOf(sYear) + sMonth + sDay;
                dFDate = Double.parseDouble(sTmpDate);
                ++iLoopCnt;
            }
        } else {
            iLoopCnt = 0;
            while (dTDate <= dFDate) {
                sYear = Integer.toString(iTYear);
                sMonth = Integer.toString(iTMonth);
                sDay = Integer.toString(++iTDay);
                if (sMonth.length() == 1) {
                    sMonth = "0" + Integer.toString(iTMonth);
                }
                if (sDay.length() == 1) {
                    sDay = "0" + Integer.toString(iTDay);
                }
                if (!UtilDate.dateValid(sTmpDate = String.valueOf(sYear) + sMonth + sDay)) {
                    iTDay = 1;
                    if (++iTMonth > 12) {
                        iTMonth = 1;
                        ++iTYear;
                    }
                }
                sYear = Integer.toString(iTYear);
                sMonth = Integer.toString(iTMonth);
                sDay = Integer.toString(iTDay);
                if (sMonth.length() == 1) {
                    sMonth = "0" + Integer.toString(iTMonth);
                }
                if (sDay.length() == 1) {
                    sDay = "0" + Integer.toString(iTDay);
                }
                sTmpDate = String.valueOf(sYear) + sMonth + sDay;
                dTDate = Double.parseDouble(sTmpDate);
                ++iLoopCnt;
            }
            iLoopCnt *= -1;
        }
        return iLoopCnt;
    }

    public static int BetweenMonthCnt(String sFDate, String sTDate) {
        int iDteCnt = 1;
        int iFYear = Integer.parseInt(sFDate.substring(0, 4));
        int iFMonth = Integer.parseInt(sFDate.substring(4, 6));
        int iTYear = Integer.parseInt(sTDate.substring(0, 4));
        int iTMonth = Integer.parseInt(sTDate.substring(4, 6));
        double dFDate = Double.parseDouble(sFDate.substring(0, 6));
        double dTDate = Double.parseDouble(sTDate.substring(0, 6));
        String sYear = null;
        String sMonth = null;
        String sTmpMonth = null;
        if (dFDate == dTDate) {
            return 1;
        }
        if (dFDate < dTDate) {
            iDteCnt = 0;
            while (dFDate <= dTDate) {
                if (++iFMonth > 12) {
                    iFMonth = 1;
                    ++iFYear;
                }
                sYear = Integer.toString(iFYear);
                sMonth = Integer.toString(iFMonth);
                if (sMonth.length() == 1) {
                    sMonth = "0" + Integer.toString(iFMonth);
                }
                sTmpMonth = String.valueOf(sYear) + sMonth;
                dFDate = Double.parseDouble(sTmpMonth);
                ++iDteCnt;
            }
        } else {
            iDteCnt = 0;
            while (dTDate <= dFDate) {
                if (++iTMonth > 12) {
                    iTMonth = 1;
                    ++iTYear;
                }
                sYear = Integer.toString(iTYear);
                sMonth = Integer.toString(iTMonth);
                if (sMonth.length() == 1) {
                    sMonth = "0" + Integer.toString(iTMonth);
                }
                sTmpMonth = String.valueOf(sYear) + sMonth;
                dTDate = Double.parseDouble(sTmpMonth);
                ++iDteCnt;
            }
            iDteCnt *= -1;
        }
        return iDteCnt;
    }

    public static int BetweenYearCnt(String sFDate, String sTDate) {
        int iDteCnt = 1;
        int iFYear = Integer.parseInt(sFDate.substring(0, 4));
        int iTYear = Integer.parseInt(sTDate.substring(0, 4));
        double dFDate = Double.parseDouble(sFDate.substring(0, 4));
        double dTDate = Double.parseDouble(sTDate.substring(0, 4));
        String sYear = null;
        if (dFDate == dTDate) {
            return 1;
        }
        if (dFDate < dTDate) {
            iDteCnt = 0;
            while (dFDate <= dTDate) {
                sYear = Integer.toString(++iFYear);
                dFDate = Double.parseDouble(sYear);
                ++iDteCnt;
            }
        } else {
            iDteCnt = 0;
            while (dTDate <= dFDate) {
                sYear = Integer.toString(++iTYear);
                dTDate = Double.parseDouble(sYear);
                ++iDteCnt;
            }
            iDteCnt *= -1;
        }
        return iDteCnt;
    }

    public static String AddDateFunc(String sDate, int iDteCnt) {
        int iLoopCnt = 1;
        int iYear = Integer.parseInt(sDate.substring(0, 4));
        int iMonth = Integer.parseInt(sDate.substring(4, 6));
        int iDay = Integer.parseInt(sDate.substring(6, 8));
        String sYear = null;
        String sMonth = null;
        String sDay = null;
        String sTmpDate = null;
        if (iDteCnt == 0) {
            return sDate;
        }
        if (iDteCnt > 0) {
            iLoopCnt = 1;
            while (iLoopCnt <= iDteCnt) {
                sYear = Integer.toString(iYear);
                sMonth = Integer.toString(iMonth);
                sDay = Integer.toString(++iDay);
                if (sMonth.length() == 1) {
                    sMonth = "0" + Integer.toString(iMonth);
                }
                if (sDay.length() == 1) {
                    sDay = "0" + Integer.toString(iDay);
                }
                if (!UtilDate.dateValid(sTmpDate = String.valueOf(sYear) + sMonth + sDay)) {
                    iDay = 1;
                    if (++iMonth > 12) {
                        iMonth = 1;
                        ++iYear;
                    }
                }
                sYear = Integer.toString(iYear);
                sMonth = Integer.toString(iMonth);
                sDay = Integer.toString(iDay);
                if (sMonth.length() == 1) {
                    sMonth = "0" + Integer.toString(iMonth);
                }
                if (sDay.length() == 1) {
                    sDay = "0" + Integer.toString(iDay);
                }
                sTmpDate = String.valueOf(sYear) + sMonth + sDay;
                ++iLoopCnt;
            }
        } else {
            iLoopCnt = 1;
            iDteCnt *= -1;
            while (iLoopCnt <= iDteCnt) {
                sYear = Integer.toString(iYear);
                sMonth = Integer.toString(iMonth);
                sDay = Integer.toString(--iDay);
                if (sMonth.length() == 1) {
                    sMonth = "0" + Integer.toString(iMonth);
                }
                if (sDay.length() == 1) {
                    sDay = "0" + Integer.toString(iDay);
                }
                if (iDay == 0) {
                    if (--iMonth == 0) {
                        iMonth = 12;
                        --iYear;
                    }
                    int il = 27;
                    while (il <= 32) {
                        sYear = Integer.toString(iYear);
                        sMonth = Integer.toString(iMonth);
                        sDay = Integer.toString(il);
                        if (sMonth.length() == 1) {
                            sMonth = "0" + Integer.toString(iMonth);
                        }
                        if (sDay.length() == 1) {
                            sDay = "0" + Integer.toString(il);
                        }
                        if (!UtilDate.dateValid(sTmpDate = String.valueOf(sYear) + sMonth + sDay)) {
                            iDay = il - 1;
                            sDay = Integer.toString(iDay);
                            if (sDay.length() != 1) break;
                            sDay = "0" + Integer.toString(il);
                            break;
                        }
                        ++il;
                    }
                }
                sTmpDate = String.valueOf(sYear) + sMonth + sDay;
                ++iLoopCnt;
            }
        }
        return sTmpDate;
    }

    public static String AddMonthFunc(String sMonth, int iDteCnt) {
        int iLoopCnt = 1;
        int iYear = Integer.parseInt(sMonth.substring(0, 4));
        int iMonth = Integer.parseInt(sMonth.substring(4, 6));
        String sYear = null;
        String sTmpMonth = null;
        if (iDteCnt == 0) {
            return sMonth.substring(0, 6);
        }
        if (iDteCnt > 0) {
            iLoopCnt = 1;
            while (iLoopCnt <= iDteCnt) {
                if (++iMonth > 12) {
                    iMonth = 1;
                    ++iYear;
                }
                sYear = Integer.toString(iYear);
                sMonth = Integer.toString(iMonth);
                if (sMonth.length() == 1) {
                    sMonth = "0" + Integer.toString(iMonth);
                }
                sTmpMonth = String.valueOf(sYear) + sMonth;
                ++iLoopCnt;
            }
        } else {
            iLoopCnt = 1;
            iDteCnt *= -1;
            while (iLoopCnt <= iDteCnt) {
                if (--iMonth == 0) {
                    iMonth = 12;
                    --iYear;
                }
                sYear = Integer.toString(iYear);
                sMonth = Integer.toString(iMonth);
                if (sMonth.length() == 1) {
                    sMonth = "0" + Integer.toString(iMonth);
                }
                sTmpMonth = String.valueOf(sYear) + sMonth;
                ++iLoopCnt;
            }
        }
        return sTmpMonth;
    }

    public static String AddYearFunc(String sYear, int iDteCnt) {
        int iLoopCnt = 1;
        int iYear = Integer.parseInt(sYear.substring(0, 4));
        if (iDteCnt == 0) {
            return sYear.substring(0, 4);
        }
        if (iDteCnt > 0) {
            iLoopCnt = 1;
            while (iLoopCnt <= iDteCnt) {
                sYear = Integer.toString(++iYear);
                ++iLoopCnt;
            }
        } else {
            iLoopCnt = 1;
            iDteCnt *= -1;
            while (iLoopCnt <= iDteCnt) {
                sYear = Integer.toString(--iYear);
                ++iLoopCnt;
            }
        }
        return sYear;
    }

    public static String Addyymmdd(String sYear, int iDteCnt) {
        int iLoopCnt = 1;
        int iYear = Integer.parseInt(sYear.substring(0, 4));
        String sMonth = sYear.substring(4, 6);
        String sDay = sYear.substring(6, 8);
        String sTmpDate = null;
        if (iDteCnt == 0) {
            return sYear.substring(0, 4);
        }
        if (iDteCnt > 0) {
            iLoopCnt = 1;
            while (iLoopCnt <= iDteCnt) {
                sYear = Integer.toString(++iYear);
                ++iLoopCnt;
            }
        } else {
            iLoopCnt = 1;
            iDteCnt *= -1;
            while (iLoopCnt <= iDteCnt) {
                sYear = Integer.toString(--iYear);
                ++iLoopCnt;
            }
            sTmpDate = String.valueOf(sYear) + sMonth + sDay;
        }
        return sTmpDate;
    }

    public static String FromDateToDate(int day) {
        Calendar cal = null;
        cal = UtilDate.getDateCalendar(UtilDate.getCurrentDate());
        cal.add(5, day);
        return UtilDate.getCalendarDate(cal);
    }
}

