/*
 * Decompiled with CFR 0.152.
 */
package core.util;

import java.io.Reader;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class UtilFunc {
    public static boolean bError = false;

    public static String RPAD(String str, int len, char pad) {
        String result = str;
        int templen = len - result.getBytes().length;
        int i = 0;
        while (i < templen) {
            result = String.valueOf(result) + pad;
            ++i;
        }
        return result;
    }

    public static String LPAD(String str, int len, char pad) {
        String result = str;
        int templen = len - result.getBytes().length;
        int i = 0;
        while (i < templen) {
            result = String.valueOf(pad) + result;
            ++i;
        }
        return result;
    }

    public static String dformat(String str) {
        DecimalFormat df = new DecimalFormat("#,###,###,##0");
        String retstr = null;
        try {
            retstr = df.format(Integer.parseInt(str));
            return retstr;
        }
        catch (NumberFormatException nfe) {
            try {
                retstr = df.format(Float.valueOf(str).floatValue());
                return retstr;
            }
            catch (Exception ee) {
                return "0";
            }
        }
        catch (Exception e) {
            return "0";
        }
    }

    public static String pdFormat(String pattern, double value) {
        DecimalFormat myFormatter = new DecimalFormat(pattern);
        String output = myFormatter.format(value);
        return output;
    }

    public static String roundFixUp(double input, int fraction, boolean isGroupingUsed) {
        try {
            NumberFormat format = NumberFormat.getInstance();
            format.setMaximumFractionDigits(fraction);
            format.setMinimumFractionDigits(fraction);
            format.setGroupingUsed(isGroupingUsed);
            return format.format(input);
        }
        catch (Exception e) {
            return new Double(input).toString();
        }
    }

    public static String encode(String str) {
        if (str == null) {
            return null;
        }
        String result = null;
        try {
            byte[] inputBytes = str.getBytes("UTF8");
            BASE64Encoder encoder = new BASE64Encoder();
            result = encoder.encode(inputBytes);
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    public static String decode(String str) {
        if (str == null) {
            return null;
        }
        String result = null;
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            byte[] inputBytes = decoder.decodeBuffer(str);
            result = new String(inputBytes, "UTF8");
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    public static String make(String s) {
        return "'" + s + "'";
    }

    public static String makeQueryString(String source) {
        if (source != null) {
            int len = source.length();
            StringBuffer dest = new StringBuffer();
            int i = 0;
            while (i <= len - 1) {
                if (source.charAt(i) == '\'') {
                    dest.append("''");
                } else {
                    dest.append(source.charAt(i));
                }
                ++i;
            }
            return dest.toString();
        }
        return "";
    }

    public static String toNBSP(String str) {
        int len = str.length();
        StringBuffer dest = new StringBuffer(len);
        int i = 0;
        while (i <= len - 1) {
            if (str.charAt(i) == ' ') {
                dest.append("&nbsp;");
            } else {
                dest.append(str.charAt(i));
            }
            ++i;
        }
        return dest.toString();
    }

    public static String toBR(String str) {
        int len = str.length();
        StringBuffer dest = new StringBuffer(len);
        int i = 0;
        while (i <= len - 1) {
            if (str.charAt(i) == '\n') {
                dest.append("<BR>");
            } else {
                dest.append(str.charAt(i));
            }
            ++i;
        }
        return dest.toString();
    }

    public static String getHtmlString(String source) {
        if (source != null) {
            int len = source.length();
            StringBuffer dest = new StringBuffer(len);
            int i = 0;
            while (i <= len - 1) {
                if (source.charAt(i) == ' ') {
                    dest.append("&nbsp;");
                } else if (source.charAt(i) == '<') {
                    dest.append("&lt;");
                } else if (source.charAt(i) == '>') {
                    dest.append("&gt;");
                } else if (source.charAt(i) == '\'') {
                    dest.append("^");
                } else if (source.charAt(i) == '\n') {
                    dest.append("<br>");
                } else {
                    dest.append(source.charAt(i));
                }
                ++i;
            }
            return dest.toString();
        }
        return "";
    }

    public static String setQuit(String source) {
        if (source != null) {
            int len = source.length();
            StringBuffer dest = new StringBuffer(len);
            int i = 0;
            while (i <= len - 1) {
                if (source.charAt(i) == '\'') {
                    dest.append("^");
                } else if (source.charAt(i) == '\n') {
                    dest.append("<br>");
                } else {
                    dest.append(source.charAt(i));
                }
                ++i;
            }
            return dest.toString();
        }
        return "";
    }

    public static String toMg(String source) {
        source = UtilFunc.encode(source);
        source = source.replaceAll("\n", "");
        return source;
    }

    public static String getExtract(String source) {
        source = source.replaceAll("<br>", "\n");
        source = UtilFunc.extractHtmlString(source);
        return source;
    }

    public static String extractHtmlString(String source) {
        if (source != null) {
            int len = source.length();
            StringBuffer dest = new StringBuffer(len);
            int i = 0;
            while (i <= len - 1) {
                if (source.charAt(i) == '^') {
                    dest.append('\'');
                } else {
                    dest.append(source.charAt(i));
                }
                ++i;
            }
            return dest.toString();
        }
        return "*^^*";
    }

    public static String wonPointTrunc(String src, int iPoint) {
        String resultValue = "";
        String sTmpStr = "";
        int iLoop = 0;
        int i = 0;
        while (i < src.length()) {
            char temp = src.charAt(i);
            if (temp == '.') {
                if (iPoint == 0) break;
                resultValue = String.valueOf(resultValue) + temp;
                ++iLoop;
            } else {
                if (iLoop != 0) {
                    ++iLoop;
                }
                if (iLoop > iPoint + 1) break;
                resultValue = String.valueOf(resultValue) + temp;
            }
            ++i;
        }
        if (resultValue.length() == 0) {
            resultValue = "0";
        }
        if (iLoop < iPoint) {
            i = 0;
            while (i < iPoint - iLoop) {
                sTmpStr = String.valueOf(sTmpStr) + sTmpStr + "0";
                ++i;
            }
        }
        resultValue = String.valueOf(resultValue) + sTmpStr;
        return resultValue;
    }

    public static String NullToSpace(String sConvertVal, int numStrFg) {
        if (numStrFg == 0) {
            if (sConvertVal == null) {
                sConvertVal = "";
            }
            if (sConvertVal.equals("")) {
                sConvertVal = "";
            }
        } else {
            if (sConvertVal == null) {
                sConvertVal = "0";
            }
            if (sConvertVal.equals("")) {
                sConvertVal = "0";
            }
        }
        return sConvertVal;
    }

    public static String IfSpace(String sConvertVal, String RetString) {
        if (sConvertVal.equals("")) {
            return RetString;
        }
        return sConvertVal;
    }

    public static String[] GetTokenElement(String rsStr) {
        StringTokenizer stok = new StringTokenizer(rsStr, "^");
        String[] sTokens = new String[stok.countTokens()];
        int i = 0;
        while (stok.hasMoreElements()) {
            sTokens[i] = ((String)stok.nextElement()).trim();
            ++i;
        }
        return sTokens;
    }

    public static String MergeElement(String sOrgCd, String[] sArryString, int iColPoint) {
        String sRetStr = "";
        int i = 0;
        while (i < sArryString.length) {
            sRetStr = sArryString[i].substring(0, iColPoint).equals(sOrgCd) ? String.valueOf(sRetStr) + "\n             <option value=" + sArryString[i].substring(0, iColPoint) + " selected>" + sArryString[i].substring(iColPoint, sArryString[i].length()) + "</option>" : String.valueOf(sRetStr) + "\n             <option value=" + sArryString[i].substring(0, iColPoint) + "         >" + sArryString[i].substring(iColPoint, sArryString[i].length()) + "</option>";
            ++i;
        }
        return sRetStr;
    }

    public static String StrSet(String sStrValue) {
        return "'" + sStrValue + "'";
    }

    public static String MaskString(String src, int place) {
        String sStr1 = src.substring(0, place);
        String sStr2 = src.substring(place);
        String returnString = String.valueOf(sStr1) + "-" + sStr2;
        return returnString;
    }

    public static String makeFormString(String source) {
        if (source != null) {
            int len = source.length();
            StringBuffer dest = new StringBuffer();
            int i = 0;
            while (i <= len - 1) {
                if (source.charAt(i) == '\'') {
                    dest.append("&#039");
                } else {
                    dest.append(source.charAt(i));
                }
                ++i;
            }
            return dest.toString();
        }
        return "";
    }

    public static String DateFormating(String src) {
        return String.valueOf(src.substring(0, 4)) + "-" + src.substring(4, 6) + "-" + src.substring(6, 8) + " " + src.substring(8, 10) + ":" + src.substring(10, 12) + ":" + src.substring(12);
    }

    public static String DateFormatingYYMMDD(String src) {
        return String.valueOf(src.substring(0, 4)) + "/" + src.substring(4, 6) + "/" + src.substring(6, 8);
    }

    public static String DateFormatingYYMMDD2(String src) {
        return String.valueOf(src.substring(0, 4)) + "-" + src.substring(4, 6) + "-" + src.substring(6, 8);
    }

    public static String Replace(String src, String find, String repl) {
        if (src == null || src.length() < 1 || find == null || find.length() < 1 || repl == null || repl.length() < 1) {
            return null;
        }
        if (src.length() == 1) {
            return src;
        }
        String ret = new String();
        int findPos = 0;
        int endPos = 0;
        int beginPos = 0;
        while ((beginPos = src.substring(findPos, src.length()).indexOf(find)) != -1) {
            ret = String.valueOf(ret) + src.substring(endPos, findPos += beginPos) + repl;
            endPos = findPos += find.length();
        }
        if (endPos < src.length() - 1) {
            ret = String.valueOf(ret) + src.substring(endPos, src.length());
        }
        return ret;
    }

    public static String getCheck_String(String s) {
        if ("null".equals(s) || s == null) {
            return "";
        }
        return s;
    }

    public static String ltos(long l) {
        return new Long(l).toString();
    }

    public static long stol(String s) {
        long l = 0L;
        NumberFormat numberformat = NumberFormat.getNumberInstance(Locale.KOREAN);
        if (s != null && !s.equals("")) {
            try {
                l = numberformat.parse(s).longValue();
                bError = false;
            }
            catch (ParseException parseexception) {
                bError = true;
            }
        }
        return l;
    }

    public static String deleteStr(String s, String s1) {
        if (s == null || s.equals("")) {
            return "";
        }
        String s2 = "";
        StringTokenizer stringtokenizer = new StringTokenizer(s, s1);
        while (stringtokenizer.hasMoreTokens()) {
            s2 = String.valueOf(s2) + stringtokenizer.nextToken();
        }
        return s2;
    }

    public static String getCurrentDate() {
        return new SimpleDateFormat("yyyyMMdd").format(new Date());
    }

    public static String getCurrentHour() {
        return new SimpleDateFormat("HH").format(new Date());
    }

    public static String getCurrentMinite() {
        return new SimpleDateFormat("mm").format(new Date());
    }

    public static String substring(String str, int start, int end) {
        return str.substring(start, end);
    }

    public static String getsubstring(String str, int len) {
        String tmpString = "";
        try {
            tmpString = str == null || str.equals("") ? "" : (str.length() < len ? str : (str.length() == len ? str.substring(0, len) : String.valueOf(str.substring(0, len)) + "..."));
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        return tmpString;
    }

    public static String getClob(ResultSet rset, String value) {
        String content = "";
        try {
            int byteRead;
            char[] buffer = new char[1024];
            StringBuffer output = new StringBuffer();
            Reader input = rset.getCharacterStream(value);
            while ((byteRead = input.read(buffer, 0, 1024)) != -1) {
                output.append(buffer, 0, byteRead);
            }
            content = output.toString();
            input.close();
        }
        catch (Exception e) {
            String m_state = "getClob( ResultSet rset , String value) : " + e.getMessage();
            String m_msg = "Error : " + value;
            System.out.println(m_state);
            System.out.println(m_msg);
        }
        return content;
    }
}

