/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.security.common.config;

import com.posdata.glue.security.common.config.ConfigurationException;
import com.posdata.glue.security.common.config.GeneralConfiguration;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class Configuration
extends GeneralConfiguration {
    private static Configuration instance = null;
    private static String configFile = null;

    private Configuration() throws ConfigurationException {
        this.loadProperty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getInstance() throws ConfigurationException {
        Object object = lock;
        synchronized (object) {
            if (instance == null || props == null || Configuration.isModified()) {
                instance = new Configuration();
            }
            return instance;
        }
    }

    private static boolean isModified() throws ConfigurationException {
        if (configFile == null) {
            return true;
        }
        boolean isModified = false;
        try {
            File file = new File(configFile);
            if (lastModified != file.lastModified()) {
                isModified = true;
            }
        }
        catch (Exception e) {
            lastModified = 0L;
            throw new ConfigurationException("Can't open security.properties.");
        }
        return isModified;
    }

    private void loadProperty() throws ConfigurationException {
        this.setFileURL();
        try {
            File tdfFile = new File(configFile);
            if (!tdfFile.canRead()) {
                throw new ConfigurationException(this.getClass().getName() + " - Can't open security.properties.");
            }
            props = new Properties();
            FileInputStream fIn = new FileInputStream(tdfFile);
            props.load(new BufferedInputStream(fIn));
            fIn.close();
            lastModified = tdfFile.lastModified();
        }
        catch (Exception e) {
            lastModified = 0L;
            throw new ConfigurationException(this.getClass().getName() + " - Can't load security.properties.");
        }
    }

    private void setFileURL() throws ConfigurationException {
        String configPath = System.getProperty("CONFIG_PATH");
        if (configPath == null) {
            throw new ConfigurationException(this.getClass().getName() + " - system property(CONFIG_PATH) \uac00 \uc124\uc815\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        }
        configFile = configPath + "/security.properties";
    }
}

