/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.security.common.util.auth;

import com.posdata.glue.security.PosAccessDeniedException;
import com.posdata.glue.security.cache.PosFunctionContent;
import com.posdata.glue.security.common.config.PosSecurityConfig;
import com.posdata.glue.security.common.util.auth.PosSecureParams;
import com.posdata.glue.security.common.util.auth.PosSecurityHandlerIF;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public abstract class PosAbstractSecurityHandlerImpl
implements PosSecurityHandlerIF,
Serializable {
    private PosLog logger = PosLogFactory.getLogger(this.getClass());
    protected PosSecureParams authParams;
    protected static String SSO_EMP_NO = "employeenumber";
    private static String SERVICE_NAME = "ServiceName";

    public boolean checkValidFunction(Object[] params) throws PosAccessDeniedException {
        String compareUrl;
        if (PosSecurityConfig.getLevel() == 0 || PosSecurityConfig.getLevel() == 1) {
            if (this.logger.isDebugEnabled()) {
                this.logger.logDebug((Object)"security level is zero, skip checking function");
            }
            return true;
        }
        String reqFuncKey = (String)params[0];
        String serviceName = (String)params[1];
        Map userFuncMap = (Map)params[2];
        Map requestMap = (Map)params[3];
        String requestURI = (String)params[4];
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("function check parameter : reqFuncKey = " + reqFuncKey + " , serviceName = " + serviceName + " , requestURI = " + requestURI));
            this.logger.logDebug((Object)("function check parameter : userFuncMap isEmpty = " + userFuncMap.isEmpty() + " ,  requestMap isEmpty = " + requestMap.isEmpty()));
        }
        if (PosSecurityConfig.getLevel() == 2 && reqFuncKey == null) {
            throw new PosAccessDeniedException("Function must be requested if security level is 2");
        }
        if (userFuncMap == null) {
            throw new PosAccessDeniedException("user is not allowed to access any page : Any Responsibility is not granted");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("function check : userFuncMap.containsKey(reqFuncKey) = " + userFuncMap.containsKey(reqFuncKey)));
        }
        if (!userFuncMap.containsKey(reqFuncKey)) {
            throw new PosAccessDeniedException("user is not allowed to this function ( " + reqFuncKey + " ) : ");
        }
        PosFunctionContent funcInfo = (PosFunctionContent)userFuncMap.get(reqFuncKey);
        List urlList = funcInfo.getApplicableUrls();
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("function(" + reqFuncKey + ") URL List : " + urlList));
        }
        if (urlList == null) {
            throw new PosAccessDeniedException("this URL (" + requestURI + ") is not allowed to this function : valid URL = " + urlList);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("function(" + reqFuncKey + ") contextRoot of URL List : " + funcInfo.getContextRoot()));
        }
        if (!urlList.contains(compareUrl = this.getCompareUrl(requestURI, funcInfo))) {
            if (this.logger.isErrorEnabled()) {
                this.logger.logDebug((Object)("function valid check error (requestURI is not accessible) : requestURI = " + requestURI + " Accessible URL List = " + urlList + " , contextRoot = " + funcInfo.getContextRoot()));
            }
            throw new PosAccessDeniedException("this URL (" + requestURI + ") is not allowed to this function : valid URL = " + urlList);
        }
        this.checkValidEvent(reqFuncKey, requestURI, funcInfo, requestMap);
        return true;
    }

    private String getCompareUrl(String requestURI, PosFunctionContent funcInfo) {
        if (requestURI == null || funcInfo == null) {
            return null;
        }
        String url = requestURI.replaceAll(funcInfo.getContextRoot(), "");
        return url;
    }

    private boolean checkValidEvent(String reqFuncKey, String requestURI, PosFunctionContent funcInfo, Map requestMap) {
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("check Event  : ApplicableEventUrl=" + funcInfo.getApplicableEventUrl() + ",Requested SERVICE_NAME=" + requestMap.get(SERVICE_NAME) + ",TotalEventList=" + funcInfo.getTotalEventList() + ",ApplicableEvents=" + funcInfo.getApplicableEvents()));
        }
        if (funcInfo.getApplicableEventUrl() == null || funcInfo.getApplicableEvents() == null || funcInfo.getTotalEventList() == null || requestMap.get(SERVICE_NAME) == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.logDebug((Object)"check Event is skipped");
            }
            return true;
        }
        String eventUrl = funcInfo.getApplicableEventUrl();
        if (eventUrl.endsWith("?")) {
            eventUrl = eventUrl.substring(0, eventUrl.length() - 1);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("check Event : requestURI = " + requestURI + ", converted event url = " + eventUrl));
        }
        if (!requestURI.endsWith(eventUrl)) {
            return true;
        }
        String requestEvent = this.getRequestEvent(funcInfo, requestMap);
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("check Event : requestEvent = " + requestEvent));
        }
        if (requestEvent == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.logDebug((Object)"check Event return true : requestEvent is null");
            }
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("check Event : ApplicableEvents contains requestEvent=" + funcInfo.getApplicableEvents().contains(requestEvent)));
        }
        if (funcInfo.getApplicableEvents().contains(requestEvent)) {
            return true;
        }
        throw new PosAccessDeniedException("this event [" + requestEvent + "] is not allowed : Your Available event is " + funcInfo.getApplicableEvents() + " for this function (" + reqFuncKey + ") ");
    }

    private String getRequestEvent(PosFunctionContent funcInfo, Map requestMap) {
        List totalEventList = funcInfo.getTotalEventList();
        for (int i = 0; i < totalEventList.size(); ++i) {
            if (!requestMap.containsKey(totalEventList.get(i)) || requestMap.get(totalEventList.get(i)) == null) continue;
            return (String)totalEventList.get(i);
        }
        return null;
    }

    protected PosSecureParams getAuthParams() {
        return this.authParams;
    }

    protected void setAuthParams(PosSecureParams authParams) {
        this.authParams = authParams;
    }

    protected HttpServletRequest getRequest() {
        return (HttpServletRequest)this.getAuthParams().getParam("WebRequest");
    }
}

