/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.security.common.util.auth;

import com.posco.sso.session.SSOSession;
import com.posdata.glue.security.PosAuthenticationException;
import com.posdata.glue.security.PosAuthenticationUserCookieNotValidException;
import com.posdata.glue.security.common.util.auth.PosAbstractSecurityHandlerImpl;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import javax.servlet.http.HttpServletRequest;

public class PosSSOSecurityHandlerImpl
extends PosAbstractSecurityHandlerImpl {
    private PosLog logger = PosLogFactory.getLogger(this.getClass());

    public String getUserEmpNo() throws PosAuthenticationException {
        if (!SSOSession.isSSOValid((HttpServletRequest)this.getRequest())) {
            if (this.logger.isErrorEnabled()) {
                this.logger.logError((Object)"SSOSession.isSSOValid : false");
            }
            throw new PosAuthenticationUserCookieNotValidException("User Cookie is not valid");
        }
        try {
            return SSOSession.getMesCookieInfo((HttpServletRequest)this.getRequest(), (String)SSO_EMP_NO);
        }
        catch (Exception ex) {
            if (this.logger.isErrorEnabled()) {
                this.logger.logError((Object)"SSOSession.getMesCookieInfo Exception : ", (Throwable)ex);
            }
            throw new PosAuthenticationUserCookieNotValidException("unexpected Exception occurs during searching UserEmpno from cookies", ex);
        }
    }
}

