/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.security.ui.webapps;

import com.posdata.glue.security.authentication.providers.PosAuthenticationToken;
import com.posdata.glue.security.common.util.PosSecureCacheUtil;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.event.authentication.InteractiveAuthenticationSuccessEvent;
import org.acegisecurity.ui.AbstractProcessingFilter;
import org.springframework.context.ApplicationEvent;

public class PosAuthenticationProcessingFilter
extends AbstractProcessingFilter {
    private PosLog logger = PosLogFactory.getLogger(((Object)((Object)this)).getClass());
    private PosSecureCacheUtil posSecureCacheUtil;

    public Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
        PosAuthenticationToken authRequest = null;
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            authRequest = new PosAuthenticationToken();
            SecurityContextHolder.getContext().setAuthentication((Authentication)authRequest);
        } else {
            authRequest = (PosAuthenticationToken)SecurityContextHolder.getContext().getAuthentication();
        }
        authRequest.setRequest(request);
        authRequest.setPosSecureCaheUtil(this.getPosSecureCacheUtil());
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpResponse;
        HttpServletRequest httpRequest;
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Can only process HttpServletResponse");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("current uri : " + ((HttpServletRequest)request).getRequestURI()));
        }
        if (this.requiresAuthentication(httpRequest = (HttpServletRequest)request, httpResponse = (HttpServletResponse)response)) {
            Authentication authResult;
            if (this.logger.isDebugEnabled()) {
                this.logger.logDebug((Object)"Request is to process authentication");
            }
            try {
                this.onPreAuthentication(httpRequest, httpResponse);
                authResult = this.attemptAuthentication(httpRequest);
            }
            catch (AuthenticationException failed) {
                this.unsuccessfulAuthentication(httpRequest, httpResponse, failed);
                return;
            }
            if (this.isContinueChainBeforeSuccessfulAuthentication()) {
                chain.doFilter(request, response);
            }
            this.successfulAuthentication(httpRequest, httpResponse, authResult);
        }
        chain.doFilter(request, response);
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("Authentication success: " + authResult.toString()));
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("Updated SecurityContextHolder to contain the following Authentication: '" + authResult + "'"));
        }
        String targetUrl = PosAuthenticationProcessingFilter.obtainFullRequestUrl((HttpServletRequest)request);
        if (this.isAlwaysUseDefaultTargetUrl()) {
            targetUrl = null;
        }
        if (targetUrl == null) {
            targetUrl = request.getContextPath() + this.getDefaultTargetUrl();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("Redirecting to target URL from HTTP Session (or default): " + targetUrl));
        }
        this.onSuccessfulAuthentication(request, response, authResult);
        this.getRememberMeServices().loginSuccess(request, response, authResult);
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new InteractiveAuthenticationSuccessEvent(authResult, ((Object)((Object)this)).getClass()));
        }
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        SecurityContextHolder.getContext().setAuthentication(null);
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)"Updated SecurityContextHolder to contain null Authentication");
        }
        String failureUrl = this.getExceptionMappings().getProperty(((Object)((Object)failed)).getClass().getName(), this.getAuthenticationFailureUrl());
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("Authentication request failed: " + failed.toString()));
        }
        try {
            request.setAttribute("ACEGI_SECURITY_LAST_EXCEPTION", (Object)failed);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.onUnsuccessfulAuthentication(request, response, failed);
        this.getRememberMeServices().loginFail(request, response);
        this.sendForward(request, response, failureUrl);
    }

    protected void sendForward(HttpServletRequest request, HttpServletResponse response, String url) {
        block3: {
            try {
                if (this.logger.isDebugEnabled()) {
                    this.logger.logDebug((Object)("forwarding exception to URL(" + url + ")"));
                }
                request.getRequestDispatcher(url).forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (Exception ex) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.logError((Object)"forwarding error : ", (Throwable)ex);
            }
        }
    }

    public String getDefaultFilterProcessesUrl() {
        return "/";
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public PosSecureCacheUtil getPosSecureCacheUtil() {
        return this.posSecureCacheUtil;
    }

    public void setPosSecureCacheUtil(PosSecureCacheUtil posSecureCacheUtil) {
        this.posSecureCacheUtil = posSecureCacheUtil;
    }
}

