/*
 * Decompiled with CFR 0.152.
 */
package com.posdata.glue.security.vote;

import com.posdata.glue.security.PosAccessDeniedException;
import com.posdata.glue.security.PosUserImpl;
import com.posdata.glue.security.authentication.providers.PosAuthenticationToken;
import com.posdata.glue.security.common.util.auth.PosSecurityHandlerIF;
import com.posdata.glue.security.context.PosSecurityContextHolder;
import com.posdata.glue.util.log.PosLog;
import com.posdata.glue.util.log.PosLogFactory;
import java.util.Arrays;
import java.util.List;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.vote.AccessDecisionVoter;

public class PosAuthorizeVoter
implements AccessDecisionVoter {
    protected String skipUrl;
    private PosLog logger = PosLogFactory.getLogger(this.getClass());

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        try {
            if (this.isSkipUrl(authentication)) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.logDebug((Object)"current url is skip URL and then Access granted");
                }
                return 1;
            }
            PosUserImpl user = PosSecurityContextHolder.getUserInfo();
            PosSecurityHandlerIF handler = ((PosAuthenticationToken)authentication).getSecurityHandlerIF();
            if (handler == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.logError((Object)"PosSecurityHandlerIF is null : can not check authorization");
                }
                throw new PosAccessDeniedException("Security Check Handler is not found");
            }
            handler.checkValidFunction(new Object[]{user.getFuncKey(), ((PosAuthenticationToken)authentication).getRequestParameter("ServiceName"), user.getUserFunctions(), ((PosAuthenticationToken)authentication).getRequestParameterMap(), ((PosAuthenticationToken)authentication).getCurrentURL()});
        }
        catch (PosAccessDeniedException aex) {
            if (this.logger.isErrorEnabled()) {
                this.logger.logError((Object)"PosAccessDeniedException occured : ", (Throwable)((Object)aex));
            }
            throw aex;
        }
        catch (Exception ex) {
            if (this.logger.isErrorEnabled()) {
                this.logger.logError((Object)"unexpected access denied Exception : ", (Throwable)ex);
            }
            throw new PosAccessDeniedException("Access Denied", ex);
        }
        return 1;
    }

    private boolean isSkipUrl(Authentication authentication) {
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebug((Object)("Authorization Skip URL : " + this.getSkipUrls()));
            this.logger.logDebug((Object)("Authorization Current URL : " + ((PosAuthenticationToken)authentication).getCurrentURL()));
        }
        if (this.getSkipUrls() == null) {
            return false;
        }
        return this.getSkipUrls().contains(((PosAuthenticationToken)authentication).getCurrentURL());
    }

    public List getSkipUrls() {
        if (this.skipUrl == null) {
            return null;
        }
        return Arrays.asList(this.skipUrl.split(","));
    }

    public void setSkipUrl(String skipUrl) {
        this.skipUrl = skipUrl;
    }
}

