/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.indexed;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheManager;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDiskCache;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.jcs.engine.behavior.ICache;

public class IndexedDiskCacheManager
implements AuxiliaryCacheManager {
    private static final long serialVersionUID = -4153287154512274626L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCacheManager == null ? (class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCacheManager = IndexedDiskCacheManager.class$("org.apache.jcs.auxiliary.disk.indexed.IndexedDiskCacheManager")) : class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCacheManager));
    private static int clients;
    private static IndexedDiskCacheManager instance;
    private Hashtable caches = new Hashtable();
    private IndexedDiskCacheAttributes defaultCacheAttributes;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCacheManager;

    private IndexedDiskCacheManager(IndexedDiskCacheAttributes defaultCacheAttributes) {
        this.defaultCacheAttributes = defaultCacheAttributes;
    }

    public static IndexedDiskCacheManager getInstance(IndexedDiskCacheAttributes defaultCacheAttributes) {
        Class clazz = class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCacheManager == null ? (class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCacheManager = IndexedDiskCacheManager.class$("org.apache.jcs.auxiliary.disk.indexed.IndexedDiskCacheManager")) : class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCacheManager;
        synchronized (clazz) {
            if (instance == null) {
                instance = new IndexedDiskCacheManager(defaultCacheAttributes);
            }
        }
        ++clients;
        return instance;
    }

    public AuxiliaryCache getCache(String cacheName) {
        IndexedDiskCacheAttributes cacheAttributes = (IndexedDiskCacheAttributes)this.defaultCacheAttributes.copy();
        cacheAttributes.setCacheName(cacheName);
        return this.getCache(cacheAttributes);
    }

    public AuxiliaryCache getCache(IndexedDiskCacheAttributes cacheAttributes) {
        AuxiliaryCache cache = null;
        String cacheName = cacheAttributes.getCacheName();
        log.debug((Object)("Getting cache named: " + cacheName));
        Hashtable hashtable = this.caches;
        synchronized (hashtable) {
            cache = (AuxiliaryCache)this.caches.get(cacheName);
            if (cache == null) {
                cache = new IndexedDiskCache(cacheAttributes);
                this.caches.put(cacheName, cache);
            }
        }
        return cache;
    }

    public void freeCache(String cacheName) {
        ICache cache = (ICache)this.caches.get(cacheName);
        if (cache != null) {
            try {
                cache.dispose();
            }
            catch (Exception e) {
                log.error((Object)("Failure disposing cache: " + cacheName), (Throwable)e);
            }
        }
    }

    public int getCacheType() {
        return 2;
    }

    public void release() {
        --clients;
        if (--clients != 0) {
            return;
        }
        Hashtable hashtable = this.caches;
        synchronized (hashtable) {
            Enumeration allCaches = this.caches.elements();
            while (allCaches.hasMoreElements()) {
                ICache cache = (ICache)allCaches.nextElement();
                if (cache == null) continue;
                try {
                    cache.dispose();
                }
                catch (Exception e) {
                    log.error((Object)("Failure disposing cache: " + cache.getCacheName()), (Throwable)e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

