/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.jdbc;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.IElementSerializer;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;
import org.apache.jcs.utils.serialization.StandardSerializer;

public class JDBCDiskCache
extends AbstractDiskCache {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCache == null ? (class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCache = JDBCDiskCache.class$("org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCache")) : class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCache));
    private static final long serialVersionUID = -7169488308515823492L;
    private IElementSerializer elementSerializer = new StandardSerializer();
    private JDBCDiskCacheAttributes jdbcDiskCacheAttributes;
    private static final String DEFAULT_POOL_NAME = "jcs";
    private String poolName = "jcs";
    private static final String DRIVER_NAME = "jdbc:apache:commons:dbcp:";
    private int updateCount = 0;
    private int getCount = 0;
    private static final int LOG_INTERVAL = 100;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$jdbc$JDBCDiskCache;

    public JDBCDiskCache(JDBCDiskCacheAttributes cattr) {
        super(cattr);
        this.setJdbcDiskCacheAttributes(cattr);
        if (log.isInfoEnabled()) {
            log.info((Object)("jdbcDiskCacheAttributes = " + this.getJdbcDiskCacheAttributes()));
        }
        try {
            try {
                Class.forName(cattr.getDriverClassName());
            }
            catch (ClassNotFoundException e) {
                log.error((Object)("Couldn't find class for driver [" + cattr.getDriverClassName() + "]"), (Throwable)e);
            }
            this.setupDriver(cattr.getUrl() + cattr.getDatabase(), cattr.getUserName(), cattr.getPassword(), cattr.getMaxActive());
            this.logDriverStats();
        }
        catch (Exception e) {
            log.error((Object)"Problem getting connection.", (Throwable)e);
        }
        this.alive = true;
    }

    /*
     * Loose catch block
     */
    public void doUpdate(ICacheElement ce) {
        block39: {
            Connection con;
            block36: {
                block37: {
                    this.incrementUpdateCount();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("updating, ce = " + ce));
                    }
                    try {
                        con = DriverManager.getConnection(this.getPoolUrl());
                    }
                    catch (SQLException e) {
                        log.error((Object)"Problem getting conenction.", (Throwable)e);
                        return;
                    }
                    Statement sStatement = null;
                    sStatement = con.createStatement();
                    this.alive = true;
                    Object var6_5 = null;
                    try {
                        sStatement.close();
                    }
                    catch (SQLException e2) {
                        log.error((Object)"Problem closing statement.", (Throwable)e2);
                    }
                    break block37;
                    {
                        catch (SQLException e) {
                            log.error((Object)"Problem creating statement.", (Throwable)e);
                            this.alive = false;
                            var6_5 = null;
                            try {
                                sStatement.close();
                            }
                            catch (SQLException e2) {
                                log.error((Object)"Problem closing statement.", (Throwable)e2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        try {
                            sStatement.close();
                        }
                        catch (SQLException e2) {
                            log.error((Object)"Problem closing statement.", (Throwable)e2);
                        }
                        throw throwable;
                    }
                }
                if (this.alive) break block38;
                if (log.isInfoEnabled()) {
                    log.info((Object)"Disk is not alive, aborting put.");
                }
                Object var14_16 = null;
                try {
                    con.close();
                }
                catch (SQLException e3) {
                    log.error((Object)"Problem closing connection.", (Throwable)e3);
                }
                {
                    long expireTime;
                    long now;
                    Date createTime;
                    boolean exists;
                    byte[] element;
                    block35: {
                        block38: {
                            return;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Putting [" + ce.getKey() + "] on disk."));
                        }
                        try {
                            element = this.serialize(ce);
                        }
                        catch (IOException e) {
                            log.error((Object)"Could not serialize element", (Throwable)e);
                            Object var14_17 = null;
                            try {
                                con.close();
                            }
                            catch (SQLException e3) {
                                log.error((Object)"Problem closing connection.", (Throwable)e3);
                            }
                            return;
                        }
                        exists = false;
                        if (this.getJdbcDiskCacheAttributes().isTestBeforeInsert()) {
                            exists = this.doesElementExist(ce);
                        }
                        if (!exists) {
                            try {
                                String sqlI = "insert into " + this.getJdbcDiskCacheAttributes().getTableName() + " (CACHE_KEY, REGION, ELEMENT, MAX_LIFE_SECONDS, IS_ETERNAL, CREATE_TIME, CREATE_TIME_SECONDS, SYSTEM_EXPIRE_TIME_SECONDS) " + " values (?, ?, ?, ?, ?, ?, ?, ?)";
                                PreparedStatement psInsert = con.prepareStatement(sqlI);
                                psInsert.setString(1, (String)((Object)ce.getKey()));
                                psInsert.setString(2, this.getCacheName());
                                psInsert.setBytes(3, element);
                                psInsert.setLong(4, ce.getElementAttributes().getMaxLifeSeconds());
                                if (ce.getElementAttributes().getIsEternal()) {
                                    psInsert.setString(5, "T");
                                } else {
                                    psInsert.setString(5, "F");
                                }
                                createTime = new Date(ce.getElementAttributes().getCreateTime());
                                psInsert.setDate(6, createTime);
                                now = System.currentTimeMillis() / 1000L;
                                psInsert.setLong(7, now);
                                expireTime = now + ce.getElementAttributes().getMaxLifeSeconds();
                                psInsert.setLong(8, expireTime);
                                psInsert.execute();
                                psInsert.close();
                            }
                            catch (SQLException e) {
                                if (e.toString().indexOf("Violation of unique index") != -1 || e.getMessage().indexOf("Violation of unique index") != -1 || e.getMessage().indexOf("Duplicate entry") != -1) {
                                    exists = true;
                                } else {
                                    log.error((Object)"Could not insert element", (Throwable)e);
                                }
                                if (exists || this.getJdbcDiskCacheAttributes().isTestBeforeInsert()) break block35;
                                exists = this.doesElementExist(ce);
                            }
                        }
                    }
                    if (!exists) break block36;
                    String sqlU = null;
                    try {
                        sqlU = "update " + this.getJdbcDiskCacheAttributes().getTableName() + " set ELEMENT  = ?, CREATE_TIME = ?, CREATE_TIME_SECONDS = ?, " + " SYSTEM_EXPIRE_TIME_SECONDS = ? " + " where CACHE_KEY = ? and REGION = ?";
                        PreparedStatement psUpdate = con.prepareStatement(sqlU);
                        psUpdate.setBytes(1, element);
                        createTime = new Date(ce.getElementAttributes().getCreateTime());
                        psUpdate.setDate(2, createTime);
                        now = System.currentTimeMillis() / 1000L;
                        psUpdate.setLong(3, now);
                        expireTime = now + ce.getElementAttributes().getMaxLifeSeconds();
                        psUpdate.setLong(4, expireTime);
                        psUpdate.setString(5, (String)((Object)ce.getKey()));
                        psUpdate.setString(6, this.getCacheName());
                        psUpdate.execute();
                        psUpdate.close();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("ran update " + sqlU));
                        }
                    }
                    catch (SQLException e2) {
                        log.error((Object)("e2 sql [" + sqlU + "] Exception: "), (Throwable)e2);
                    }
                }
            }
            Object var14_18 = null;
            try {
                con.close();
            }
            catch (SQLException e3) {
                log.error((Object)"Problem closing connection.", (Throwable)e3);
            }
            break block39;
            catch (Throwable throwable) {
                Object var14_19 = null;
                try {
                    con.close();
                }
                catch (SQLException e3) {
                    log.error((Object)"Problem closing connection.", (Throwable)e3);
                }
                throw throwable;
            }
        }
        if (log.isInfoEnabled() && this.updateCount % 100 == 0) {
            log.info((Object)("Update Count [" + this.updateCount + "]"));
        }
    }

    /*
     * Loose catch block
     */
    protected boolean doesElementExist(ICacheElement ce) {
        boolean exists;
        block19: {
            ResultSet rs;
            Connection con;
            exists = false;
            try {
                con = DriverManager.getConnection(this.getPoolUrl());
            }
            catch (SQLException e) {
                log.error((Object)"Problem getting conenction.", (Throwable)e);
                return exists;
            }
            Statement sStatement = null;
            sStatement = con.createStatement();
            String sqlS = "select CACHE_KEY from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = '" + this.getCacheName() + "' and CACHE_KEY = '" + (String)((Object)ce.getKey()) + "'";
            if (log.isDebugEnabled()) {
                log.debug((Object)sqlS);
            }
            if ((rs = sStatement.executeQuery(sqlS)).next()) {
                exists = true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("[" + ce.getKey() + "] existing status is " + exists));
            }
            rs.close();
            Object var8_9 = null;
            try {
                sStatement.close();
            }
            catch (SQLException e1) {
                log.error((Object)"Problem closing statement.", (Throwable)e1);
            }
            try {
                con.close();
            }
            catch (SQLException e2) {
                log.error((Object)"Problem closing connection.", (Throwable)e2);
            }
            break block19;
            {
                catch (SQLException e) {
                    log.error((Object)"Problem looking for item before insert.", (Throwable)e);
                    Object var8_10 = null;
                    try {
                        sStatement.close();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Problem closing statement.", (Throwable)e1);
                    }
                    try {
                        con.close();
                    }
                    catch (SQLException e2) {
                        log.error((Object)"Problem closing connection.", (Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                try {
                    sStatement.close();
                }
                catch (SQLException e1) {
                    log.error((Object)"Problem closing statement.", (Throwable)e1);
                }
                try {
                    con.close();
                }
                catch (SQLException e2) {
                    log.error((Object)"Problem closing connection.", (Throwable)e2);
                }
                throw throwable;
            }
        }
        return exists;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICacheElement doGet(Serializable key) {
        ICacheElement obj;
        block21: {
            this.incrementGetCount();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Getting " + key + " from disk"));
            }
            if (!this.alive) {
                return null;
            }
            obj = null;
            byte[] data = null;
            try {
                String selectString = "select ELEMENT from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ? and CACHE_KEY = ?";
                Connection con = DriverManager.getConnection(this.getPoolUrl());
                try {
                    PreparedStatement psSelect;
                    block20: {
                        psSelect = null;
                        try {
                            ResultSet rs;
                            block19: {
                                psSelect = con.prepareStatement(selectString);
                                psSelect.setString(1, this.getCacheName());
                                psSelect.setString(2, (String)((Object)key));
                                rs = null;
                                rs = psSelect.executeQuery();
                                try {
                                    if (rs.next()) {
                                        data = rs.getBytes(1);
                                    }
                                    if (data != null) {
                                        try {
                                            obj = (ICacheElement)this.getElementSerializer().deSerialize(data);
                                        }
                                        catch (IOException ioe) {
                                            log.error((Object)ioe);
                                        }
                                        catch (Exception e) {
                                            log.error((Object)"Problem getting item.", (Throwable)e);
                                        }
                                    }
                                    Object var11_11 = null;
                                    if (rs == null) break block19;
                                }
                                catch (Throwable throwable) {
                                    Object var11_12 = null;
                                    if (rs != null) {
                                        rs.close();
                                    }
                                    rs.close();
                                    throw throwable;
                                }
                                rs.close();
                            }
                            rs.close();
                            Object var13_14 = null;
                            if (psSelect == null) break block20;
                        }
                        catch (Throwable throwable) {
                            Object var13_15 = null;
                            if (psSelect != null) {
                                psSelect.close();
                            }
                            psSelect.close();
                            throw throwable;
                        }
                        psSelect.close();
                    }
                    psSelect.close();
                    Object var15_17 = null;
                    if (con == null) break block21;
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    if (con != null) {
                        con.close();
                    }
                    throw throwable;
                }
                con.close();
            }
            catch (SQLException sqle) {
                log.error((Object)sqle);
            }
        }
        if (log.isInfoEnabled() && this.getCount % 100 == 0) {
            log.info((Object)("Get Count [" + this.getCount + "]"));
        }
        return obj;
    }

    /*
     * Loose catch block
     */
    public boolean doRemove(Serializable key) {
        block14: {
            String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where CACHE_KEY = '" + key + "' and REGION = '" + this.getCacheName() + "'";
            try {
                if (key instanceof String && key.toString().endsWith(":")) {
                    sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = '" + this.getCacheName() + "' and CACHE_KEY = like '" + key + "%'";
                }
                Connection con = DriverManager.getConnection(this.getPoolUrl());
                Statement sStatement = null;
                sStatement = con.createStatement();
                this.alive = true;
                sStatement.executeUpdate(sql);
                Object var7_6 = null;
                try {
                    if (sStatement != null) {
                        sStatement.close();
                    }
                    con.close();
                }
                catch (SQLException e1) {
                    log.error((Object)"Problem closing statement.", (Throwable)e1);
                }
                break block14;
                {
                    catch (SQLException e) {
                        log.error((Object)"Problem creating statement.", (Throwable)e);
                        this.alive = false;
                        Object var7_7 = null;
                        try {
                            if (sStatement != null) {
                                sStatement.close();
                            }
                            con.close();
                        }
                        catch (SQLException e1) {
                            log.error((Object)"Problem closing statement.", (Throwable)e1);
                        }
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    try {
                        if (sStatement != null) {
                            sStatement.close();
                        }
                        con.close();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Problem closing statement.", (Throwable)e1);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Problem updating cache.", (Throwable)e);
                this.reset();
            }
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public void doRemoveAll() {
        block16: {
            if (this.jdbcDiskCacheAttributes.isAllowRemoveAll()) {
                try {
                    String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = '" + this.getCacheName() + "'";
                    Connection con = DriverManager.getConnection(this.getPoolUrl());
                    Statement sStatement = null;
                    sStatement = con.createStatement();
                    this.alive = true;
                    sStatement.executeUpdate(sql);
                    Object var6_5 = null;
                    try {
                        if (sStatement != null) {
                            sStatement.close();
                        }
                        con.close();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Problem closing statement.", (Throwable)e1);
                    }
                    break block16;
                    {
                        catch (SQLException e) {
                            log.error((Object)"Problem creating statement.", (Throwable)e);
                            this.alive = false;
                            Object var6_6 = null;
                            try {
                                if (sStatement != null) {
                                    sStatement.close();
                                }
                                con.close();
                            }
                            catch (SQLException e1) {
                                log.error((Object)"Problem closing statement.", (Throwable)e1);
                            }
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        try {
                            if (sStatement != null) {
                                sStatement.close();
                            }
                            con.close();
                        }
                        catch (SQLException e1) {
                            log.error((Object)"Problem closing statement.", (Throwable)e1);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Problem removing all.", (Throwable)e);
                    this.reset();
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)"RemoveAll was requested but the request was not fulfilled: allowRemoveAll is set to false.");
            }
        }
    }

    /*
     * Loose catch block
     */
    protected int deleteExpired() {
        int deleted;
        block13: {
            deleted = 0;
            try {
                long now = System.currentTimeMillis() / 1000L;
                String sql = "delete from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = '" + this.getCacheName() + "' and IS_ETERNAL = 'F' and " + now + " > SYSTEM_EXPIRE_TIME_SECONDS";
                Connection con = DriverManager.getConnection(this.getPoolUrl());
                Statement sStatement = null;
                sStatement = con.createStatement();
                this.alive = true;
                deleted = sStatement.executeUpdate(sql);
                Object var9_7 = null;
                try {
                    if (sStatement != null) {
                        sStatement.close();
                    }
                    con.close();
                }
                catch (SQLException e1) {
                    log.error((Object)"Problem closing statement.", (Throwable)e1);
                }
                break block13;
                {
                    catch (SQLException e) {
                        log.error((Object)"Problem creating statement.", (Throwable)e);
                        this.alive = false;
                        Object var9_8 = null;
                        try {
                            if (sStatement != null) {
                                sStatement.close();
                            }
                            con.close();
                        }
                        catch (SQLException e1) {
                            log.error((Object)"Problem closing statement.", (Throwable)e1);
                        }
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    try {
                        if (sStatement != null) {
                            sStatement.close();
                        }
                        con.close();
                    }
                    catch (SQLException e1) {
                        log.error((Object)"Problem closing statement.", (Throwable)e1);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Problem removing all.", (Throwable)e);
                this.reset();
            }
        }
        return deleted;
    }

    public void reset() {
    }

    public void doDispose() {
        try {
            this.shutdownDriver();
        }
        catch (Exception e) {
            log.error((Object)"Problem shutting down.", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public int getSize() {
        block19: {
            size = 0;
            selectString = "select count(*) from " + this.getJdbcDiskCacheAttributes().getTableName() + " where REGION = ?";
            try {
                con = DriverManager.getConnection(this.getPoolUrl());
            }
            catch (SQLException e1) {
                JDBCDiskCache.log.error((Object)"Problem getting conenction.", (Throwable)e1);
                return size;
            }
            psSelect = null;
            try {
                psSelect = con.prepareStatement(selectString);
                psSelect.setString(1, this.getCacheName());
                rs = null;
                rs = psSelect.executeQuery();
                try {
                    if (rs.next()) {
                        size = rs.getInt(1);
                    }
                    var7_8 = null;
                    ** if (rs == null) goto lbl-1000
                }
                catch (Throwable var6_10) {
                    var7_9 = null;
                    if (rs != null) {
                        rs.close();
                    }
                    rs.close();
                    throw var6_10;
                }
lbl-1000:
                // 1 sources

                {
                    rs.close();
                }
lbl-1000:
                // 2 sources

                {
                }
                rs.close();
                var9_11 = null;
                ** if (psSelect == null) goto lbl-1000
            }
            catch (Throwable var8_13) {
                var9_12 = null;
                if (psSelect != null) {
                    psSelect.close();
                }
                psSelect.close();
                throw var8_13;
            }
lbl-1000:
            // 1 sources

            {
                psSelect.close();
            }
lbl-1000:
            // 2 sources

            {
            }
            psSelect.close();
            var11_14 = null;
            try {
                con.close();
            }
            catch (SQLException e) {
                JDBCDiskCache.log.error((Object)"Problem closing connection.", (Throwable)e);
            }
            break block19;
            {
                catch (SQLException e) {
                    JDBCDiskCache.log.error((Object)"Problem getting size.", (Throwable)e);
                    var11_15 = null;
                    try {
                        con.close();
                    }
                    catch (SQLException e) {
                        JDBCDiskCache.log.error((Object)"Problem closing connection.", (Throwable)e);
                    }
                }
            }
            catch (Throwable var10_20) {
                var11_16 = null;
                try {
                    con.close();
                }
                catch (SQLException e) {
                    JDBCDiskCache.log.error((Object)"Problem closing connection.", (Throwable)e);
                }
                throw var10_20;
            }
        }
        return size;
    }

    protected byte[] serialize(Serializable obj) throws IOException {
        return this.getElementSerializer().serialize(obj);
    }

    public Set getGroupKeys(String groupName) {
        throw new UnsupportedOperationException("Groups not implemented.");
    }

    public void setElementSerializer(IElementSerializer elementSerializer) {
        this.elementSerializer = elementSerializer;
    }

    public IElementSerializer getElementSerializer() {
        return this.elementSerializer;
    }

    public void setupDriver(String connectURI, String userName, String password, int maxActive) throws Exception {
        GenericObjectPool connectionPool = new GenericObjectPool(null, maxActive);
        connectionPool.setMaxIdle(-1);
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(connectURI, userName, password);
        new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)connectionPool, null, null, false, true);
        Class.forName("org.apache.commons.dbcp.PoolingDriver");
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(DRIVER_NAME);
        driver.registerPool(this.getPoolName(), (ObjectPool)connectionPool);
    }

    public void logDriverStats() throws Exception {
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(DRIVER_NAME);
        ObjectPool connectionPool = driver.getConnectionPool(this.getPoolName());
        if (connectionPool != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)connectionPool);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("NumActive: " + this.getNumActiveInPool()));
                log.info((Object)("NumIdle: " + this.getNumIdleInPool()));
            }
        } else {
            log.warn((Object)"Could not find pool.");
        }
    }

    public int getNumIdleInPool() {
        int numIdle = 0;
        try {
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(DRIVER_NAME);
            ObjectPool connectionPool = driver.getConnectionPool(this.getPoolName());
            if (log.isDebugEnabled()) {
                log.debug((Object)connectionPool);
            }
            numIdle = connectionPool.getNumIdle();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return numIdle;
    }

    public int getNumActiveInPool() {
        int numActive = 0;
        try {
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(DRIVER_NAME);
            ObjectPool connectionPool = driver.getConnectionPool(this.getPoolName());
            if (log.isDebugEnabled()) {
                log.debug((Object)connectionPool);
            }
            numActive = connectionPool.getNumActive();
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return numActive;
    }

    public void shutdownDriver() throws Exception {
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver(DRIVER_NAME);
        driver.closePool(this.getPoolName());
    }

    public String getPoolUrl() {
        return DRIVER_NAME + this.getPoolName();
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getPoolName() {
        return this.poolName;
    }

    private synchronized void incrementUpdateCount() {
        ++this.updateCount;
    }

    private synchronized void incrementGetCount() {
        ++this.getCount;
    }

    protected void setJdbcDiskCacheAttributes(JDBCDiskCacheAttributes jdbcDiskCacheAttributes) {
        this.jdbcDiskCacheAttributes = jdbcDiskCacheAttributes;
    }

    protected JDBCDiskCacheAttributes getJdbcDiskCacheAttributes() {
        return this.jdbcDiskCacheAttributes;
    }

    public IStats getStatistics() {
        IStats stats = super.getStatistics();
        stats.setTypeName("JDBC/Abstract Disk Cache");
        stats.getStatElements();
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Update Count");
        se.setData("" + this.updateCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Get Count");
        se.setData("" + this.getCount);
        elems.add(se);
        se = new StatElement();
        se.setName("Size");
        se.setData("" + this.getSize());
        elems.add(se);
        se = new StatElement();
        se.setName("Active DB Connections");
        se.setData("" + this.getNumActiveInPool());
        elems.add(se);
        se = new StatElement();
        se.setName("Idle DB Connections");
        se.setData("" + this.getNumIdleInPool());
        elems.add(se);
        se = new StatElement();
        se.setName("DB URL");
        se.setData(this.jdbcDiskCacheAttributes.getUrl());
        elems.add(se);
        IStatElement[] eqSEs = stats.getStatElements();
        List<IStatElement> eqL = Arrays.asList(eqSEs);
        elems.addAll(eqL);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    protected String getTableName() {
        String name = "UNDEFINED";
        if (this.getJdbcDiskCacheAttributes() != null) {
            name = this.getJdbcDiskCacheAttributes().getTableName();
        }
        return name;
    }

    public String toString() {
        return this.getStats();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

