/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.jdbc;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCache;

public class ShrinkerThread
implements Runnable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$jdbc$ShrinkerThread == null ? (class$org$apache$jcs$auxiliary$disk$jdbc$ShrinkerThread = ShrinkerThread.class$("org.apache.jcs.auxiliary.disk.jdbc.ShrinkerThread")) : class$org$apache$jcs$auxiliary$disk$jdbc$ShrinkerThread));
    private Set shrinkSet = Collections.synchronizedSet(new HashSet());
    private static final long DEFAULT_PAUSE_BETWEEN_REGION_CALLS_MILLIS = 5000L;
    private long pauseBetweenRegionCallsMillis = 5000L;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$jdbc$ShrinkerThread;

    protected ShrinkerThread() {
    }

    public void addDiskCacheToShrinkList(JDBCDiskCache diskCache) {
        this.shrinkSet.add(diskCache);
    }

    public void run() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Running JDBC disk cache shrinker.  Number of regions [" + this.shrinkSet.size() + "]"));
        }
        Object[] caches = null;
        Set set = this.shrinkSet;
        synchronized (set) {
            caches = this.shrinkSet.toArray();
        }
        if (caches != null) {
            int i = 0;
            while (i < caches.length) {
                JDBCDiskCache cache = (JDBCDiskCache)caches[i];
                long start = System.currentTimeMillis();
                int deleted = cache.deleteExpired();
                long end = System.currentTimeMillis();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Deleted [" + deleted + "] expired for region [" + cache.getCacheName() + "] for table [" + cache.getTableName() + "] in " + (end - start) + " ms."));
                }
                if (i < caches.length - 1) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Pausing for [" + this.getPauseBetweenRegionCallsMillis() + "] ms. before shinker the next region."));
                    }
                    try {
                        Thread.sleep(this.getPauseBetweenRegionCallsMillis());
                    }
                    catch (InterruptedException e) {
                        log.warn((Object)"Interrupted while waiting to delete expired for the enxt region.");
                    }
                }
                ++i;
            }
        }
    }

    public void setPauseBetweenRegionCallsMillis(long pauseBetweenRegionCallsMillis) {
        this.pauseBetweenRegionCallsMillis = pauseBetweenRegionCallsMillis;
    }

    public long getPauseBetweenRegionCallsMillis() {
        return this.pauseBetweenRegionCallsMillis;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

