/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.jdbc.hsql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.AuxiliaryCacheAttributes;
import org.apache.jcs.auxiliary.AuxiliaryCacheFactory;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCacheAttributes;
import org.apache.jcs.auxiliary.disk.jdbc.JDBCDiskCacheManager;
import org.apache.jcs.engine.behavior.ICompositeCacheManager;
import org.hsqldb.jdbcDriver;

public class HSQLDiskCacheFactory
implements AuxiliaryCacheFactory {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$jdbc$hsql$HSQLDiskCacheFactory == null ? (class$org$apache$jcs$auxiliary$disk$jdbc$hsql$HSQLDiskCacheFactory = HSQLDiskCacheFactory.class$("org.apache.jcs.auxiliary.disk.jdbc.hsql.HSQLDiskCacheFactory")) : class$org$apache$jcs$auxiliary$disk$jdbc$hsql$HSQLDiskCacheFactory));
    private String name = "HSQLDiskCacheFactory";
    private Set databases = Collections.synchronizedSet(new HashSet());
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$jdbc$hsql$HSQLDiskCacheFactory;

    public AuxiliaryCache createCache(AuxiliaryCacheAttributes rawAttr, ICompositeCacheManager arg1) {
        JDBCDiskCacheManager mgr = JDBCDiskCacheManager.getInstance((JDBCDiskCacheAttributes)rawAttr);
        try {
            this.setupDatabase((JDBCDiskCacheAttributes)rawAttr);
        }
        catch (Exception e) {
            log.error((Object)"Problem setting up database.", (Throwable)e);
        }
        return mgr.getCache((JDBCDiskCacheAttributes)rawAttr);
    }

    public void setName(String nameArg) {
        this.name = nameArg;
    }

    public String getName() {
        return this.name;
    }

    protected void setupDatabase(JDBCDiskCacheAttributes attributes) throws Exception {
        if (attributes == null) {
            throw new Exception("The attributes are null.");
        }
        String database = attributes.getUrl() + attributes.getDatabase();
        if (this.databases.contains(database)) {
            if (log.isInfoEnabled()) {
                log.info((Object)("We already setup database [" + database + "]"));
            }
            return;
        }
        System.setProperty("hsqldb.cache_scale", "8");
        String driver = attributes.getDriverClassName();
        String user = attributes.getUserName();
        String password = attributes.getPassword();
        new jdbcDriver();
        try {
            Class.forName(driver).newInstance();
            Connection cConn = DriverManager.getConnection(database, user, password);
            this.setupTABLE(cConn, attributes.getTableName());
            if (log.isInfoEnabled()) {
                log.info((Object)("Finished setting up database [" + database + "]"));
            }
            this.databases.add(database);
        }
        catch (Exception e) {
            log.error((Object)"Fatal problem setting up the database.", (Throwable)e);
        }
    }

    private void setupTABLE(Connection cConn, String tableName) {
        boolean newT = true;
        StringBuffer createSql = new StringBuffer();
        createSql.append("CREATE CACHED TABLE " + tableName);
        createSql.append("( ");
        createSql.append("CACHE_KEY             VARCHAR(250)          NOT NULL, ");
        createSql.append("REGION                VARCHAR(250)          NOT NULL, ");
        createSql.append("ELEMENT               BINARY, ");
        createSql.append("CREATE_TIME           DATE, ");
        createSql.append("CREATE_TIME_SECONDS   BIGINT, ");
        createSql.append("MAX_LIFE_SECONDS      BIGINT, ");
        createSql.append("SYSTEM_EXPIRE_TIME_SECONDS      BIGINT, ");
        createSql.append("IS_ETERNAL            CHAR(1), ");
        createSql.append("PRIMARY KEY (CACHE_KEY, REGION) ");
        createSql.append(");");
        Statement sStatement = null;
        try {
            sStatement = cConn.createStatement();
        }
        catch (SQLException e) {
            log.error((Object)"problem creating a statement.", (Throwable)e);
        }
        try {
            sStatement.executeQuery(createSql.toString());
            sStatement.close();
        }
        catch (SQLException e) {
            if (e.toString().indexOf("already exists") != -1) {
                newT = false;
            }
            log.error((Object)"Problem creating table.", (Throwable)e);
        }
        String[] setupData = new String[]{"create index iKEY on " + tableName + " (CACHE_KEY, REGION)"};
        if (newT) {
            int i = 1;
            while (i < setupData.length) {
                try {
                    sStatement.executeQuery(setupData[i]);
                }
                catch (SQLException e) {
                    log.error((Object)("Exception caught when creating index." + e));
                }
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

