/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.remote.RemoteCache;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.engine.CacheAdaptor;
import org.apache.jcs.engine.CacheEventQueueFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;

public class RemoteCacheNoWait
implements AuxiliaryCache {
    private static final long serialVersionUID = -3104089136003714717L;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWait == null ? (class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWait = RemoteCacheNoWait.class$("org.apache.jcs.auxiliary.remote.RemoteCacheNoWait")) : class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWait));
    private final RemoteCache cache;
    private ICacheEventQueue q;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWait;

    public RemoteCacheNoWait(RemoteCache cache) {
        this.cache = cache;
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.q = fact.createCacheEventQueue(new CacheAdaptor(cache), cache.getListenerId(), cache.getCacheName(), cache.getAuxiliaryCacheAttributes().getEventQueuePoolName(), cache.getAuxiliaryCacheAttributes().getEventQueueTypeFactoryCode());
        if (cache.getStatus() == 3) {
            this.q.destroy();
        }
    }

    public void update(ICacheElement ce) throws IOException {
        try {
            this.q.addPutEvent(ce);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
            throw ex;
        }
    }

    public ICacheElement get(Serializable key) throws IOException {
        try {
            return this.cache.get(key);
        }
        catch (UnmarshalException ue) {
            log.debug((Object)"Retrying the get owing to UnmarshalException...");
            try {
                return this.cache.get(key);
            }
            catch (IOException ex) {
                log.debug((Object)"Failed in retrying the get for the second time.");
                this.q.destroy();
            }
        }
        catch (IOException ex) {
            this.q.destroy();
            throw ex;
        }
        return null;
    }

    public Set getGroupKeys(String groupName) throws IOException {
        return this.cache.getGroupKeys(groupName);
    }

    public boolean remove(Serializable key) throws IOException {
        try {
            this.q.addRemoveEvent(key);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
            throw ex;
        }
        return false;
    }

    public void removeAll() throws IOException {
        try {
            this.q.addRemoveAllEvent();
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
            throw ex;
        }
    }

    public void dispose() {
        try {
            this.q.addDisposeEvent();
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
        }
    }

    public int getSize() {
        return this.cache.getSize();
    }

    public int getCacheType() {
        return 4;
    }

    public int getStatus() {
        return this.q.isWorking() ? this.cache.getStatus() : 3;
    }

    public String getCacheName() {
        return this.cache.getCacheName();
    }

    public void fixCache(IRemoteCacheService remote) {
        this.cache.fixCache(remote);
        this.resetEventQ();
    }

    public void resetEventQ() {
        if (this.q.isWorking()) {
            this.q.destroy();
        }
        CacheEventQueueFactory fact = new CacheEventQueueFactory();
        this.q = fact.createCacheEventQueue(new CacheAdaptor(this.cache), this.cache.getListenerId(), this.cache.getCacheName(), this.cache.getAuxiliaryCacheAttributes().getEventQueuePoolName(), this.cache.getAuxiliaryCacheAttributes().getEventQueueTypeFactoryCode());
    }

    protected RemoteCache getRemoteCache() {
        return this.cache;
    }

    public String toString() {
        return "RemoteCacheNoWait: " + this.cache.toString();
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Remote Cache No Wait");
        ArrayList<IStatElement> elems = new ArrayList<IStatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Status");
        int status = this.getStatus();
        if (status == 3) {
            se.setData("ERROR");
        } else if (status == 1) {
            se.setData("ALIVE");
        } else if (status == 2) {
            se.setData("DISPOSED");
        } else {
            se.setData("" + status);
        }
        elems.add(se);
        IStats cStats = this.cache.getStatistics();
        IStatElement[] cSEs = cStats.getStatElements();
        List<IStatElement> cL = Arrays.asList(cSEs);
        elems.addAll(cL);
        IStats eqStats = this.q.getStatistics();
        IStatElement[] eqSEs = eqStats.getStatElements();
        List<IStatElement> eqL = Arrays.asList(eqSEs);
        elems.addAll(eqL);
        IStatElement[] ses = elems.toArray(new StatElement[0]);
        stats.setStatElements(ses);
        return stats;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

