/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine;

import EDU.oswego.cs.dl.util.concurrent.BoundedBuffer;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.behavior.ICacheListener;
import org.apache.jcs.engine.stats.StatElement;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStatElement;
import org.apache.jcs.engine.stats.behavior.IStats;
import org.apache.jcs.utils.threadpool.ThreadPool;
import org.apache.jcs.utils.threadpool.ThreadPoolManager;

public class PooledCacheEventQueue
implements ICacheEventQueue {
    private static final int queueType = 1;
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$engine$PooledCacheEventQueue == null ? (class$org$apache$jcs$engine$PooledCacheEventQueue = PooledCacheEventQueue.class$("org.apache.jcs.engine.PooledCacheEventQueue")) : class$org$apache$jcs$engine$PooledCacheEventQueue));
    private int waitToDieMillis = 10000;
    private ICacheListener listener;
    private long listenerId;
    private String cacheName;
    private int maxFailure;
    private int waitBeforeRetry;
    private boolean destroyed = true;
    private boolean working = true;
    private ThreadPool pool = null;
    static /* synthetic */ Class class$org$apache$jcs$engine$PooledCacheEventQueue;

    public PooledCacheEventQueue(ICacheListener listener, long listenerId, String cacheName, int maxFailure, int waitBeforeRetry, String threadPoolName) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listener = listener;
        this.listenerId = listenerId;
        this.cacheName = cacheName;
        this.maxFailure = maxFailure <= 0 ? 3 : maxFailure;
        int n = this.waitBeforeRetry = waitBeforeRetry <= 0 ? 500 : waitBeforeRetry;
        if (threadPoolName == null) {
            threadPoolName = "cache_event_queue";
        }
        this.pool = ThreadPoolManager.getInstance().getPool(threadPoolName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Constructed: " + this));
        }
    }

    public int getQueueType() {
        return 1;
    }

    public synchronized void stopProcessing() {
        this.destroyed = true;
    }

    public int getWaitToDieMillis() {
        return this.waitToDieMillis;
    }

    public void setWaitToDieMillis(int wtdm) {
        this.waitToDieMillis = wtdm;
    }

    public String toString() {
        return "CacheEventQueue [listenerId=" + this.listenerId + ", cacheName=" + this.cacheName + "]";
    }

    public boolean isAlive() {
        return !this.destroyed;
    }

    public void setAlive(boolean aState) {
        this.destroyed = !aState;
    }

    public long getListenerId() {
        return this.listenerId;
    }

    public synchronized void destroy() {
        if (!this.destroyed) {
            this.destroyed = true;
            this.pool.getPool().interruptAll();
            log.info((Object)("Cache event queue destroyed: " + this));
        }
    }

    public synchronized void addPutEvent(ICacheElement ce) throws IOException {
        if (this.isWorking()) {
            this.put(new PutEvent(ce));
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Not enqueuing Put Event for [" + this + "] because it's non-functional."));
        }
    }

    public synchronized void addRemoveEvent(Serializable key) throws IOException {
        if (this.isWorking()) {
            this.put(new RemoveEvent(key));
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Not enqueuing Remove Event for [" + this + "] because it's non-functional."));
        }
    }

    public synchronized void addRemoveAllEvent() throws IOException {
        if (this.isWorking()) {
            this.put(new RemoveAllEvent());
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Not enqueuing RemoveAll Event for [" + this + "] because it's non-functional."));
        }
    }

    public synchronized void addDisposeEvent() throws IOException {
        if (this.isWorking()) {
            this.put(new DisposeEvent());
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Not enqueuing Dispose Event for [" + this + "] because it's non-functional."));
        }
    }

    private void put(AbstractCacheEvent event) {
        try {
            this.pool.execute(event);
        }
        catch (InterruptedException e) {
            log.error((Object)e);
        }
    }

    public String getStats() {
        return this.getStatistics().toString();
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Pooled Cache Event Queue");
        ArrayList<StatElement> elems = new ArrayList<StatElement>();
        StatElement se = null;
        se = new StatElement();
        se.setName("Working");
        se.setData("" + this.working);
        elems.add(se);
        se = new StatElement();
        se.setName("Destroyed");
        se.setData("" + this.isAlive());
        elems.add(se);
        se = new StatElement();
        se.setName("Empty");
        se.setData("" + this.isEmpty());
        elems.add(se);
        if (this.pool.getQueue() != null && this.pool.getQueue() instanceof BoundedBuffer) {
            BoundedBuffer bb = (BoundedBuffer)this.pool.getQueue();
            se = new StatElement();
            se.setName("Queue Size");
            se.setData("" + bb.size());
            elems.add(se);
            se = new StatElement();
            se.setName("Queue Capacity");
            se.setData("" + bb.capacity());
            elems.add(se);
        }
        se = new StatElement();
        se.setName("Pool Size");
        se.setData("" + this.pool.getPool().getPoolSize());
        elems.add(se);
        se = new StatElement();
        se.setName("Maximum Pool Size");
        se.setData("" + this.pool.getPool().getMaximumPoolSize());
        elems.add(se);
        IStatElement[] ses = elems.toArray(new StatElement[elems.size()]);
        stats.setStatElements(ses);
        return stats;
    }

    public boolean isWorking() {
        return this.working;
    }

    public void setWorking(boolean isWorkingArg) {
        this.working = isWorkingArg;
    }

    public boolean isEmpty() {
        if (this.pool.getQueue() == null) {
            return this.pool.getQueue().peek() == null;
        }
        if (this.pool.getQueue() instanceof BoundedBuffer) {
            BoundedBuffer bb = (BoundedBuffer)this.pool.getQueue();
            return bb.size() == 0;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DisposeEvent
    extends AbstractCacheEvent {
        private DisposeEvent() {
        }

        protected void doRun() throws IOException {
            PooledCacheEventQueue.this.listener.handleDispose(PooledCacheEventQueue.this.cacheName);
        }

        public String toString() {
            return "DisposeEvent";
        }
    }

    private class RemoveAllEvent
    extends AbstractCacheEvent {
        private RemoveAllEvent() {
        }

        protected void doRun() throws IOException {
            PooledCacheEventQueue.this.listener.handleRemoveAll(PooledCacheEventQueue.this.cacheName);
        }

        public String toString() {
            return "RemoveAllEvent";
        }
    }

    private class RemoveEvent
    extends AbstractCacheEvent {
        private Serializable key;

        RemoveEvent(Serializable key) throws IOException {
            this.key = key;
        }

        protected void doRun() throws IOException {
            PooledCacheEventQueue.this.listener.handleRemove(PooledCacheEventQueue.this.cacheName, this.key);
        }

        public String toString() {
            return "RemoveEvent for " + this.key;
        }
    }

    private class PutEvent
    extends AbstractCacheEvent {
        private ICacheElement ice;

        PutEvent(ICacheElement ice) throws IOException {
            this.ice = ice;
        }

        protected void doRun() throws IOException {
            PooledCacheEventQueue.this.listener.handlePut(this.ice);
        }

        public String toString() {
            return "PutEvent for key: " + this.ice.getKey() + " value: " + this.ice.getVal();
        }
    }

    private abstract class AbstractCacheEvent
    implements Runnable {
        int failures = 0;
        boolean done = false;

        private AbstractCacheEvent() {
        }

        public void run() {
            try {
                this.doRun();
            }
            catch (IOException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)e);
                }
                if (++this.failures >= PooledCacheEventQueue.this.maxFailure) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Error while running event from Queue: " + this + ". Dropping Event and marking Event Queue as non-functional."));
                    }
                    PooledCacheEventQueue.this.setWorking(false);
                    PooledCacheEventQueue.this.setAlive(false);
                    return;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)("Error while running event from Queue: " + this + ". Retrying..."));
                }
                try {
                    Thread.sleep(PooledCacheEventQueue.this.waitBeforeRetry);
                    this.run();
                }
                catch (InterruptedException ie) {
                    if (log.isErrorEnabled()) {
                        log.warn((Object)("Interrupted while sleeping for retry on event " + this + "."));
                    }
                    PooledCacheEventQueue.this.setWorking(false);
                    PooledCacheEventQueue.this.setAlive(false);
                }
            }
        }

        protected abstract void doRun() throws IOException;
    }
}

