/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.memory;

import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICompositeCacheAttributes;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.group.GroupAttrName;
import org.apache.jcs.engine.control.group.GroupId;
import org.apache.jcs.engine.memory.MemoryCache;
import org.apache.jcs.engine.memory.shrinking.ShrinkerThread;
import org.apache.jcs.engine.stats.Stats;
import org.apache.jcs.engine.stats.behavior.IStats;

public abstract class AbstractMemoryCache
implements MemoryCache,
Serializable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$engine$memory$AbstractMemoryCache == null ? (class$org$apache$jcs$engine$memory$AbstractMemoryCache = AbstractMemoryCache.class$("org.apache.jcs.engine.memory.AbstractMemoryCache")) : class$org$apache$jcs$engine$memory$AbstractMemoryCache));
    private static final int DEFAULT_CHUNK_SIZE = 2;
    protected String cacheName;
    protected Map map = new Hashtable();
    public IElementAttributes attr;
    public ICompositeCacheAttributes cattr;
    protected CompositeCache cache;
    protected int status = 3;
    protected int chunkSize = 2;
    private static ClockDaemon shrinkerDaemon;
    static /* synthetic */ Class class$org$apache$jcs$engine$memory$AbstractMemoryCache;

    public synchronized void initialize(CompositeCache hub) {
        this.cacheName = hub.getCacheName();
        this.cattr = hub.getCacheAttributes();
        this.cache = hub;
        this.status = 1;
        if (this.cattr.getUseMemoryShrinker()) {
            if (shrinkerDaemon == null) {
                shrinkerDaemon = new ClockDaemon();
                shrinkerDaemon.setThreadFactory((ThreadFactory)new MyThreadFactory());
            }
            shrinkerDaemon.executePeriodically(this.cattr.getShrinkerIntervalSeconds() * 1000L, (Runnable)new ShrinkerThread(this), false);
        }
    }

    public abstract boolean remove(Serializable var1) throws IOException;

    public abstract ICacheElement get(Serializable var1) throws IOException;

    public abstract ICacheElement getQuiet(Serializable var1) throws IOException;

    public abstract void update(ICacheElement var1) throws IOException;

    public abstract Object[] getKeyArray();

    public void removeAll() throws IOException {
        this.map = new Hashtable();
    }

    public void dispose() throws IOException {
        log.info((Object)"Memory Cache dispose called.  Shutting down shrinker thread if it is running.");
        if (shrinkerDaemon != null) {
            shrinkerDaemon.shutDown();
        }
    }

    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Abstract Memory Cache");
        return stats;
    }

    public int getSize() {
        return this.map.size();
    }

    public int getStatus() {
        return this.status;
    }

    public String getCacheName() {
        return this.cattr.getCacheName();
    }

    public void waterfal(ICacheElement ce) throws IOException {
        this.cache.spoolToDisk(ce);
    }

    public Iterator getIterator() {
        return this.map.entrySet().iterator();
    }

    public ICompositeCacheAttributes getCacheAttributes() {
        return this.cattr;
    }

    public void setCacheAttributes(ICompositeCacheAttributes cattr) {
        this.cattr = cattr;
    }

    public CompositeCache getCompositeCache() {
        return this.cache;
    }

    public Set getGroupKeys(String groupName) {
        GroupId groupId = new GroupId(this.getCacheName(), groupName);
        HashSet<Object> keys = new HashSet<Object>();
        Map map = this.map;
        synchronized (map) {
            Iterator itr = this.map.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                Object k = entry.getKey();
                if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(groupId)) continue;
                keys.add(((GroupAttrName)k).attrName);
            }
        }
        return keys;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MyThreadFactory
    implements ThreadFactory {
        MyThreadFactory() {
        }

        public Thread newThread(Runnable runner) {
            Thread t = new Thread(runner);
            t.setDaemon(true);
            t.setPriority(1);
            return t;
        }
    }
}

