/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.utils.access;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.jcs.utils.access.JCSWorkerHelper;

public class JCSWorker {
    private static final Log logger = LogFactory.getLog((Class)(class$org$apache$jcs$utils$access$JCSWorker == null ? (class$org$apache$jcs$utils$access$JCSWorker = JCSWorker.class$("org.apache.jcs.utils.access.JCSWorker")) : class$org$apache$jcs$utils$access$JCSWorker));
    private JCS cache;
    private static volatile Map map = new HashMap();
    private String region;
    static /* synthetic */ Class class$org$apache$jcs$utils$access$JCSWorker;

    public JCSWorker(String aRegion) {
        this.region = aRegion;
        try {
            this.cache = JCS.getInstance(aRegion);
        }
        catch (CacheException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String getRegion() {
        return this.region;
    }

    public Object getResult(Serializable aKey, JCSWorkerHelper aWorker) throws Exception {
        return this.run(aKey, null, aWorker);
    }

    public Object getResult(Serializable aKey, String aGroup, JCSWorkerHelper aWorker) throws Exception {
        return this.run(aKey, aGroup, aWorker);
    }

    private Object run(Serializable aKey, String aGroup, JCSWorkerHelper aHelper) throws Exception {
        Object object;
        Object result = null;
        JCSWorkerHelper helper = null;
        Map map = JCSWorker.map;
        synchronized (map) {
            helper = (JCSWorkerHelper)JCSWorker.map.get(this.getRegion() + aKey);
            if (helper == null) {
                JCSWorker.map.put(this.getRegion() + aKey, aHelper);
            }
        }
        if (helper != null) {
            object = helper;
            synchronized (object) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Found a worker allready doing this work (" + this.getRegion() + ":" + aKey + ")."));
                }
                if (!helper.isFinished()) {
                    helper.wait();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Another thread finished our work for us. Using thoes results instead. (" + this.getRegion() + ":" + aKey + ")."));
                }
            }
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getRegion() + " is doing the work."));
            }
            result = null;
            result = aGroup != null ? this.cache.getFromGroup(aKey, aGroup) : this.cache.get(aKey);
            if (result == null) {
                result = aHelper.doWork();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Work Done, caching: key:" + aKey + ", group:" + aGroup + ", result:" + result + "."));
                }
                if (aGroup != null) {
                    this.cache.putInGroup(aKey, aGroup, result);
                } else {
                    this.cache.put(aKey, result);
                }
            }
            object = result;
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(this.getRegion() + ":" + aKey + " entered finally."));
            }
            Map map2 = JCSWorker.map;
            synchronized (map2) {
                if (helper == null) {
                    JCSWorker.map.remove(this.getRegion() + aKey);
                }
                JCSWorker jCSWorker = this;
                synchronized (jCSWorker) {
                    aHelper.setFinished(true);
                    this.notifyAll();
                }
            }
            throw throwable;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.getRegion() + ":" + aKey + " entered finally."));
        }
        Map map3 = JCSWorker.map;
        synchronized (map3) {
            if (helper == null) {
                JCSWorker.map.remove(this.getRegion() + aKey);
            }
            JCSWorker jCSWorker = this;
            synchronized (jCSWorker) {
                aHelper.setFinished(true);
                this.notifyAll();
            }
        }
        return object;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

