/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Barrier;
import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;

public class CyclicBarrier
implements Barrier {
    protected final int parties_;
    protected boolean broken_ = false;
    protected Runnable barrierCommand_ = null;
    protected int count_;
    protected int resets_ = 0;

    public CyclicBarrier(int parties) {
        this(parties, null);
    }

    public CyclicBarrier(int parties, Runnable command) {
        if (parties <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties_ = parties;
        this.count_ = parties;
        this.barrierCommand_ = command;
    }

    public synchronized Runnable setBarrierCommand(Runnable command) {
        Runnable old = this.barrierCommand_;
        this.barrierCommand_ = command;
        return old;
    }

    public synchronized boolean broken() {
        return this.broken_;
    }

    public synchronized void restart() {
        this.broken_ = false;
        ++this.resets_;
        this.count_ = this.parties_;
        this.notifyAll();
    }

    public int parties() {
        return this.parties_;
    }

    public int barrier() throws BrokenBarrierException, InterruptedException {
        return this.doBarrier(false, 0L);
    }

    public int attemptBarrier(long msecs) throws BrokenBarrierException, TimeoutException, InterruptedException {
        return this.doBarrier(true, msecs);
    }

    protected synchronized int doBarrier(boolean timed, long msecs) throws BrokenBarrierException, TimeoutException, InterruptedException {
        int index = --this.count_;
        if (this.broken_) {
            throw new BrokenBarrierException(index);
        }
        if (Thread.interrupted()) {
            this.broken_ = true;
            this.notifyAll();
            throw new InterruptedException();
        }
        if (index == 0) {
            this.count_ = this.parties_;
            ++this.resets_;
            this.notifyAll();
            try {
                if (this.barrierCommand_ != null) {
                    this.barrierCommand_.run();
                }
                int n = 0;
                return n;
            }
            catch (RuntimeException ex) {
                this.broken_ = true;
                int n = 0;
                return n;
            }
        }
        if (timed && msecs <= (long)0) {
            this.broken_ = true;
            this.notifyAll();
            throw new TimeoutException(msecs);
        }
        int r = this.resets_;
        long startTime = timed ? System.currentTimeMillis() : 0L;
        long waitTime = msecs;
        do {
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException ex) {
                if (this.resets_ == r) {
                    this.broken_ = true;
                    this.notifyAll();
                    throw ex;
                }
                Thread.currentThread().interrupt();
            }
            if (this.broken_) {
                throw new BrokenBarrierException(index);
            }
            if (r == this.resets_) continue;
            return index;
        } while (!timed || (waitTime = msecs - (System.currentTimeMillis() - startTime)) > (long)0);
        this.broken_ = true;
        this.notifyAll();
        throw new TimeoutException(msecs);
    }
}

