/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;

public class FIFOReadWriteLock
implements ReadWriteLock {
    protected final FIFOSemaphore entryLock = new FIFOSemaphore(1L);
    protected volatile int readers;
    protected int exreaders;
    protected final Sync readerSync = new ReaderSync();
    protected final Sync writerSync = new WriterSync();

    protected void acquireRead() throws InterruptedException {
        this.entryLock.acquire();
        ++this.readers;
        this.entryLock.release();
    }

    protected synchronized void releaseRead() {
        if (++this.exreaders == this.readers) {
            this.notify();
        }
    }

    protected void acquireWrite() throws InterruptedException {
        this.entryLock.acquire();
        int r = this.readers;
        try {
            FIFOReadWriteLock fIFOReadWriteLock = this;
            synchronized (fIFOReadWriteLock) {
                try {
                    while (this.exreaders != r) {
                        this.wait();
                    }
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }
        catch (InterruptedException ie) {
            this.entryLock.release();
            throw ie;
        }
    }

    protected void releaseWrite() {
        this.entryLock.release();
    }

    protected boolean attemptRead(long msecs) throws InterruptedException {
        if (!this.entryLock.attempt(msecs)) {
            return false;
        }
        ++this.readers;
        this.entryLock.release();
        return true;
    }

    protected boolean attemptWrite(long msecs) throws InterruptedException {
        long startTime;
        long l = startTime = msecs <= (long)0 ? 0L : System.currentTimeMillis();
        if (!this.entryLock.attempt(msecs)) {
            return false;
        }
        int r = this.readers;
        try {
            FIFOReadWriteLock fIFOReadWriteLock = this;
            synchronized (fIFOReadWriteLock) {
                boolean bl;
                try {
                    while (this.exreaders != r) {
                        long timeLeft;
                        long l2 = timeLeft = msecs <= (long)0 ? 0L : msecs - (System.currentTimeMillis() - startTime);
                        if (timeLeft <= (long)0) {
                            this.entryLock.release();
                            boolean bl2 = false;
                            Object var11_9 = null;
                            return bl2;
                        }
                        this.wait(timeLeft);
                    }
                    bl = true;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    throw throwable;
                }
                Object var11_10 = null;
                return bl;
            }
        }
        catch (InterruptedException ie) {
            this.entryLock.release();
            throw ie;
        }
    }

    public Sync writeLock() {
        return this.writerSync;
    }

    public Sync readLock() {
        return this.readerSync;
    }

    protected class WriterSync
    implements Sync {
        protected WriterSync() {
        }

        public void acquire() throws InterruptedException {
            FIFOReadWriteLock.this.acquireWrite();
        }

        public void release() {
            FIFOReadWriteLock.this.releaseWrite();
        }

        public boolean attempt(long msecs) throws InterruptedException {
            return FIFOReadWriteLock.this.attemptWrite(msecs);
        }
    }

    protected class ReaderSync
    implements Sync {
        protected ReaderSync() {
        }

        public void acquire() throws InterruptedException {
            FIFOReadWriteLock.this.acquireRead();
        }

        public void release() {
            FIFOReadWriteLock.this.releaseRead();
        }

        public boolean attempt(long msecs) throws InterruptedException {
            return FIFOReadWriteLock.this.attemptRead(msecs);
        }
    }
}

