/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.SynchronousChannel;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PooledExecutor
extends ThreadFactoryUser
implements Executor {
    public static final int DEFAULT_MAXIMUMPOOLSIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MINIMUMPOOLSIZE = 1;
    public static final long DEFAULT_KEEPALIVETIME = 60000L;
    protected int maximumPoolSize_ = Integer.MAX_VALUE;
    protected int minimumPoolSize_ = 1;
    protected int poolSize_ = 0;
    protected long keepAliveTime_ = 60000L;
    protected boolean shutdown_ = false;
    protected final Channel handOff_;
    protected final Map threads_;
    protected BlockedExecutionHandler blockedExecutionHandler_;

    public PooledExecutor() {
        this(new SynchronousChannel(), Integer.MAX_VALUE);
    }

    public PooledExecutor(int maxPoolSize) {
        this(new SynchronousChannel(), maxPoolSize);
    }

    public PooledExecutor(Channel channel) {
        this(channel, Integer.MAX_VALUE);
    }

    public PooledExecutor(Channel channel, int maxPoolSize) {
        this.maximumPoolSize_ = maxPoolSize;
        this.handOff_ = channel;
        this.runWhenBlocked();
        this.threads_ = new HashMap();
    }

    public synchronized int getMaximumPoolSize() {
        return this.maximumPoolSize_;
    }

    public synchronized void setMaximumPoolSize(int newMaximum) {
        if (newMaximum <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize_ = newMaximum;
    }

    public synchronized int getMinimumPoolSize() {
        return this.minimumPoolSize_;
    }

    public synchronized void setMinimumPoolSize(int newMinimum) {
        if (newMinimum < 0) {
            throw new IllegalArgumentException();
        }
        this.minimumPoolSize_ = newMinimum;
    }

    public synchronized int getPoolSize() {
        return this.poolSize_;
    }

    public synchronized long getKeepAliveTime() {
        return this.keepAliveTime_;
    }

    public synchronized void setKeepAliveTime(long msecs) {
        this.keepAliveTime_ = msecs;
    }

    public synchronized BlockedExecutionHandler getBlockedExecutionHandler() {
        return this.blockedExecutionHandler_;
    }

    public synchronized void setBlockedExecutionHandler(BlockedExecutionHandler h) {
        this.blockedExecutionHandler_ = h;
    }

    protected void addThread(Runnable command) {
        Worker worker = new Worker(command);
        Thread thread = this.getThreadFactory().newThread(worker);
        this.threads_.put(worker, thread);
        ++this.poolSize_;
        thread.start();
    }

    public int createThreads(int numberOfThreads) {
        int ncreated = 0;
        for (int i = 0; i < numberOfThreads; ++i) {
            PooledExecutor pooledExecutor = this;
            synchronized (pooledExecutor) {
                Object var6_5;
                try {
                    if (this.poolSize_ >= this.maximumPoolSize_) {
                        var6_5 = null;
                        break;
                    }
                    this.addThread(null);
                    ++ncreated;
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    throw throwable;
                }
                var6_5 = null;
                {
                    continue;
                }
            }
        }
        return ncreated;
    }

    public synchronized void interruptAll() {
        Iterator it = this.threads_.values().iterator();
        while (it.hasNext()) {
            Thread t = (Thread)it.next();
            t.interrupt();
        }
    }

    public void shutdownNow() {
        this.shutdownNow(new DiscardWhenBlocked());
    }

    public synchronized void shutdownNow(BlockedExecutionHandler handler) {
        this.setBlockedExecutionHandler(handler);
        this.shutdown_ = true;
        this.maximumPoolSize_ = 0;
        this.minimumPoolSize_ = 0;
        this.interruptAll();
    }

    public void shutdownAfterProcessingCurrentlyQueuedTasks() {
        this.shutdownAfterProcessingCurrentlyQueuedTasks(new DiscardWhenBlocked());
    }

    public synchronized void shutdownAfterProcessingCurrentlyQueuedTasks(BlockedExecutionHandler handler) {
        this.setBlockedExecutionHandler(handler);
        this.shutdown_ = true;
        if (this.poolSize_ == 0) {
            this.maximumPoolSize_ = 0;
            this.minimumPoolSize_ = 0;
        }
    }

    public synchronized boolean isTerminatedAfterShutdown() {
        return this.shutdown_ && this.poolSize_ == 0;
    }

    public synchronized boolean awaitTerminationAfterShutdown(long maxWaitTime) throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        if (this.poolSize_ == 0) {
            return true;
        }
        long waitTime = maxWaitTime;
        if (waitTime <= (long)0) {
            return false;
        }
        long start = System.currentTimeMillis();
        do {
            this.wait(waitTime);
            if (this.poolSize_ != 0) continue;
            return true;
        } while ((waitTime = maxWaitTime - (System.currentTimeMillis() - start)) > (long)0);
        return false;
    }

    public synchronized void awaitTerminationAfterShutdown() throws InterruptedException {
        if (!this.shutdown_) {
            throw new IllegalStateException();
        }
        while (this.poolSize_ > 0) {
            this.wait();
        }
    }

    public List drain() {
        boolean wasInterrupted = false;
        Vector<Object> tasks = new Vector<Object>();
        while (true) {
            try {
                Object x = this.handOff_.poll(0L);
                if (x == null) break;
                tasks.addElement(x);
            }
            catch (InterruptedException ex) {
                wasInterrupted = true;
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return tasks;
    }

    protected synchronized void workerDone(Worker w) {
        this.threads_.remove(w);
        if (--this.poolSize_ == 0 && this.shutdown_) {
            this.minimumPoolSize_ = 0;
            this.maximumPoolSize_ = 0;
            this.notifyAll();
        }
        if (this.poolSize_ == 0 || this.poolSize_ < this.minimumPoolSize_) {
            try {
                Runnable r = (Runnable)this.handOff_.poll(0L);
                if (r != null && !this.shutdown_) {
                    this.addThread(r);
                }
            }
            catch (InterruptedException ie) {
                return;
            }
        }
    }

    protected Runnable getTask() throws InterruptedException {
        long waitTime;
        PooledExecutor pooledExecutor = this;
        synchronized (pooledExecutor) {
            try {
                if (this.poolSize_ > this.maximumPoolSize_) {
                    Runnable runnable = null;
                    Object var6_3 = null;
                    return runnable;
                }
                waitTime = this.shutdown_ ? 0L : this.keepAliveTime_;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                throw throwable;
            }
            Object var6_4 = null;
            {
            }
        }
        if (waitTime >= (long)0) {
            return (Runnable)this.handOff_.poll(waitTime);
        }
        return (Runnable)this.handOff_.take();
    }

    public void runWhenBlocked() {
        this.setBlockedExecutionHandler(new RunWhenBlocked());
    }

    public void waitWhenBlocked() {
        this.setBlockedExecutionHandler(new WaitWhenBlocked());
    }

    public void discardWhenBlocked() {
        this.setBlockedExecutionHandler(new DiscardWhenBlocked());
    }

    public void abortWhenBlocked() {
        this.setBlockedExecutionHandler(new AbortWhenBlocked());
    }

    public void discardOldestWhenBlocked() {
        this.setBlockedExecutionHandler(new DiscardOldestWhenBlocked());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(Runnable command) throws InterruptedException {
        do {
            PooledExecutor pooledExecutor = this;
            synchronized (pooledExecutor) {
                Object var5_4;
                block6: {
                    try {
                        if (this.shutdown_) break block6;
                        int size = this.poolSize_;
                        if (size < this.minimumPoolSize_) {
                            this.addThread(command);
                            return;
                        }
                        if (this.handOff_.offer(command, 0L)) {
                            return;
                        }
                        if (size >= this.maximumPoolSize_) break block6;
                        this.addThread(command);
                        return;
                    }
                    catch (Throwable throwable) {
                        var5_4 = null;
                        throw throwable;
                    }
                }
                var5_4 = null;
            }
        } while (!this.getBlockedExecutionHandler().blockedAction(command));
    }

    protected class DiscardOldestWhenBlocked
    implements BlockedExecutionHandler {
        protected DiscardOldestWhenBlocked() {
        }

        public boolean blockedAction(Runnable command) throws InterruptedException {
            PooledExecutor.this.handOff_.poll(0L);
            if (!PooledExecutor.this.handOff_.offer(command, 0L)) {
                command.run();
            }
            return true;
        }
    }

    protected class AbortWhenBlocked
    implements BlockedExecutionHandler {
        protected AbortWhenBlocked() {
        }

        public boolean blockedAction(Runnable command) {
            throw new RuntimeException("Pool is blocked");
        }
    }

    protected class DiscardWhenBlocked
    implements BlockedExecutionHandler {
        protected DiscardWhenBlocked() {
        }

        public boolean blockedAction(Runnable command) {
            return true;
        }
    }

    protected class WaitWhenBlocked
    implements BlockedExecutionHandler {
        protected WaitWhenBlocked() {
        }

        public boolean blockedAction(Runnable command) throws InterruptedException {
            PooledExecutor pooledExecutor = PooledExecutor.this;
            synchronized (pooledExecutor) {
                block3: {
                    try {
                        if (!PooledExecutor.this.shutdown_) break block3;
                        boolean bl = true;
                        Object var5_4 = null;
                        return bl;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        throw throwable;
                    }
                }
                Object var5_5 = null;
                {
                }
            }
            PooledExecutor.this.handOff_.put(command);
            return true;
        }
    }

    protected class RunWhenBlocked
    implements BlockedExecutionHandler {
        protected RunWhenBlocked() {
        }

        public boolean blockedAction(Runnable command) {
            command.run();
            return true;
        }
    }

    public interface BlockedExecutionHandler {
        public boolean blockedAction(Runnable var1) throws InterruptedException;
    }

    protected class Worker
    implements Runnable {
        protected Runnable firstTask_;

        protected Worker(Runnable firstTask) {
            this.firstTask_ = firstTask;
        }

        public void run() {
            try {
                try {
                    Runnable task = this.firstTask_;
                    this.firstTask_ = null;
                    if (task != null) {
                        task.run();
                        task = null;
                    }
                    while ((task = PooledExecutor.this.getTask()) != null) {
                        task.run();
                        task = null;
                    }
                    Object var3_3 = null;
                    PooledExecutor.this.workerDone(this);
                }
                catch (InterruptedException interruptedException) {
                    Object var3_4 = null;
                    PooledExecutor.this.workerDone(this);
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                PooledExecutor.this.workerDone(this);
                throw throwable;
            }
        }
    }
}

