/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;

public class WaitableInt
extends SynchronizedInt {
    public WaitableInt(int initialValue) {
        super(initialValue);
    }

    public WaitableInt(int initialValue, Object lock) {
        super(initialValue, lock);
    }

    public int set(int newValue) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.lock_.notifyAll();
                int n = super.set(newValue);
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public boolean commit(int assumedValue, int newValue) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                boolean success = super.commit(assumedValue, newValue);
                if (success) {
                    this.lock_.notifyAll();
                }
                boolean bl = success;
                Object var7_6 = null;
                return bl;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                throw throwable;
            }
        }
    }

    public int increment() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.lock_.notifyAll();
                int n = super.increment();
                Object var4_3 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public int decrement() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.lock_.notifyAll();
                int n = super.decrement();
                Object var4_3 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public int add(int amount) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.lock_.notifyAll();
                int n = super.add(amount);
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public int subtract(int amount) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.lock_.notifyAll();
                int n = super.subtract(amount);
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public int multiply(int factor) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.lock_.notifyAll();
                int n = super.multiply(factor);
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public int divide(int factor) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.lock_.notifyAll();
                int n = super.divide(factor);
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public int complement() {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ = ~this.value_;
                this.lock_.notifyAll();
                int n = this.value_;
                Object var4_3 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                throw throwable;
            }
        }
    }

    public int and(int b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ = this.value_ & b;
                this.lock_.notifyAll();
                int n = this.value_;
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public int or(int b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ = this.value_ | b;
                this.lock_.notifyAll();
                int n = this.value_;
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public int xor(int b) {
        Object object = this.lock_;
        synchronized (object) {
            try {
                this.value_ = this.value_ ^ b;
                this.lock_.notifyAll();
                int n = this.value_;
                Object var5_4 = null;
                return n;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void whenEqual(int c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            try {
                while (this.value_ != c) {
                    this.lock_.wait();
                }
                if (action != null) {
                    action.run();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void whenNotEqual(int c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            try {
                while (this.value_ == c) {
                    this.lock_.wait();
                }
                if (action != null) {
                    action.run();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void whenLessEqual(int c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            try {
                while (this.value_ > c) {
                    this.lock_.wait();
                }
                if (action != null) {
                    action.run();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void whenLess(int c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            try {
                while (this.value_ >= c) {
                    this.lock_.wait();
                }
                if (action != null) {
                    action.run();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void whenGreaterEqual(int c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            try {
                while (this.value_ < c) {
                    this.lock_.wait();
                }
                if (action != null) {
                    action.run();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }

    public void whenGreater(int c, Runnable action) throws InterruptedException {
        Object object = this.lock_;
        synchronized (object) {
            try {
                while (this.value_ <= c) {
                    this.lock_.wait();
                }
                if (action != null) {
                    action.run();
                }
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
    }
}

